/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.inject.loader;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.ElementType;
import org.osgl.inject.Genie;
import org.osgl.inject.InjectException;
import org.osgl.inject.annotation.TypeOf;
import org.osgl.inject.loader.ElementLoaderBase;
import org.osgl.inject.loader.LoaderUtil;
import org.osgl.util.E;

public abstract class TypedElementLoader<T>
extends ElementLoaderBase<T> {
    @Override
    public final Iterable<T> load(Map<String, Object> options, BeanSpec container, Genie genie) {
        ElementType elementType = (ElementType)((Object)options.get("elementType"));
        boolean loadNonPublic = (Boolean)options.get("loadNonPublic");
        boolean loadRoot = (Boolean)options.get("loadRoot");
        Lang.Var typeVar = $.var((Object)((Object)elementType));
        Class<T> targetClass = this.targetClass((Lang.Var<ElementType>)typeVar, options, container);
        boolean loadAbstract = ((ElementType)((Object)typeVar.get())).loadAbstract() && (Boolean)options.get("loadAbstract") != false;
        List<Class<?>> classes = this.load(targetClass, loadNonPublic, loadAbstract, loadRoot);
        return ((ElementType)((Object)typeVar.get())).transform(classes, genie);
    }

    @Override
    public final Lang.Function<T, Boolean> filter(Map<String, Object> options, BeanSpec container) {
        Lang.Var typeVar = $.var((Object)((Object)((ElementType)((Object)options.get("elementType")))));
        final Class<T> baseClass = this.targetClass((Lang.Var<ElementType>)typeVar, options, container);
        final ElementType elementType = (ElementType)((Object)typeVar.get());
        final boolean loadNonPublic = (Boolean)options.get("loadNonPublic");
        final boolean loadAbstract = elementType.loadAbstract() && (Boolean)options.get("loadAbstract") != false;
        final boolean loadRoot = (Boolean)options.get("loadRoot");
        return new Lang.Predicate<T>(){

            public boolean test(T o) {
                if (elementType == ElementType.BEAN) {
                    Class<?> c = o.getClass();
                    return !(!loadNonPublic && !Modifier.isPublic(c.getModifiers()) || !baseClass.isAssignableFrom(c) || !c.isEnum() && !loadRoot && baseClass == c);
                }
                if (o instanceof Class) {
                    Class c = (Class)o;
                    int modifiers = c.getModifiers();
                    boolean yes = loadNonPublic || Modifier.isPublic(modifiers);
                    yes = yes && (loadAbstract || !Modifier.isAbstract(modifiers));
                    yes = yes && baseClass.isAssignableFrom(c);
                    yes = yes && (loadRoot || baseClass != c);
                    return yes;
                }
                return false;
            }
        };
    }

    protected abstract List<Class<? extends T>> load(Class<T> var1, boolean var2, boolean var3, boolean var4);

    private Class<T> targetClass(Lang.Var<ElementType> typeVar, Map<String, Object> options, BeanSpec container) {
        Object hint = options.get("value");
        E.illegalArgumentIf((!(hint instanceof Class) ? 1 : 0) != 0);
        Class<?> targetClass = (Class<?>)$.cast((Object)hint);
        Class<?> inferredTargetClass = LoaderUtil.targetClass(typeVar, container);
        if (null != inferredTargetClass) {
            if (TypeOf.PlaceHolder.class == targetClass) {
                targetClass = inferredTargetClass;
            } else if (!inferredTargetClass.isAssignableFrom(targetClass)) {
                throw new InjectException("specified class[%s] doesn't match the container spec: %s", targetClass, container);
            }
        } else if (TypeOf.PlaceHolder.class == targetClass && TypeOf.PlaceHolder.class == targetClass) {
            throw new InjectException("Cannot load element - target type info is missing", new Object[0]);
        }
        return (Class)$.cast(targetClass);
    }
}

