/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.inject.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import org.osgl.inject.util.SimpleAnnoInvocationHandler;
import org.osgl.util.C;

public class AnnotationUtil {
    public static <T extends Annotation> T declaredAnnotation(AnnotatedElement annotatedElement, Class<T> annoClass) {
        Annotation[] aa = annotatedElement.getDeclaredAnnotations();
        if (null == aa) {
            return null;
        }
        for (Annotation a : aa) {
            if (!annoClass.isInstance(a)) continue;
            return (T)a;
        }
        return null;
    }

    public static <T extends Annotation> T tagAnnotation(Annotation annotation, Class<T> tagClass) {
        Class<? extends Annotation> c = annotation.annotationType();
        for (Annotation a : c.getAnnotations()) {
            if (!tagClass.isInstance(a)) continue;
            return (T)a;
        }
        return null;
    }

    public static <T extends Annotation> T createAnnotation(Class<T> clazz, Map<String, Object> memberValues) {
        return (T)((Annotation)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, Annotation.class}, (InvocationHandler)new SimpleAnnoInvocationHandler(clazz, memberValues)));
    }

    public static <T extends Annotation> T createAnnotation(Class<T> clazz) {
        return (T)((Annotation)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, Annotation.class}, (InvocationHandler)new SimpleAnnoInvocationHandler(clazz, (Map<String, Object>)C.Map((Object[])new Object[0]))));
    }

    public static int hashCode(Annotation a) {
        int result = 0;
        Class<? extends Annotation> type = a.annotationType();
        for (Method m : type.getDeclaredMethods()) {
            try {
                Object value = m.invoke((Object)a, new Object[0]);
                if (value == null) {
                    throw new IllegalStateException(String.format("Annotation method %s returned null", m));
                }
                result += AnnotationUtil.hashMember(m.getName(), value);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    static int hashMember(String name, Object value) {
        int part1 = name.hashCode() * 127;
        if (value.getClass().isArray()) {
            return part1 ^ AnnotationUtil.arrayMemberHash(value.getClass().getComponentType(), value);
        }
        if (value instanceof Annotation) {
            return part1 ^ AnnotationUtil.hashCode((Annotation)value);
        }
        return part1 ^ value.hashCode();
    }

    private static int arrayMemberHash(Class<?> componentType, Object o) {
        if (componentType.equals(Byte.TYPE)) {
            return Arrays.hashCode((byte[])o);
        }
        if (componentType.equals(Short.TYPE)) {
            return Arrays.hashCode((short[])o);
        }
        if (componentType.equals(Integer.TYPE)) {
            return Arrays.hashCode((int[])o);
        }
        if (componentType.equals(Character.TYPE)) {
            return Arrays.hashCode((char[])o);
        }
        if (componentType.equals(Long.TYPE)) {
            return Arrays.hashCode((long[])o);
        }
        if (componentType.equals(Float.TYPE)) {
            return Arrays.hashCode((float[])o);
        }
        if (componentType.equals(Double.TYPE)) {
            return Arrays.hashCode((double[])o);
        }
        if (componentType.equals(Boolean.TYPE)) {
            return Arrays.hashCode((boolean[])o);
        }
        return Arrays.hashCode((Object[])o);
    }
}

