/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.inject.loader;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.ElementType;
import org.osgl.inject.Genie;
import org.osgl.inject.loader.ElementLoaderBase;
import org.osgl.inject.loader.LoaderUtil;
import org.osgl.util.E;

public abstract class AnnotatedElementLoader
extends ElementLoaderBase<Object> {
    @Override
    public Iterable<Object> load(Map<String, Object> options, BeanSpec container, Genie genie) {
        Object hint = options.get("value");
        E.illegalArgumentIf((!Annotation.class.isAssignableFrom((Class)hint) ? 1 : 0) != 0);
        boolean loadNonPublic = (Boolean)options.get("loadNonPublic");
        ElementType elementType = this.elementType(options, container);
        boolean loadAbstract = elementType.loadAbstract() && (Boolean)options.get("loadAbstract") != false;
        List<Class<?>> classes = this.load(AnnotatedElementLoader.annoClassFromHint(hint), loadNonPublic, loadAbstract);
        return elementType.transform(classes, genie);
    }

    protected abstract List<Class<?>> load(Class<? extends Annotation> var1, boolean var2, boolean var3);

    @Override
    public Osgl.Function filter(Map<String, Object> options, BeanSpec container) {
        Object hint = options.get("value");
        E.illegalArgumentIf((!Annotation.class.isAssignableFrom((Class)hint) ? 1 : 0) != 0);
        final Class<? extends Annotation> annoClass = AnnotatedElementLoader.annoClassFromHint(hint);
        final ElementType elementType = this.elementType(options, container);
        final boolean loadNonPublic = (Boolean)options.get("loadNonPublic");
        final boolean loadAbstract = elementType.loadAbstract() && (Boolean)options.get("loadAbstract") != false;
        return new Osgl.Predicate(){

            public boolean test(Object o) {
                if (elementType == ElementType.BEAN) {
                    Class<?> c = o.getClass();
                    return (loadNonPublic || Modifier.isPublic(c.getModifiers())) && c.isAnnotationPresent(annoClass);
                }
                if (o instanceof Class) {
                    Class c = (Class)o;
                    int modifiers = c.getModifiers();
                    boolean yes = loadNonPublic || Modifier.isPublic(modifiers);
                    yes = yes && (loadAbstract || !Modifier.isAbstract(modifiers));
                    yes = yes && c.isAnnotationPresent(annoClass);
                    return yes;
                }
                return false;
            }
        };
    }

    private static Class<? extends Annotation> annoClassFromHint(Object hint) {
        return (Class)$.cast((Object)hint);
    }

    private ElementType elementType(Map<String, Object> options, BeanSpec container) {
        ElementType type = (ElementType)((Object)options.get("elementType"));
        if (type == ElementType.CLASS) {
            return type;
        }
        Osgl.Var typeVar = $.var((Object)((Object)type));
        LoaderUtil.targetClass((Osgl.Var<ElementType>)typeVar, container);
        return (ElementType)((Object)typeVar.get());
    }
}

