package org.osgl.inject;

/*-
 * #%L
 * OSGL Genie
 * %%
 * Copyright (C) 2017 OSGL (Open Source General Library)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.lang.annotation.Annotation;

/**
 * Define the logic that needs to be invoked on the bean before return back.
 */
public interface PostConstructProcessor<T> {
    /**
     * Process a `T` typed bean with the relevant annotation instance.
     *
     * @param bean
     *      the bean to be processed
     * @param annotation
     *      the relevant annotation tagged on the parameter or field
     */
    void process(T bean, Annotation annotation);
}
