/**
 * Act `genie` is a dependency injection solution inspired by
 * [Feather](https://github.com/zsoltherpai/feather).
 *
 * `genie` support all features provided by `Feather` and more:
 *
 * * JSR330 dependency injection on Constructors/Fields/Methods
 * * {@link javax.inject.Qualifier} annotations
 * * {@link javax.inject.Scope} annotations
 * * {@link org.osgl.inject.annotation.LoadCollection} annotations
 * * {@link org.osgl.inject.annotation.LoadValue} annotations
 * * {@link javax.annotation.PostConstruct} semantic
 * * Scope defined by [cdi-api-1.2](http://docs.jboss.org/cdi/api/1.2/)
 * * Scope defined by [Google Guice](https://github.com/google/guice)
 * * [Feather](https://github.com/zsoltherpai/feather) style module/provider factory methods
 * * [Google Guice](https://github.com/google/guice) style module
 * * {@link org.osgl.inject.annotation.LoadCollection collection inject mechanism}
 * * {@link org.osgl.inject.annotation.LoadValue value inject mechanism}
 * * {@link org.osgl.inject.annotation.Configuration configuration inject mechanism}
 */
package org.osgl.inject;

/*-
 * #%L
 * OSGL Genie
 * %%
 * Copyright (C) 2017 OSGL (Open Source General Library)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
