/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.UnexpectedException;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.ElementLoaderProvider;
import org.osgl.inject.GenericTypedBeanLoader;
import org.osgl.inject.GeniePlugin;
import org.osgl.inject.InjectException;
import org.osgl.inject.InjectListener;
import org.osgl.inject.Injector;
import org.osgl.inject.Module;
import org.osgl.inject.NamedProvider;
import org.osgl.inject.PostConstructProcessor;
import org.osgl.inject.PostConstructProcessorInvoker;
import org.osgl.inject.PostConstructorInvoker;
import org.osgl.inject.ScopeCache;
import org.osgl.inject.ScopedProvider;
import org.osgl.inject.ValueLoaderFactory;
import org.osgl.inject.annotation.InjectTag;
import org.osgl.inject.annotation.PostConstructProcess;
import org.osgl.inject.annotation.Provided;
import org.osgl.inject.annotation.Provides;
import org.osgl.inject.annotation.RequestScoped;
import org.osgl.inject.annotation.SessionScoped;
import org.osgl.inject.annotation.StopInheritedScope;
import org.osgl.inject.provider.ArrayListProvider;
import org.osgl.inject.provider.ArrayProvider;
import org.osgl.inject.provider.ConcurrentMapProvider;
import org.osgl.inject.provider.DequeProvider;
import org.osgl.inject.provider.LazyProvider;
import org.osgl.inject.provider.LinkedHashMapProvider;
import org.osgl.inject.provider.LinkedListProvider;
import org.osgl.inject.provider.OsglListProvider;
import org.osgl.inject.provider.OsglMapProvider;
import org.osgl.inject.provider.OsglSetProvider;
import org.osgl.inject.provider.SortedMapProvider;
import org.osgl.inject.provider.SortedSetProvider;
import org.osgl.inject.util.AnnotationUtil;
import org.osgl.inject.util.SimpleSingletonScope;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;
import osgl.version.Version;

public final class Genie
implements Injector {
    public static final Version VERSION = Version.of(Genie.class);
    static final Logger logger = LogManager.get(Genie.class);
    private static final ThreadLocal<BeanSpec> TGT_SPEC = new ThreadLocal();
    private static final ThreadLocal<Integer> AFFINITY = new ThreadLocal();
    private static final Provider<BeanSpec> BEAN_SPEC_PROVIDER = new Provider<BeanSpec>(){

        public BeanSpec get() {
            return (BeanSpec)TGT_SPEC.get();
        }
    };
    private ConcurrentMap<BeanSpec, Provider<?>> registry = new ConcurrentHashMap();
    private ConcurrentMap<Class<?>, NamedProvider<?>> namedRegistry = new ConcurrentHashMap();
    private ConcurrentMap<Class, Provider> expressRegistry = new ConcurrentHashMap<Class, Provider>();
    private Set<Class<? extends Annotation>> qualifierRegistry = new HashSet<Class<? extends Annotation>>();
    private Set<Class<? extends Annotation>> injectTagRegistry = new HashSet<Class<? extends Annotation>>();
    private Map<Class<? extends Annotation>, Class<? extends Annotation>> scopeAliases = new HashMap<Class<? extends Annotation>, Class<? extends Annotation>>();
    private Map<Class<? extends Annotation>, ScopeCache> scopeProviders = new HashMap<Class<? extends Annotation>, ScopeCache>();
    private ConcurrentMap<Class<? extends Annotation>, PostConstructProcessor<?>> postConstructProcessors = new ConcurrentHashMap();
    private ConcurrentMap<Class, BeanSpec> beanSpecLookup = new ConcurrentHashMap<Class, BeanSpec>();
    private ConcurrentMap<Class, GenericTypedBeanLoader> genericTypedBeanLoaders = new ConcurrentHashMap<Class, GenericTypedBeanLoader>();
    private List<InjectListener> listeners = new ArrayList<InjectListener>();
    private boolean supportInjectionPoint = false;

    Genie(Object ... modules) {
        this.init(false, modules);
    }

    Genie(boolean noPlugin, Object ... modules) {
        this.init(noPlugin, modules);
    }

    private Genie(InjectListener listener, Object ... modules) {
        this.listeners.add(listener);
        this.init(false, modules);
    }

    private void init(boolean noPlugin, Object ... modules) {
        this.registerBuiltInProviders();
        if (!noPlugin) {
            this.registerBuiltInPlugins();
        }
        if (modules.length > 0) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object module : modules) {
                Class moduleClass;
                if (module instanceof InjectListener) {
                    this.listeners.add((InjectListener)module);
                } else if (module instanceof Class && InjectListener.class.isAssignableFrom(moduleClass = (Class)module)) {
                    this.listeners.add((InjectListener)$.newInstance((Class)moduleClass));
                }
                list.add(module);
            }
            for (Object e : list) {
                this.registerModule(e);
            }
        } else {
            this.registerModule(new Module(){

                @Override
                protected void configure() {
                    this.bind(ScopeCache.SingletonScope.class).to(new SimpleSingletonScope());
                }
            });
        }
        this.initScopeAliases();
    }

    public void supportInjectionPoint(boolean enabled) {
        this.supportInjectionPoint = enabled;
    }

    @Override
    public <T> T get(Class<T> type) {
        return (T)this.getProvider(type).get();
    }

    public <T> T get(BeanSpec beanSpec) {
        Provider<?> provider = this.findProvider(beanSpec, (Set<BeanSpec>)C.empty());
        return (T)provider.get();
    }

    public boolean hasProvider(Class<?> type) {
        return this.expressRegistry.containsKey(type);
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) {
        Provider<?> provider = (Provider<?>)this.expressRegistry.get(type);
        if (null == provider) {
            if (type.isArray()) {
                provider = ArrayProvider.of(type, this);
                this.expressRegistry.putIfAbsent(type, (Provider)provider);
                return provider;
            }
            BeanSpec spec = this.beanSpecOf(type);
            provider = this.findProvider(spec, (Set<BeanSpec>)C.empty());
            if (!$.isSimpleType(type)) {
                this.expressRegistry.putIfAbsent(type, provider);
            }
        }
        return provider;
    }

    public <T> void registerProvider(Class<? super T> type, Provider<? extends T> provider) {
        this.registerProvider(type, provider, true);
    }

    public <T> void registerNamedProvider(Class<? super T> type, NamedProvider<? extends T> provider) {
        this.namedRegistry.put(type, provider);
    }

    public void registerQualifiers(Class<? extends Annotation> ... qualifiers) {
        this.qualifierRegistry.addAll((Collection<Class<? extends Annotation>>)C.listOf((Object[])qualifiers));
    }

    public void registerQualifiers(Collection<Class<? extends Annotation>> qualifiers) {
        this.qualifierRegistry.addAll(qualifiers);
    }

    public void registerInjectTag(Class<? extends Annotation> ... injectTags) {
        this.injectTagRegistry.addAll((Collection<Class<? extends Annotation>>)C.listOf((Object[])injectTags));
    }

    public void registerScopeAlias(Class<? extends Annotation> scopeAnnotation, Class<? extends Annotation> scopeAlias) {
        this.scopeAliases.put(scopeAlias, scopeAnnotation);
    }

    public void registerScopeProvider(Class<? extends Annotation> scopeAnnotation, ScopeCache scopeCache) {
        this.scopeProviders.put(scopeAnnotation, scopeCache);
    }

    public void registerScopeProvider(Class<? extends Annotation> scopeAnnotation, Class<? extends ScopeCache> scopeCacheClass) {
        this.scopeProviders.put(scopeAnnotation, this.get(scopeCacheClass));
    }

    public void registerPostConstructProcessor(Class<? extends Annotation> annoClass, PostConstructProcessor<?> processor) {
        this.postConstructProcessors.put(annoClass, processor);
    }

    public <T> void registerGenericTypedBeanLoader(Class<T> type, GenericTypedBeanLoader<T> loader) {
        this.genericTypedBeanLoaders.put(type, loader);
    }

    @Override
    public boolean isScope(Class<? extends Annotation> annoClass) {
        if (Singleton.class == annoClass || SessionScoped.class == annoClass || RequestScoped.class == annoClass) {
            return true;
        }
        Class<? extends Annotation> mapped = this.scopeAliases.get(annoClass);
        return null != mapped && StopInheritedScope.class != mapped || this.scopeProviders.containsKey(annoClass);
    }

    @Override
    public boolean isInheritedScopeStopper(Class<? extends Annotation> annoClass) {
        if (StopInheritedScope.class == annoClass) {
            return true;
        }
        Class<? extends Annotation> mapped = this.scopeAliases.get(annoClass);
        return StopInheritedScope.class == mapped;
    }

    @Override
    public boolean isQualifier(Class<? extends Annotation> annoClass) {
        return this.qualifierRegistry.contains(annoClass) || annoClass.isAnnotationPresent(Qualifier.class);
    }

    @Override
    public boolean isPostConstructProcessor(Class<? extends Annotation> annoClass) {
        return this.postConstructProcessors.containsKey(annoClass) || annoClass.isAnnotationPresent(PostConstructProcess.class);
    }

    @Override
    public Class<? extends Annotation> scopeByAlias(Class<? extends Annotation> alias) {
        Class<? extends Annotation> annoType = this.scopeAliases.get(alias);
        return null == annoType ? alias : annoType;
    }

    ScopeCache scopeCache(Class<? extends Annotation> scope) {
        return this.scopeProviders.get(scope);
    }

    PostConstructProcessor postConstructProcessor(Annotation annotation) {
        Class<? extends Annotation> annoClass = annotation.annotationType();
        PostConstructProcessor processor = (PostConstructProcessor)this.postConstructProcessors.get(annoClass);
        if (null == processor) {
            if (!annoClass.isAnnotationPresent(PostConstructProcess.class)) {
                throw new UnexpectedException("Cannot find PostConstructProcessor on %s", new Object[]{annoClass});
            }
            PostConstructProcess pcp = annoClass.getAnnotation(PostConstructProcess.class);
            Class<? extends PostConstructProcessor> cls = pcp.value();
            processor = this.get(cls);
            PostConstructProcessor p2 = this.postConstructProcessors.putIfAbsent(annoClass, processor);
            if (null != p2) {
                processor = p2;
            }
        }
        return processor;
    }

    private BeanSpec beanSpecOf(Class type) {
        BeanSpec spec = (BeanSpec)this.beanSpecLookup.get(type);
        if (null == spec) {
            spec = BeanSpec.of(type, (Injector)this);
            this.beanSpecLookup.putIfAbsent(type, spec);
        }
        return spec;
    }

    private <T> void registerProvider(Class<T> type, Provider<? extends T> provider, boolean fireEvent) {
        AFFINITY.set(0);
        this.bindProviderToClass(type, provider, fireEvent);
    }

    private void bindProviderToClass(Class<?> target, Provider<?> provider, boolean fireEvent) {
        Class<?>[] roles;
        this.addIntoRegistry(target, provider);
        AFFINITY.set(AFFINITY.get() + 1);
        Class<?> dad = target.getSuperclass();
        if (null != dad && Object.class != dad) {
            this.bindProviderToClass(dad, provider, fireEvent);
        }
        if (null == (roles = target.getInterfaces())) {
            return;
        }
        for (Class<?> role : roles) {
            this.bindProviderToClass(role, provider, fireEvent);
        }
        if (fireEvent) {
            this.fireProviderRegisteredEvent(target);
        }
    }

    private void addIntoRegistry(BeanSpec spec, Provider<?> val, boolean addIntoExpressRegistry) {
        WeightedProvider<?> current = WeightedProvider.decorate(val);
        Provider old = (Provider)this.registry.get(spec);
        if (null == old) {
            this.registry.put(spec, current);
            if (addIntoExpressRegistry) {
                this.expressRegistry.put(spec.rawType(), current);
            }
            return;
        }
        String newName = Genie.providerName(((WeightedProvider)current).realProvider);
        if (old instanceof WeightedProvider) {
            WeightedProvider weightedOld = (WeightedProvider)old;
            String oldName = Genie.providerName(weightedOld.realProvider);
            if (weightedOld.affinity > ((WeightedProvider)current).affinity) {
                this.registry.put(spec, current);
                if (addIntoExpressRegistry) {
                    this.expressRegistry.put(spec.rawType(), current);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Provider %s \n\tfor [%s] \n\tis replaced with: %s", new Object[]{oldName, spec, newName});
                }
            } else {
                if (weightedOld.affinity == 0 && ((WeightedProvider)current).affinity == 0) {
                    throw new InjectException("Provider has already registered for spec: %s", spec);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Provider %s \n\t for [%s] \n\t cannot be replaced with: %s", new Object[]{oldName, spec, newName});
                }
            }
        } else {
            throw E.unexpected((String)"Provider has already registered for spec: %s", (Object[])new Object[]{spec});
        }
    }

    private void addIntoRegistry(Class<?> type, Provider<?> val) {
        this.addIntoRegistry(BeanSpec.of(type, (Injector)this), val, true);
    }

    private void registerBuiltInProviders() {
        this.registerProvider(Collection.class, OsglListProvider.INSTANCE, false);
        this.registerProvider(Deque.class, DequeProvider.INSTANCE, false);
        this.registerProvider(ArrayList.class, ArrayListProvider.INSTANCE, false);
        this.registerProvider(LinkedList.class, LinkedListProvider.INSTANCE, false);
        this.registerProvider(C.List.class, OsglListProvider.INSTANCE, false);
        this.registerProvider(C.Set.class, OsglSetProvider.INSTANCE, false);
        this.registerProvider(C.Map.class, OsglMapProvider.INSTANCE, false);
        this.registerProvider(LinkedHashMap.class, LinkedHashMapProvider.INSTANCE, false);
        this.registerProvider(ConcurrentMap.class, ConcurrentMapProvider.INSTANCE, false);
        this.registerProvider(SortedMap.class, SortedMapProvider.INSTANCE, false);
        this.registerProvider(SortedSet.class, SortedSetProvider.INSTANCE, false);
    }

    private void registerBuiltInPlugins() {
        this.tryRegisterPlugin("org.osgl.inject.CDIAdaptor");
        this.tryRegisterPlugin("org.osgl.inject.GuiceAdaptor");
    }

    private void tryRegisterPlugin(String pluginClass) {
        try {
            GeniePlugin plugin = (GeniePlugin)$.newInstance((String)pluginClass);
            plugin.register(this);
        }
        catch (Exception e) {
            logger.warn((Throwable)e, "error registering plug: %s", new Object[]{pluginClass});
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private void initScopeAliases() {
        this.scopeAliases.put(Singleton.class, Singleton.class);
        this.scopeAliases.put(SessionScoped.class, SessionScoped.class);
        this.scopeAliases.put(RequestScoped.class, RequestScoped.class);
    }

    private void registerModule(Object module) {
        Class<?> moduleClass;
        boolean isClass = module instanceof Class;
        Class<?> clazz = moduleClass = isClass ? (Class<?>)module : module.getClass();
        if (Module.class.isAssignableFrom(moduleClass)) {
            if (isClass) {
                module = $.newInstance(moduleClass);
                isClass = false;
            }
            ((Module)module).applyTo(this);
        }
        for (Method method : moduleClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Provides.class)) continue;
            method.setAccessible(true);
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            if (isClass && !isStatic) {
                module = $.newInstance(moduleClass);
                isClass = false;
            }
            this.registerFactoryMethod(isStatic ? null : module, method);
        }
    }

    private void registerFactoryMethod(final Object instance, Method factory) {
        Type retType = factory.getGenericReturnType();
        Annotation[] factoryAnnotations = factory.getAnnotations();
        BeanSpec spec = BeanSpec.of(retType, factoryAnnotations, (Injector)this);
        final MethodInjector methodInjector = this.methodInjector(factory, (Set<BeanSpec>)C.empty());
        this.addIntoRegistry(spec, this.decorate(spec, new Provider(){

            public Object get() {
                return methodInjector.applyTo(instance);
            }

            public String toString() {
                return S.fmt((String)"%s::%s", (Object[])new Object[]{instance.getClass().getName(), methodInjector.method.getName()});
            }
        }, true), factoryAnnotations.length == 0);
        this.fireProviderRegisteredEvent(spec.rawType());
    }

    private Provider<?> findProvider(final BeanSpec spec, Set<BeanSpec> chain) {
        Class rawType = spec.rawType();
        final NamedProvider namedProvider = (NamedProvider)this.namedRegistry.get(rawType);
        if (null != namedProvider && spec.hasAnnotation(Named.class)) {
            final String name = spec.name();
            return new Provider<Object>(){

                public Object get() {
                    return namedProvider.get(name);
                }
            };
        }
        Object provider = (Provider)this.registry.get(spec);
        if (null != provider) {
            return provider;
        }
        if (null != spec.name() && null != (provider = (Provider)this.registry.get(spec.withoutName()))) {
            return provider;
        }
        if (spec.isProvider() && !spec.typeParams().isEmpty()) {
            provider = new Provider<Provider<?>>(){

                public Provider<?> get() {
                    return new Provider(){
                        private volatile Provider realProvider;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object get() {
                            if (null == this.realProvider) {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    if (null == this.realProvider) {
                                        this.realProvider = Genie.this.findProvider(spec.toProvidee(), (Set)C.empty());
                                    }
                                }
                            }
                            return this.realProvider.get();
                        }
                    };
                }
            };
            this.registry.putIfAbsent(spec, (Provider<?>)provider);
            return provider;
        }
        if (spec.hasValueLoader()) {
            provider = ValueLoaderFactory.create(spec, this);
        } else {
            if (spec.isArray()) {
                return ArrayProvider.of(spec, this);
            }
            final GenericTypedBeanLoader loader = (GenericTypedBeanLoader)this.genericTypedBeanLoaders.get(spec.rawType());
            if (null != loader) {
                provider = new Provider<Object>(){

                    public Object get() {
                        return loader.load(spec);
                    }
                };
            }
            if (null == provider) {
                if (spec.notConstructable()) {
                    provider = (Provider)this.registry.get(spec.rawTypeSpec());
                    if (null == provider) {
                        throw new InjectException("Cannot instantiate %s", spec);
                    }
                } else {
                    if (BeanSpec.class == spec.rawType()) {
                        return BEAN_SPEC_PROVIDER;
                    }
                    provider = this.buildProvider(spec, chain);
                }
            }
        }
        Provider<?> decorated = this.decorate(spec, (Provider)provider, false);
        this.registry.putIfAbsent(spec, decorated);
        return decorated;
    }

    private Provider<?> decorate(final BeanSpec spec, Provider provider, final boolean isFactory) {
        if (BEAN_SPEC_PROVIDER == provider) {
            return provider;
        }
        final Provider postConstructed = PostConstructProcessorInvoker.decorate(spec, PostConstructorInvoker.decorate(spec, ElementLoaderProvider.decorate(spec, provider, this), this), this);
        Provider eventFired = new Provider(){

            public Object get() {
                if (Genie.this.supportInjectionPoint && !isFactory) {
                    TGT_SPEC.set(spec);
                }
                try {
                    Object bean = postConstructed.get();
                    Genie.this.fireInjectEvent(bean, spec);
                    Object object = bean;
                    return object;
                }
                finally {
                    if (Genie.this.supportInjectionPoint && !isFactory) {
                        TGT_SPEC.remove();
                    }
                }
            }
        };
        return ScopedProvider.decorate(spec, eventFired, this);
    }

    private Provider buildProvider(BeanSpec spec, Set<BeanSpec> chain) {
        Class target = spec.rawType();
        Constructor constructor = this.constructor(target);
        return null != constructor ? this.buildConstructor(constructor, spec, chain) : this.buildFieldMethodInjector(spec, chain);
    }

    private Provider buildConstructor(final Constructor constructor, final BeanSpec spec, Set<BeanSpec> chain) {
        Type[] ta = constructor.getGenericParameterTypes();
        Annotation[][] aaa = constructor.getParameterAnnotations();
        final Provider[] pp = this.paramProviders(ta, aaa, chain, null);
        return new Provider(){

            public Object get() {
                try {
                    return constructor.newInstance(Genie.params(pp));
                }
                catch (Exception e) {
                    throw new InjectException(e, "cannot instantiate %s", spec);
                }
            }
        };
    }

    private Provider buildFieldMethodInjector(final BeanSpec spec, Set<BeanSpec> chain) {
        final List<FieldInjector> fieldInjectors = this.fieldInjectors(spec, chain);
        final List<MethodInjector> methodInjectors = this.methodInjectors(spec, chain);
        final Constructor constructor = spec.getDeclaredConstructor();
        if (null == constructor) {
            throw new InjectException("cannot instantiate %s: %s", spec, "no default constructor found");
        }
        constructor.setAccessible(true);
        return new Provider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object get() {
                try {
                    Object bean = constructor.newInstance(new Object[0]);
                    for (FieldInjector fj : fieldInjectors) {
                        if (Genie.this.supportInjectionPoint) {
                            TGT_SPEC.set(fj.fieldSpec);
                        }
                        try {
                            fj.applyTo(bean);
                        }
                        finally {
                            if (!Genie.this.supportInjectionPoint) continue;
                            TGT_SPEC.remove();
                        }
                    }
                    for (MethodInjector mj : methodInjectors) {
                        mj.applyTo(bean);
                    }
                    return bean;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new InjectException(t, "cannot instantiate %s", spec);
                }
                catch (Exception e) {
                    throw new InjectException(e, "cannot instantiate %s", spec);
                }
            }
        };
    }

    private Constructor constructor(Class target) {
        Constructor<?>[] ca;
        for (Constructor<?> c : ca = target.getDeclaredConstructors()) {
            if (!this.subjectToInject(c)) continue;
            c.setAccessible(true);
            return c;
        }
        return null;
    }

    private List<FieldInjector> fieldInjectors(BeanSpec target, Set<BeanSpec> chain) {
        C.List fieldInjectors = C.newList();
        for (BeanSpec current = target; null != current && !current.isObject(); current = current.parent()) {
            for (BeanSpec fieldSpec : current.nonStaticFields()) {
                if (!this.subjectToInject(fieldSpec)) continue;
                fieldSpec.makeFieldAccessible();
                fieldInjectors.add(this.fieldInjector(fieldSpec, chain));
            }
        }
        return fieldInjectors;
    }

    private FieldInjector fieldInjector(BeanSpec fieldSpec, Set<BeanSpec> chain) {
        if (chain.contains(fieldSpec)) {
            Genie.foundCircularDependency(chain, fieldSpec);
        }
        return new FieldInjector(fieldSpec, this.findProvider(fieldSpec, Genie.chain(chain, fieldSpec)));
    }

    private List<MethodInjector> methodInjectors(BeanSpec target, Set<BeanSpec> chain) {
        C.List methodInjectors = C.newList();
        for (BeanSpec current = target; null != current && !current.isObject(); current = current.parent()) {
            for (Method method : current.getDeclaredMethods()) {
                if (!this.subjectToInject(method)) continue;
                method.setAccessible(true);
                methodInjectors.add(this.methodInjector(method, chain));
            }
        }
        return methodInjectors;
    }

    private MethodInjector methodInjector(Method method, Set<BeanSpec> chain) {
        Type[] paramTypes = method.getGenericParameterTypes();
        int len = paramTypes.length;
        Provider[] paramProviders = new Provider[len];
        Annotation[][] aaa = method.getParameterAnnotations();
        for (int i = 0; i < len; ++i) {
            Type paramType = paramTypes[i];
            BeanSpec paramSpec = BeanSpec.of(paramType, aaa[i], (Injector)this);
            if (chain.contains(paramSpec)) {
                Genie.foundCircularDependency(chain, paramSpec);
            }
            paramProviders[i] = this.findProvider(paramSpec, Genie.chain(chain, paramSpec));
        }
        return new MethodInjector(method, paramProviders);
    }

    private static <T extends Annotation> T filterAnnotation(Annotation[] aa, Class<T> ac) {
        for (Annotation a : aa) {
            if (a.annotationType() != ac) continue;
            return (T)a;
        }
        return null;
    }

    private Provider[] paramProviders(Type[] paramTypes, Annotation[][] aaa, Set<BeanSpec> chain, Lang.Func2<BeanSpec, Injector, Provider> ctxParamProviderLookup) {
        int len = paramTypes.length;
        Provider[] pa = new Provider[len];
        for (int i = 0; i < len; ++i) {
            Type type = paramTypes[i];
            Annotation[] annotations = aaa[i];
            BeanSpec paramSpec = BeanSpec.of(type, annotations, (Injector)this);
            if (chain.contains(paramSpec)) {
                Genie.foundCircularDependency(chain, paramSpec);
            }
            if (null != ctxParamProviderLookup) {
                if (!paramSpec.hasElementLoader() && null == Genie.filterAnnotation(annotations, Provided.class)) {
                    Provider provider = paramSpec.hasValueLoader() ? ValueLoaderFactory.create(paramSpec, this) : (Provider)ctxParamProviderLookup.apply((Object)paramSpec, (Object)this);
                    pa[i] = provider;
                    continue;
                }
                pa[i] = this.findProvider(paramSpec, Genie.chain(chain, paramSpec));
                continue;
            }
            pa[i] = this.findProvider(paramSpec, Genie.chain(chain, paramSpec));
        }
        return pa;
    }

    private void fireProviderRegisteredEvent(Class targetType) {
        for (InjectListener l : this.listeners) {
            l.providerRegistered(targetType);
        }
    }

    void fireInjectEvent(Object bean, BeanSpec beanSpec) {
        for (InjectListener l : this.listeners) {
            l.injected(bean, beanSpec);
        }
    }

    public boolean subjectToInject(AccessibleObject ao) {
        if (ao.isAnnotationPresent(Inject.class)) {
            return true;
        }
        for (Class<? extends Annotation> tag : this.injectTagRegistry) {
            if (!ao.isAnnotationPresent(tag)) continue;
            return true;
        }
        for (Annotation tag : ao.getDeclaredAnnotations()) {
            Class<? extends Annotation> tagType = tag.annotationType();
            if (!tagType.isAnnotationPresent(InjectTag.class)) continue;
            this.injectTagRegistry.add(tagType);
            return true;
        }
        return false;
    }

    public boolean subjectToInject(BeanSpec beanSpec) {
        if (!beanSpec.hasInjectDecorator()) {
            Type elementType;
            List<Type> typeParams;
            Class type = beanSpec.rawType();
            if ($.isSimpleType((Class)type)) {
                return false;
            }
            if (Collection.class.isAssignableFrom(type)) {
                typeParams = beanSpec.typeParams();
                if (typeParams.isEmpty()) {
                    return false;
                }
                elementType = typeParams.get(0);
                if (!(elementType instanceof Class)) {
                    return false;
                }
                if ($.isSimpleType((Class)((Class)elementType))) {
                    return false;
                }
            } else if (Map.class.isAssignableFrom(type)) {
                typeParams = beanSpec.typeParams();
                if (typeParams.isEmpty()) {
                    return false;
                }
                elementType = typeParams.get(1);
                if (!(elementType instanceof Class)) {
                    return false;
                }
                if ($.isSimpleType((Class)((Class)elementType))) {
                    return false;
                }
            }
        }
        if (this.registry.containsKey(beanSpec)) {
            return true;
        }
        if (beanSpec.hasAnnotation(Inject.class)) {
            return true;
        }
        for (Class<? extends Annotation> tag : this.injectTagRegistry) {
            if (!beanSpec.hasAnnotation(tag)) continue;
            return true;
        }
        for (Annotation tag : beanSpec.allAnnotations()) {
            Class<? extends Annotation> tagType = tag.annotationType();
            if (!tagType.isAnnotationPresent(InjectTag.class)) continue;
            this.injectTagRegistry.add(tagType);
            return true;
        }
        return beanSpec.hasAnnotation(Singleton.class);
    }

    public static Genie create(InjectListener listener, Object ... modules) {
        return new Genie(listener, modules);
    }

    public static Genie create(Object ... modules) {
        return new Genie(modules);
    }

    public static Genie createWithoutPlugins(Object ... modules) {
        return new Genie(true, modules);
    }

    private static Object[] params(Provider<?>[] paramProviders) {
        int len = paramProviders.length;
        Object[] params = new Object[len];
        for (int i = 0; i < len; ++i) {
            params[i] = paramProviders[i].get();
        }
        return params;
    }

    private static Set<BeanSpec> chain(Set<BeanSpec> chain, BeanSpec nextSpec) {
        HashSet<BeanSpec> newChain = new HashSet<BeanSpec>(chain);
        newChain.add(nextSpec);
        return newChain;
    }

    private static S.Buffer debugChain(Set<BeanSpec> chain, BeanSpec last) {
        S.Buffer sb = S.buffer();
        for (BeanSpec spec : chain) {
            sb.append((Object)spec).append(" -> ");
        }
        sb.append((Object)last);
        return sb;
    }

    private static void foundCircularDependency(Set<BeanSpec> chain, BeanSpec last) {
        throw InjectException.circularDependency((CharSequence)Genie.debugChain(chain, last));
    }

    private static String providerName(Provider provider) {
        String name = provider.getClass().getName();
        if (name.contains("org.osgl.inject.Genie$")) {
            name = provider.toString();
        }
        return name;
    }

    private static class MethodInjector {
        private final Method method;
        private final Provider[] providers;

        MethodInjector(Method method, Provider[] providers) {
            this.method = method;
            this.providers = providers;
        }

        Object applyTo(Object bean) {
            try {
                return this.method.invoke(bean, Genie.params(this.providers));
            }
            catch (Exception e) {
                throw new InjectException(e, "Unable to invoke method[%s] on %s", this.method.getName(), bean.getClass());
            }
        }

        public String toString() {
            return $.fmt((String)"MethodInjector for %s", (Object[])new Object[]{this.method});
        }
    }

    private static class FieldInjector {
        private final BeanSpec fieldSpec;
        private final Provider provider;

        FieldInjector(BeanSpec fieldSpec, Provider provider) {
            this.fieldSpec = fieldSpec;
            this.provider = provider;
        }

        void applyTo(Object bean) {
            Object obj = this.provider.get();
            if (null == obj) {
                return;
            }
            this.fieldSpec.setField(bean, obj);
        }

        public String toString() {
            return $.fmt((String)("Field injector for: " + this.fieldSpec), (Object[])new Object[0]);
        }
    }

    private static class WeightedProvider<T>
    implements Provider<T>,
    Comparable<WeightedProvider<T>> {
        private Provider<T> realProvider;
        private int affinity;

        WeightedProvider(Provider<T> provider) {
            this.realProvider = provider;
            this.affinity = (Integer)AFFINITY.get();
        }

        public T get() {
            return (T)this.realProvider.get();
        }

        @Override
        public int compareTo(WeightedProvider<T> o) {
            return this.affinity - o.affinity;
        }

        static <T> WeightedProvider<T> decorate(Provider<T> provider) {
            return provider instanceof WeightedProvider ? (WeightedProvider<T>)provider : new WeightedProvider<T>(provider);
        }
    }

    public static class Binder<T> {
        private Class<T> type;
        private String name;
        private Provider<? extends T> provider;
        private List<Annotation> annotations = C.newList();
        private Class<? extends Annotation> scope;
        private boolean forceFireEvent;
        private boolean fireEvent;
        private Constructor<? extends T> constructor;
        private Class<? extends T> impl;

        public Binder(Class<T> type) {
            this.type = type;
            this.fireEvent = true;
        }

        public Binder<T> to(Class<? extends T> impl) {
            this.ensureNoBinding();
            this.impl = (Class)$.requireNotNull(impl);
            return this;
        }

        public Binder<T> to(final T instance) {
            this.ensureNoBinding();
            this.provider = new Provider<T>(){

                public T get() {
                    return instance;
                }
            };
            return this;
        }

        public Binder<T> to(Provider<? extends T> provider) {
            this.ensureNoBinding();
            this.provider = provider;
            return this;
        }

        public Binder<T> to(Constructor<? extends T> constructor) {
            this.ensureNoBinding();
            this.constructor = constructor;
            return this;
        }

        public Binder<T> toConstructor(Class<? extends T> implement, Class<?> ... args) {
            this.ensureNoBinding();
            try {
                return this.to(implement.getConstructor(args));
            }
            catch (NoSuchMethodException e) {
                throw new InjectException(e, "cannot find constructor for %s with arguments: %s", implement.getName(), $.toString2(args));
            }
        }

        private void ensureNoBinding() {
            E.illegalStateIf((boolean)this.bound(), (String)"binding has already been specified");
        }

        public Binder<T> named(String name) {
            E.illegalStateIf((null != this.name ? 1 : 0) != 0, (String)"name has already been specified");
            this.name = name;
            this.fireEvent = false;
            return this;
        }

        public Binder<T> in(Class<? extends Annotation> scope) {
            if (!scope.isAnnotationPresent(Scope.class)) {
                throw new InjectException("the scope annotation type must have @Scope annotation presented: " + scope.getName(), new Object[0]);
            }
            E.illegalStateIf((null != this.scope ? 1 : 0) != 0, (String)"Scope has already been specified");
            this.scope = scope;
            this.fireEvent = false;
            return this;
        }

        @Deprecated
        public Binder<T> withAnnotation(Class<? extends Annotation> ... annotations) {
            for (Class<? extends Annotation> annotation : annotations) {
                this.annotations.add(AnnotationUtil.createAnnotation(annotation));
            }
            this.fireEvent = false;
            return this;
        }

        @Deprecated
        public Binder<T> withAnnotation(Annotation ... annotations) {
            this.annotations.addAll((Collection<Annotation>)C.listOf((Object[])annotations));
            this.fireEvent = false;
            return this;
        }

        public Binder<T> qualifiedWith(Class<? extends Annotation> ... qualifiers) {
            for (Class<? extends Annotation> qualifier : qualifiers) {
                if (!qualifier.isAnnotationPresent(Qualifier.class)) {
                    throw new InjectException("Qualifier annotation type must have \"@Qualifier\" annotation presented: " + qualifier.getName(), new Object[0]);
                }
                this.annotations.add(AnnotationUtil.createAnnotation(qualifier));
            }
            this.fireEvent = false;
            return this;
        }

        public Binder<T> qualifiedWith(Annotation ... qualifiers) {
            for (Annotation qualifier : qualifiers) {
                Class<? extends Annotation> qulifierType = qualifier.annotationType();
                if (!qulifierType.isAnnotationPresent(Qualifier.class)) {
                    throw new InjectException("Qualifier annotation type must have \"@Qualifier\" annotation presented: " + qulifierType.getName(), new Object[0]);
                }
                this.annotations.add(AnnotationUtil.createAnnotation(qulifierType));
            }
            this.fireEvent = false;
            return this;
        }

        public Binder<T> forceFireEvent() {
            this.forceFireEvent = true;
            this.fireEvent = true;
            return this;
        }

        public Binder<T> doNotFireEvent() {
            this.forceFireEvent = false;
            this.fireEvent = false;
            return this;
        }

        boolean bound() {
            return null != this.provider || null != this.constructor;
        }

        public void register(Genie genie) {
            if (null == this.provider) {
                if (null != this.constructor) {
                    this.provider = genie.buildConstructor(this.constructor, BeanSpec.of(this.constructor.getDeclaringClass(), null, (Injector)genie), new HashSet());
                } else if (null != this.impl) {
                    this.provider = new LazyProvider<T>(this.impl, genie);
                }
            }
            if (!this.bound()) {
                throw new InjectException("Cannot register without binding specified", new Object[0]);
            }
            BeanSpec spec = this.beanSpec(genie);
            genie.addIntoRegistry(spec, genie.decorate(spec, this.provider, true), this.annotations.isEmpty() && S.blank((String)this.name));
            if (this.fireEvent || this.forceFireEvent) {
                genie.fireProviderRegisteredEvent(this.type);
            }
        }

        BeanSpec beanSpec(Genie genie) {
            BeanSpec spec = BeanSpec.of(this.type, this.annotations.toArray(new Annotation[this.annotations.size()]), this.name, genie);
            if (this.scope != null) {
                spec.scope(this.scope);
            }
            return spec;
        }
    }
}

