package org.osgl.inject.annotation;

/*-
 * #%L
 * OSGL Genie
 * %%
 * Copyright (C) 2017 OSGL (Open Source General Library)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import org.osgl.inject.loader.ConfigurationValueLoader;

import java.lang.annotation.*;

/**
 * Used to specify a field or parameter shall be load by
 * {@link org.osgl.inject.loader.ConfigurationValueLoader}.
 */
@Documented
@InjectTag
@LoadValue(ConfigurationValueLoader.class)
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD, ElementType.PARAMETER})
public @interface Configuration {

    /**
     * The name of {@link #defaultValue()} property.
     */
    String DEFAULT_VALUE_PROP = "defaultValue";

    /**
     * Specify the configuration key.
     *
     * @return the configuration key
     */
    String value();

    /**
     * Specify the default value of the configuration
     * @return the default value
     */
    String defaultValue() default "";
}
