/*
 * Decompiled with CFR 0.152.
 */
package org.otcl2.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.otcl2.common.OtclConstants;

public class OtclCommandDto {
    public String tokenPath;
    public OtclConstants.TARGET_SOURCE enumTargetSource;
    public String otclToken;
    public int otclTokenIndex;
    public boolean isRootNode;
    public boolean hasCollectionNotation;
    public boolean hasMapNotation;
    public CollectionDescriptor collectionDescriptor = CollectionDescriptor.NORMAL;
    public String concreteTypeName;
    public String mapKeyConcreteType;
    public String mapValueConcreteType;
    public String fieldName;
    public Field field;
    public boolean enableFactoryHelperGetter;
    public boolean enableFactoryHelperSetter;
    public boolean isGetterInitialized;
    public boolean isSetterInitialized;
    public String getter;
    public String setter;
    public Class<?> fieldType;
    public Class<?> concreteType;
    public Class<?> declaringClass;
    public OtclCommandDto parent;
    public Map<String, OtclCommandDto> children;

    private OtclCommandDto() {
    }

    private OtclCommandDto(Builder builder) {
        this.enumTargetSource = builder.enumTargetSource;
        this.otclToken = builder.otclToken;
        this.tokenPath = builder.tokenPath;
        this.otclTokenIndex = builder.otclTokenIndex;
        this.isRootNode = builder.isRootNode;
        this.collectionDescriptor = builder.collectionDescriptor;
        this.concreteTypeName = builder.concreteTypeName;
        this.fieldName = builder.fieldName;
        this.field = builder.field;
        this.fieldType = builder.fieldType;
        this.concreteType = builder.concreteType;
        this.parent = builder.parent;
        this.children = builder.children;
    }

    public static Builder newBuilder() {
        return new Builder(){

            @Override
            public OtclCommandDto build() {
                return new OtclCommandDto(this);
            }
        };
    }

    public void addChild(OtclCommandDto otclCommandDto) {
        if (this.children == null) {
            this.children = new HashMap<String, OtclCommandDto>();
        }
        this.children.put(otclCommandDto.otclToken, otclCommandDto);
    }

    @JsonIgnore
    public boolean isEnum() {
        return this.fieldType.isEnum();
    }

    @JsonIgnore
    public boolean isNormal() {
        return this.collectionDescriptor.isNormal();
    }

    @JsonIgnore
    public boolean isCollectionOrMap() {
        return this.isCollection() || this.isMap();
    }

    @JsonIgnore
    public boolean isCollection() {
        return this.collectionDescriptor.isCollection();
    }

    @JsonIgnore
    public boolean isArray() {
        return this.collectionDescriptor.isArray();
    }

    @JsonIgnore
    public boolean isCollectionOrMapMember() {
        return this.isCollectionMember() || this.isMapMember();
    }

    @JsonIgnore
    public boolean isCollectionMember() {
        return this.collectionDescriptor.isCollectionMember();
    }

    @JsonIgnore
    public boolean isMap() {
        return this.collectionDescriptor.isMap();
    }

    @JsonIgnore
    public boolean isMapKey() {
        return this.collectionDescriptor.isMapKey();
    }

    @JsonIgnore
    public boolean isMapValue() {
        return this.collectionDescriptor.isMapValue();
    }

    @JsonIgnore
    public boolean isMapMember() {
        return this.collectionDescriptor.isMapKey() || this.collectionDescriptor.isMapValue();
    }

    public String toString() {
        return "OtclCommandDto [tokenPath=" + this.tokenPath + ", enumTargetSource=" + (Object)((Object)this.enumTargetSource) + ", otclToken=" + this.otclToken + ", otclTokenIndex=" + this.otclTokenIndex + ", isRootNode=" + this.isRootNode + ", hasCollectionNotation=" + this.hasCollectionNotation + ", hasMapNotation=" + this.hasMapNotation + ", collectionDescriptor=" + (Object)((Object)this.collectionDescriptor) + ", concreteTypeName=" + this.concreteTypeName + ", mapKeyConcreteType=" + this.mapKeyConcreteType + ", mapValueConcreteType=" + this.mapValueConcreteType + ", fieldName=" + this.fieldName + ", field=" + this.field + ", enableFactoryHelperGetter=" + this.enableFactoryHelperGetter + ", enableFactoryHelperSetter=" + this.enableFactoryHelperSetter + ", isGetterInitialized=" + this.isGetterInitialized + ", isSetterInitialized=" + this.isSetterInitialized + ", getter=" + this.getter + ", setter=" + this.setter + ", fieldType=" + this.fieldType + ", concreteType=" + this.concreteType + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.collectionDescriptor == null ? 0 : this.collectionDescriptor.hashCode());
        result = 31 * result + (this.concreteTypeName == null ? 0 : this.concreteTypeName.hashCode());
        result = 31 * result + (this.enableFactoryHelperGetter ? 1231 : 1237);
        result = 31 * result + (this.enableFactoryHelperSetter ? 1231 : 1237);
        result = 31 * result + (this.enumTargetSource == null ? 0 : this.enumTargetSource.hashCode());
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.getter == null ? 0 : this.getter.hashCode());
        result = 31 * result + (this.hasCollectionNotation ? 1231 : 1237);
        result = 31 * result + (this.hasMapNotation ? 1231 : 1237);
        result = 31 * result + (this.isGetterInitialized ? 1231 : 1237);
        result = 31 * result + (this.isRootNode ? 1231 : 1237);
        result = 31 * result + (this.isSetterInitialized ? 1231 : 1237);
        result = 31 * result + (this.mapKeyConcreteType == null ? 0 : this.mapKeyConcreteType.hashCode());
        result = 31 * result + (this.mapValueConcreteType == null ? 0 : this.mapValueConcreteType.hashCode());
        result = 31 * result + (this.otclToken == null ? 0 : this.otclToken.hashCode());
        result = 31 * result + this.otclTokenIndex;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.setter == null ? 0 : this.setter.hashCode());
        result = 31 * result + (this.tokenPath == null ? 0 : this.tokenPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OtclCommandDto other = (OtclCommandDto)obj;
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        if (this.collectionDescriptor != other.collectionDescriptor) {
            return false;
        }
        if (this.concreteTypeName == null ? other.concreteTypeName != null : !this.concreteTypeName.equals(other.concreteTypeName)) {
            return false;
        }
        if (this.enableFactoryHelperGetter != other.enableFactoryHelperGetter) {
            return false;
        }
        if (this.enableFactoryHelperSetter != other.enableFactoryHelperSetter) {
            return false;
        }
        if (this.enumTargetSource != other.enumTargetSource) {
            return false;
        }
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        if (this.getter == null ? other.getter != null : !this.getter.equals(other.getter)) {
            return false;
        }
        if (this.hasCollectionNotation != other.hasCollectionNotation) {
            return false;
        }
        if (this.hasMapNotation != other.hasMapNotation) {
            return false;
        }
        if (this.isGetterInitialized != other.isGetterInitialized) {
            return false;
        }
        if (this.isRootNode != other.isRootNode) {
            return false;
        }
        if (this.isSetterInitialized != other.isSetterInitialized) {
            return false;
        }
        if (this.mapKeyConcreteType == null ? other.mapKeyConcreteType != null : !this.mapKeyConcreteType.equals(other.mapKeyConcreteType)) {
            return false;
        }
        if (this.mapValueConcreteType == null ? other.mapValueConcreteType != null : !this.mapValueConcreteType.equals(other.mapValueConcreteType)) {
            return false;
        }
        if (this.otclToken == null ? other.otclToken != null : !this.otclToken.equals(other.otclToken)) {
            return false;
        }
        if (this.otclTokenIndex != other.otclTokenIndex) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.setter == null ? other.setter != null : !this.setter.equals(other.setter)) {
            return false;
        }
        return !(this.tokenPath == null ? other.tokenPath != null : !this.tokenPath.equals(other.tokenPath));
    }

    public static abstract class Builder {
        private OtclConstants.TARGET_SOURCE enumTargetSource;
        private String otclToken;
        private String tokenPath;
        private int otclTokenIndex;
        private boolean isRootNode;
        private CollectionDescriptor collectionDescriptor = CollectionDescriptor.NORMAL;
        private String concreteTypeName;
        private String fieldName;
        private Field field;
        private Class<?> fieldType;
        private Class<?> concreteType;
        private OtclCommandDto parent;
        private Map<String, OtclCommandDto> children;

        public abstract OtclCommandDto build();

        public Builder addTargetOrSource(OtclConstants.TARGET_SOURCE enumTargetOrSource) {
            this.enumTargetSource = enumTargetOrSource;
            return this;
        }

        public Builder addOtclToken(String otclToken) {
            this.otclToken = otclToken;
            return this;
        }

        public Builder addTokenPath(String chainPath) {
            this.tokenPath = chainPath;
            return this;
        }

        public Builder addOtclTokenIndex(int otclTokenIndex) {
            this.otclTokenIndex = otclTokenIndex;
            return this;
        }

        public Builder addIsRootNode(boolean isRootNode) {
            this.isRootNode = isRootNode;
            return this;
        }

        public Builder addCollectionDefiner(CollectionDescriptor collectionDescriptor) {
            this.collectionDescriptor = collectionDescriptor;
            return this;
        }

        public Builder addConcreteTypeName(String concreteTypeName) {
            if (concreteTypeName == null) {
                return this;
            }
            this.concreteTypeName = concreteTypeName;
            return this;
        }

        public Builder addFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder addField(Field field) {
            this.field = field;
            return this;
        }

        public Builder addFieldType(Class<?> fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public Builder addConcreteType(Class<?> concreteType) {
            this.concreteType = concreteType;
            return this;
        }

        public Builder addParent(OtclCommandDto parent) {
            this.parent = parent;
            return this;
        }

        public Builder addChild(String fieldName, OtclCommandDto otclCommandDto) {
            if (this.children == null) {
                this.children = new HashMap<String, OtclCommandDto>();
            }
            this.children.put(fieldName, otclCommandDto);
            return this;
        }
    }

    public static enum CollectionDescriptor {
        NORMAL("None"),
        ARRAY("Array"),
        LIST("List"),
        SET("Set"),
        QUEUE("Queue"),
        COLLECTION_MEMBER("Collection.Member"),
        MAP("Map"),
        MAP_KEY("Map.Key"),
        MAP_VALUE("Map.Value");

        private final String value;

        private CollectionDescriptor(String value) {
            this.value = value;
        }

        public boolean isNormal() {
            return CollectionDescriptor.NORMAL.value == this.value;
        }

        public boolean isCollection() {
            return CollectionDescriptor.ARRAY.value == this.value || CollectionDescriptor.LIST.value == this.value || CollectionDescriptor.SET.value == this.value || CollectionDescriptor.QUEUE.value == this.value;
        }

        public boolean isArray() {
            return CollectionDescriptor.ARRAY.value == this.value;
        }

        public boolean isCollectionMember() {
            return CollectionDescriptor.COLLECTION_MEMBER.value == this.value;
        }

        public boolean isMap() {
            return CollectionDescriptor.MAP.value == this.value;
        }

        public boolean isMapKey() {
            return CollectionDescriptor.MAP_KEY.value == this.value;
        }

        public boolean isMapValue() {
            return CollectionDescriptor.MAP_VALUE.value == this.value;
        }
    }
}

