/*
 * Decompiled with CFR 0.152.
 */
package org.otcl2.common.engine.compiler;

import org.otcl2.common.dto.OtclCommandDto;
import org.otcl2.common.dto.ScriptDto;
import org.otcl2.common.engine.profiler.dto.IndexedCollectionsDto;

public class OtclCommandContext {
    public String scriptId;
    public ScriptDto scriptDto;
    public String otclChain;
    public String[] otclTokens;
    public String[] rawOtclTokens;
    public OtclCommandDto otclCommandDto;
    public IndexedCollectionsDto profiledCollectionsDto;
    public int collectionsCount = 0;
    public int currentCollectionTokenIndex = 0;

    public OtclCommandContext clone() {
        OtclCommandContext otclCommandContext = new OtclCommandContext();
        otclCommandContext.otclChain = this.otclChain;
        otclCommandContext.rawOtclTokens = this.rawOtclTokens;
        otclCommandContext.otclTokens = this.otclTokens;
        otclCommandContext.otclCommandDto = this.otclCommandDto;
        otclCommandContext.profiledCollectionsDto = this.profiledCollectionsDto;
        return otclCommandContext;
    }

    public boolean isLeafParent() {
        if (this.otclCommandDto.otclTokenIndex == this.otclTokens.length - 2) {
            if (this.otclCommandDto.collectionDescriptor.isCollection() || this.otclCommandDto.collectionDescriptor.isMap()) {
                return false;
            }
            String otclToken = this.otclTokens[this.otclCommandDto.otclTokenIndex + 1];
            OtclCommandDto childOCD = this.otclCommandDto.children.get(otclToken);
            return childOCD.collectionDescriptor.isNormal();
        }
        return this.otclCommandDto.otclTokenIndex == this.otclTokens.length - 1 && (this.otclCommandDto.collectionDescriptor.isCollection() || this.otclCommandDto.collectionDescriptor.isMap());
    }

    public boolean isLeaf() {
        return this.otclCommandDto.otclTokenIndex >= this.otclTokens.length - 1 && (this.otclCommandDto.collectionDescriptor.isNormal() || this.otclCommandDto.collectionDescriptor.isMapKey() || this.otclCommandDto.collectionDescriptor.isMapValue() || this.otclCommandDto.collectionDescriptor.isCollectionMember());
    }

    public boolean hasAncestralCollectionOrMap() {
        int startIdx;
        if (this.otclTokens.length == 1 || this.otclCommandDto.isRootNode) {
            return false;
        }
        for (int idx = startIdx = this.otclCommandDto.otclTokenIndex - 1; idx >= 0; --idx) {
            String otclToken = this.otclTokens[idx];
            if (!otclToken.contains("[")) continue;
            return true;
        }
        return false;
    }

    public boolean hasDescendantCollectionOrMap() {
        int startIdx;
        if (this.otclTokens.length == 1) {
            return false;
        }
        for (int idx = startIdx = this.otclCommandDto.otclTokenIndex + 1; idx < this.otclTokens.length; ++idx) {
            String otclToken = this.otclTokens[idx];
            if (!otclToken.contains("[")) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        if (this.otclCommandDto.isCollectionOrMap()) {
            return true;
        }
        return this.otclCommandDto.children != null && this.otclCommandDto.children.size() > 0;
    }

    public boolean hasMapValueDescendant() {
        int startIdx;
        if (this.rawOtclTokens.length == 1) {
            return false;
        }
        for (int idx = startIdx = this.otclCommandDto.otclTokenIndex + 1; idx < this.rawOtclTokens.length; ++idx) {
            String otclToken = this.rawOtclTokens[idx];
            if (!otclToken.contains("<V>")) continue;
            return true;
        }
        return false;
    }

    public boolean hasMapValueMember() {
        return this.rawOtclTokens[this.otclCommandDto.otclTokenIndex].contains("<V>");
    }

    public boolean hasAnchoredDescendant() {
        int startIdx;
        if (this.rawOtclTokens.length == 1) {
            return false;
        }
        for (int idx = startIdx = this.otclCommandDto.otclTokenIndex + 1; idx < this.rawOtclTokens.length; ++idx) {
            String otclToken = this.rawOtclTokens[idx];
            if (!otclToken.contains("^")) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrentTokenAnchored() {
        String otclToken = this.rawOtclTokens[this.otclCommandDto.otclTokenIndex];
        return otclToken.contains("^");
    }

    public boolean isPreAnchored() {
        String otclToken = this.rawOtclTokens[this.otclCommandDto.otclTokenIndex];
        return otclToken.contains("[^*") || otclToken.contains("[^*,*");
    }

    public boolean isPostAnchored() {
        String otclToken = this.rawOtclTokens[this.otclCommandDto.otclTokenIndex];
        return otclToken.contains("*^]") || otclToken.contains("*,*^]");
    }

    public int descendantsCollectionsCountInclusive() {
        int startIdx;
        int descendantsCollectionsCount = 0;
        for (int idx = startIdx = this.otclCommandDto.otclTokenIndex; idx < this.otclTokens.length; ++idx) {
            String otclToken = this.otclTokens[idx];
            if (!otclToken.contains("[")) continue;
            ++descendantsCollectionsCount;
        }
        return descendantsCollectionsCount;
    }
}

