/*
 * Decompiled with CFR 0.152.
 */
package org.otcl2.common.factory;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.otcl2.common.OtclConstants;
import org.otcl2.common.dto.OtclCommandDto;
import org.otcl2.common.exception.OtclException;
import org.otcl2.common.util.CommonUtils;

public class OtclCommandDtoFactory {
    public static OtclCommandDto create(OtclConstants.TARGET_SOURCE enumTargetOrSource, String otclToken, String tokenPath, int idx, String fldName, String concreteType, boolean isRootNode, Field field, Class<?> fldType, Class<?> genericType, boolean isLeaf) {
        OtclCommandDto.Builder builder = OtclCommandDto.newBuilder().addTargetOrSource(enumTargetOrSource).addOtclToken(otclToken).addTokenPath(tokenPath).addOtclTokenIndex(idx).addFieldName(fldName).addIsRootNode(isRootNode).addField(field).addFieldType(fldType).addConcreteType(genericType);
        OtclCommandDto otclCommandDto = builder.build();
        if (!isLeaf) {
            otclCommandDto.children = new HashMap<String, OtclCommandDto>();
        }
        return otclCommandDto;
    }

    public static void createMembers(String id, OtclCommandDto otclCommandDto, String otclChain, String[] otclTokens) {
        boolean isLeaf;
        if (!otclCommandDto.hasCollectionNotation && !otclCommandDto.hasMapNotation) {
            return;
        }
        int idx = otclCommandDto.otclTokenIndex;
        boolean bl = isLeaf = idx == otclTokens.length - 1;
        if (otclCommandDto.hasCollectionNotation) {
            OtclCommandDtoFactory.createCollectionMember(otclCommandDto, isLeaf);
        } else if (otclCommandDto.hasMapNotation) {
            OtclCommandDtoFactory.createMapMember(id, otclCommandDto, otclChain, otclTokens, isLeaf);
        }
        if (isLeaf && otclCommandDto.isCollectionOrMap() && otclCommandDto.children == null) {
            otclCommandDto.children = new LinkedHashMap<String, OtclCommandDto>();
        }
    }

    public static OtclCommandDto createCollectionMember(OtclCommandDto otclCommandDto, boolean isLeaf) {
        OtclCommandDto memberOCD = otclCommandDto.children.get(otclCommandDto.fieldName);
        if (memberOCD != null) {
            return memberOCD;
        }
        Field field = otclCommandDto.field;
        Class<?> fieldType = field.getType();
        if (List.class.isAssignableFrom(fieldType)) {
            otclCommandDto.collectionDescriptor = OtclCommandDto.CollectionDescriptor.LIST;
        } else if (Set.class.isAssignableFrom(fieldType)) {
            otclCommandDto.collectionDescriptor = OtclCommandDto.CollectionDescriptor.SET;
        } else if (Queue.class.isAssignableFrom(fieldType)) {
            otclCommandDto.collectionDescriptor = OtclCommandDto.CollectionDescriptor.QUEUE;
        } else if (fieldType.isArray()) {
            otclCommandDto.collectionDescriptor = OtclCommandDto.CollectionDescriptor.ARRAY;
        }
        Class memberFieldType = null;
        Type parameterizedType = field.getGenericType();
        if (otclCommandDto.isArray()) {
            String memberFieldTypeName = fieldType.getComponentType().getName();
            memberFieldType = CommonUtils.loadClass(memberFieldTypeName);
        } else {
            memberFieldType = (Class)((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
        }
        String memberOtclToken = otclCommandDto.fieldName;
        memberOCD = OtclCommandDtoFactory.create(otclCommandDto.enumTargetSource, memberOtclToken, otclCommandDto.tokenPath, otclCommandDto.otclTokenIndex, otclCommandDto.fieldName, otclCommandDto.concreteTypeName, false, null, memberFieldType, null, isLeaf);
        memberOCD.tokenPath = CommonUtils.replaceLast(memberOCD.tokenPath, "[*]", "");
        memberOCD.collectionDescriptor = OtclCommandDto.CollectionDescriptor.COLLECTION_MEMBER;
        otclCommandDto.addChild(memberOCD);
        memberOCD.parent = otclCommandDto;
        return memberOCD;
    }

    public static OtclCommandDto createMapMember(String id, OtclCommandDto otclCommandDto, String otclChain, String[] otclTokens, boolean isLeaf) {
        String otclToken = otclTokens[otclCommandDto.otclTokenIndex];
        String memberOtclToken = null;
        boolean isKey = false;
        if (otclToken.contains("<K>")) {
            memberOtclToken = "<K>" + otclCommandDto.fieldName;
            isKey = true;
        } else if (otclToken.contains("<V>")) {
            memberOtclToken = "<V>" + otclCommandDto.fieldName;
        }
        if (memberOtclToken == null) {
            throw new OtclException("", "Oops... OTCL-token didn't pass Semantics-checker in Script-block : " + id + " - <K> / <V> notation missing.");
        }
        OtclCommandDto memberOCD = otclCommandDto.children.get(memberOtclToken);
        if (memberOCD != null) {
            return memberOCD;
        }
        Field field = otclCommandDto.field;
        Type parameterizedType = field.getGenericType();
        otclCommandDto.collectionDescriptor = OtclCommandDto.CollectionDescriptor.MAP;
        OtclCommandDto mainOCD = null;
        OtclCommandDto keyMemberOCD = OtclCommandDtoFactory.createMapMember(otclCommandDto, parameterizedType, isLeaf, true);
        OtclCommandDto valueMemberOCD = OtclCommandDtoFactory.createMapMember(otclCommandDto, parameterizedType, isLeaf, false);
        String chainPath = otclCommandDto.tokenPath;
        if (chainPath.contains("<K>")) {
            chainPath = chainPath.replace("<K>", "");
        } else if (chainPath.contains("<V>")) {
            chainPath = chainPath.replace("<V>", "");
        }
        otclCommandDto.tokenPath = chainPath;
        mainOCD = isKey ? keyMemberOCD : valueMemberOCD;
        return mainOCD;
    }

    public static OtclCommandDto createMapMember(OtclCommandDto otclCommandDto, Type parameterizedType, boolean isLeaf, boolean isKey) {
        OtclCommandDto memberOCD;
        Class<?> memberOtclGenericTypeClz = null;
        String memberConcreteType = null;
        String memberOtclToken = null;
        if (isKey) {
            memberOtclToken = "<K>" + otclCommandDto.fieldName;
            memberConcreteType = otclCommandDto.mapKeyConcreteType;
        } else {
            memberOtclToken = "<V>" + otclCommandDto.fieldName;
            memberConcreteType = otclCommandDto.mapValueConcreteType;
        }
        if (!CommonUtils.isEmpty(memberConcreteType)) {
            memberOtclGenericTypeClz = CommonUtils.loadClass(memberConcreteType);
        }
        if ((memberOCD = otclCommandDto.children.get(memberOtclToken)) == null) {
            Class memberType = null;
            memberType = isKey ? (Class)((ParameterizedType)parameterizedType).getActualTypeArguments()[0] : (Class)((ParameterizedType)parameterizedType).getActualTypeArguments()[1];
            memberOCD = OtclCommandDtoFactory.create(otclCommandDto.enumTargetSource, memberOtclToken, otclCommandDto.tokenPath, otclCommandDto.otclTokenIndex, otclCommandDto.fieldName, memberConcreteType, false, null, memberType, memberOtclGenericTypeClz, isLeaf);
            memberOCD.tokenPath = CommonUtils.replaceLast(memberOCD.tokenPath, "<K>", "");
            memberOCD.tokenPath = CommonUtils.replaceLast(memberOCD.tokenPath, "<V>", "");
            if (isKey) {
                memberOCD.collectionDescriptor = OtclCommandDto.CollectionDescriptor.MAP_KEY;
                memberOCD.tokenPath = memberOCD.tokenPath + "<K>";
            } else {
                memberOCD.collectionDescriptor = OtclCommandDto.CollectionDescriptor.MAP_VALUE;
                memberOCD.tokenPath = memberOCD.tokenPath + "<V>";
            }
            otclCommandDto.addChild(memberOCD);
            memberOCD.parent = otclCommandDto;
        } else {
            memberOCD.concreteTypeName = memberConcreteType;
            memberOCD.concreteType = memberOtclGenericTypeClz;
        }
        return memberOCD;
    }
}

