/*
 * Decompiled with CFR 0.152.
 */
package org.otcl2.common.util;

import org.otcl2.common.exception.OtclException;
import org.otcl2.common.util.CommonUtils;

public class OtclUtils {
    public static String createOtclFileName(String sourceClz, String targetClz) {
        if (CommonUtils.isEmpty(sourceClz) || CommonUtils.isEmpty(targetClz)) {
            throw new OtclException("", "Either Target-class or Source-class is null.");
        }
        StringBuilder fileName = new StringBuilder(sourceClz);
        fileName.append("_").append(targetClz).append(".otcl");
        return fileName.toString();
    }

    public static String createDeploymentId(String otclNamespace, Object source, Class<?> targetClz) {
        if (source == null) {
            return OtclUtils.createDeploymentId(otclNamespace, null, targetClz.getName());
        }
        return OtclUtils.createDeploymentId(otclNamespace, source.getClass().getName(), targetClz.getName());
    }

    public static String createDeploymentId(String otclNamespace, Class<?> sourceClz, Class<?> targetClz) {
        return OtclUtils.createDeploymentId(otclNamespace, sourceClz.getName(), targetClz.getName());
    }

    public static String createDeploymentId(String otclNamespace, String sourceClz, String targetClz) {
        String deploymentId = null;
        deploymentId = sourceClz == null ? targetClz : sourceClz + "_" + targetClz;
        if (!CommonUtils.isEmpty(otclNamespace)) {
            deploymentId = otclNamespace + "." + deploymentId;
        }
        return deploymentId;
    }

    public static String sanitizeOtcl(String otclChain) {
        int idx;
        if (otclChain.contains("^")) {
            otclChain = otclChain.replace("^", "");
        }
        int idxEnd = 0;
        do {
            if ((idx = otclChain.indexOf("[*,*", idxEnd)) < 0) {
                idx = otclChain.indexOf("[^*,*", idxEnd);
            }
            if (idx > 0) {
                idxEnd = otclChain.indexOf("]", idx) + 1;
                otclChain = otclChain.replace(otclChain.substring(idx, idxEnd), "[*,*]");
                continue;
            }
            idx = otclChain.indexOf("[", idxEnd);
            if (idx <= 0) continue;
            idxEnd = otclChain.indexOf("]", idx) + 1;
            otclChain = otclChain.replace(otclChain.substring(idx, idxEnd), "[*]");
        } while ((idx = otclChain.indexOf("[", idxEnd)) >= 0);
        return otclChain;
    }

    public static String retrieveIndexCharacter(String otclToken) {
        int idxCollectionNotation = otclToken.indexOf("[") + 1;
        int idxEndCollectionNotation = otclToken.indexOf("]");
        String idxCharacter = otclToken.substring(idxCollectionNotation, idxEndCollectionNotation);
        return idxCharacter;
    }
}

