/*
 * Decompiled with CFR 0.152.
 */
package org.otcl2.common.util;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.IdentityHashMap;
import java.util.Map;
import org.otcl2.common.exception.PropertyConverterException;

public class PropertyConverterUtil {
    private static final String HEX_PREFIX = "0x";
    private static final int HEX_RADIX = 16;
    private static final String BIN_PREFIX = "0b";
    private static final int BIN_RADIX = 2;
    private static final Class<?>[] CONSTR_ARGS = new Class[]{String.class};
    private static final Map<Class<?>, Class<?>> wrapperTypes = new IdentityHashMap(9);
    private static final Map<Class<?>, Class<?>> allTypes;

    public static Integer toInteger(Object value) {
        Number num = PropertyConverterUtil.toNumber(value, Integer.class);
        if (num instanceof Integer) {
            return (Integer)num;
        }
        return new Integer(num.intValue());
    }

    static Number toNumber(Object value, Class<?> clz) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        String strValue = value.toString();
        try {
            if (strValue.startsWith(HEX_PREFIX)) {
                return new BigInteger(strValue.substring(HEX_PREFIX.length()), 16);
            }
            if (strValue.startsWith(BIN_PREFIX)) {
                return new BigInteger(strValue.substring(BIN_PREFIX.length()), 2);
            }
            Constructor<?> constr = clz.getConstructor(CONSTR_ARGS);
            return (Number)constr.newInstance(strValue);
        }
        catch (NumberFormatException nex) {
            String errMsg = null;
            if (strValue.startsWith(HEX_PREFIX)) {
                errMsg = "! Invalid hex number.";
            } else if (strValue.startsWith(BIN_PREFIX)) {
                errMsg = "! Invalid binary number.";
            }
            throw new PropertyConverterException("Number Conversion error! Error converting '" + strValue + "' to " + clz.getName() + errMsg, nex);
        }
        catch (Exception ex) {
            throw new PropertyConverterException("Number Conversion error! Error converting '" + strValue + "' to " + clz.getName(), ex);
        }
    }

    public static Boolean toBooleanObject(String str) {
        if (str == "true") {
            return Boolean.TRUE;
        }
        if (str == null) {
            return null;
        }
        switch (str.length()) {
            case 1: {
                char ch0 = str.charAt(0);
                if (ch0 == 'y' || ch0 == 'Y' || ch0 == 't' || ch0 == 'T') {
                    return Boolean.TRUE;
                }
                if (ch0 != 'n' && ch0 != 'N' && ch0 != 'f' && ch0 != 'F') break;
                return Boolean.FALSE;
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                if (!(ch0 != 'o' && ch0 != 'O' || ch1 != 'n' && ch1 != 'N')) {
                    return Boolean.TRUE;
                }
                if (ch0 != 'n' && ch0 != 'N' || ch1 != 'o' && ch1 != 'O') break;
                return Boolean.FALSE;
            }
            case 3: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                if (!(ch0 != 'y' && ch0 != 'Y' || ch1 != 'e' && ch1 != 'E' || ch2 != 's' && ch2 != 'S')) {
                    return Boolean.TRUE;
                }
                if (ch0 != 'o' && ch0 != 'O' || ch1 != 'f' && ch1 != 'F' || ch2 != 'f' && ch2 != 'F') break;
                return Boolean.FALSE;
            }
            case 4: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                if (ch0 != 't' && ch0 != 'T' || ch1 != 'r' && ch1 != 'R' || ch2 != 'u' && ch2 != 'U' || ch3 != 'e' && ch3 != 'E') break;
                return Boolean.TRUE;
            }
            case 5: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                char ch4 = str.charAt(4);
                if (ch0 != 'f' && ch0 != 'F' || ch1 != 'a' && ch1 != 'A' || ch2 != 'l' && ch2 != 'L' || ch3 != 's' && ch3 != 'S' || ch4 != 'e' && ch4 != 'E') break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    static {
        wrapperTypes.put(Boolean.class, Boolean.TYPE);
        wrapperTypes.put(Byte.class, Byte.TYPE);
        wrapperTypes.put(Character.class, Character.TYPE);
        wrapperTypes.put(Double.class, Double.TYPE);
        wrapperTypes.put(Float.class, Float.TYPE);
        wrapperTypes.put(Integer.class, Integer.TYPE);
        wrapperTypes.put(Long.class, Long.TYPE);
        wrapperTypes.put(Short.class, Short.TYPE);
        wrapperTypes.put(Void.class, Void.TYPE);
        allTypes = new IdentityHashMap(wrapperTypes);
        allTypes.put(BigInteger.class, BigInteger.class);
        allTypes.put(BigDecimal.class, BigDecimal.class);
    }
}

