/*
 * Decompiled with CFR 0.152.
 */
package org.otcl2.common.engine.compiler;

import org.otcl2.common.dto.OtclDto;

public final class CompilationReport {
    public String otclNamespace;
    public String otclFileName;
    public String message;
    public boolean didSucceed;
    public Throwable cause;
    public OtclDto otclDto;

    private CompilationReport(Builder builder) {
        this.otclNamespace = builder.otclNamespace;
        this.otclFileName = builder.otclFileName;
        this.message = builder.message;
        this.didSucceed = builder.didSucceed;
        this.cause = builder.cause;
        this.otclDto = builder.otclDto;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "CompilationReport [otclPackage=" + this.otclNamespace + ", otclFileName=" + this.otclFileName + ", message=" + this.message + ", didSucceed=" + this.didSucceed + ", cause=" + this.cause + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.didSucceed ? 1231 : 1237);
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.otclDto == null ? 0 : this.otclDto.hashCode());
        result = 31 * result + (this.otclFileName == null ? 0 : this.otclFileName.hashCode());
        result = 31 * result + (this.otclNamespace == null ? 0 : this.otclNamespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompilationReport other = (CompilationReport)obj;
        if (this.didSucceed != other.didSucceed) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.otclDto == null ? other.otclDto != null : !this.otclDto.equals(other.otclDto)) {
            return false;
        }
        if (this.otclFileName == null ? other.otclFileName != null : !this.otclFileName.equals(other.otclFileName)) {
            return false;
        }
        return !(this.otclNamespace == null ? other.otclNamespace != null : !this.otclNamespace.equals(other.otclNamespace));
    }

    public static class Builder {
        private String otclNamespace;
        private String otclFileName;
        private String message;
        private boolean didSucceed;
        private Throwable cause;
        private OtclDto otclDto;

        public Builder addOtclNamespace(String otclNamespace) {
            this.otclNamespace = otclNamespace;
            return this;
        }

        public Builder addOtclFileName(String otclFileName) {
            this.otclFileName = otclFileName;
            return this;
        }

        public Builder addMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder addDidSucceed(boolean didSucceed) {
            this.didSucceed = didSucceed;
            return this;
        }

        public Builder addCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public Builder addOtclDto(OtclDto otclDto) {
            this.otclDto = otclDto;
            return this;
        }

        public CompilationReport build() {
            return new CompilationReport(this);
        }
    }
}

