/*
 * Decompiled with CFR 0.152.
 */
package org.otcl2.common.dto;

import java.util.Arrays;

public final class OtclChainDto {
    public String otclChain;
    public int collectionCount;
    public int dictionaryCount;
    public String[] rawOtclTokens;
    public String[] otclTokens;

    public OtclChainDto() {
    }

    private OtclChainDto(Builder builder) {
        this.otclChain = builder.otclChain;
        this.collectionCount = builder.collectionCount;
        this.dictionaryCount = builder.dictionaryCount;
        this.rawOtclTokens = builder.rawOtclTokens;
        this.otclTokens = builder.otclTokens;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "OtclChainDto [otclChain=" + this.otclChain + ", collectionCount=" + this.collectionCount + ", dictionaryCount=" + this.dictionaryCount + ", rawOtclTokens=" + Arrays.toString(this.rawOtclTokens) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.collectionCount;
        result = 31 * result + this.dictionaryCount;
        result = 31 * result + (this.otclChain == null ? 0 : this.otclChain.hashCode());
        result = 31 * result + Arrays.hashCode(this.otclTokens);
        result = 31 * result + Arrays.hashCode(this.rawOtclTokens);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OtclChainDto other = (OtclChainDto)obj;
        if (this.collectionCount != other.collectionCount) {
            return false;
        }
        if (this.dictionaryCount != other.dictionaryCount) {
            return false;
        }
        if (this.otclChain == null ? other.otclChain != null : !this.otclChain.equals(other.otclChain)) {
            return false;
        }
        if (!Arrays.equals(this.otclTokens, other.otclTokens)) {
            return false;
        }
        return Arrays.equals(this.rawOtclTokens, other.rawOtclTokens);
    }

    public static class Builder {
        private String otclChain;
        private int collectionCount;
        private int dictionaryCount;
        public String[] rawOtclTokens;
        private String[] otclTokens;

        public Builder addOtclChain(String otclChain) {
            this.otclChain = otclChain;
            return this;
        }

        public Builder incrementCollectionCount() {
            ++this.collectionCount;
            return this;
        }

        public Builder incrementDictionaryCount() {
            ++this.dictionaryCount;
            return this;
        }

        public Builder addOtclTokens(String[] otclTokens) {
            this.otclTokens = otclTokens;
            this.rawOtclTokens = Arrays.copyOf(otclTokens, otclTokens.length);
            return this;
        }

        public String getOtclChain() {
            return this.otclChain;
        }

        public String[] getOtclTokens() {
            return this.otclTokens;
        }

        public String[] getRawOtclTokens() {
            return this.rawOtclTokens;
        }

        public OtclChainDto build() {
            return new OtclChainDto(this);
        }
    }
}

