/*
 * Decompiled with CFR 0.152.
 */
package org.otcl2.common.dto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.otcl2.common.dto.ClassDto;
import org.otcl2.common.dto.OtclCommandDto;
import org.otcl2.common.dto.ScriptDto;
import org.otcl2.common.dto.otcl.OtclFileDto;

public final class OtclDto {
    public OtclFileDto otclFileDto;
    public String otclNamespace;
    public String otclFileName;
    public Class<?> sourceClz;
    public Class<?> targetClz;
    public ClassDto mainClassDto;
    public List<ScriptDto> scriptDtos;
    public Map<String, OtclCommandDto> sourceOCDStems;
    public Map<String, OtclCommandDto> targetOCDStems;

    private OtclDto(Builder builder) {
        this.otclNamespace = builder.otclNamespace;
        this.otclFileName = builder.otclFileName;
        this.sourceClz = builder.sourceClz;
        this.targetClz = builder.targetClz;
        this.targetOCDStems = builder.targetOCDStems;
        this.sourceOCDStems = builder.sourceOCDStems;
        this.scriptDtos = builder.scriptDtos;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String otclNamespace;
        private String otclFileName;
        public String deploymentId;
        private Class<?> sourceClz;
        private Class<?> targetClz;
        public List<ScriptDto> scriptDtos;
        private Map<String, OtclCommandDto> sourceOCDStems;
        private Map<String, OtclCommandDto> targetOCDStems;

        public Builder addOtclNamespace(String otclNamespace) {
            this.otclNamespace = otclNamespace;
            return this;
        }

        public Builder addOtclFileName(String otclFileName) {
            this.otclFileName = otclFileName;
            return this;
        }

        public Builder addDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder addSourceClz(Class<?> sourceClz) {
            this.sourceClz = sourceClz;
            return this;
        }

        public Builder addTargetClz(Class<?> targetClz) {
            this.targetClz = targetClz;
            return this;
        }

        public Builder addScriptDto(ScriptDto scriptDto) {
            if (this.scriptDtos == null) {
                this.scriptDtos = new ArrayList<ScriptDto>();
            }
            this.scriptDtos.add(scriptDto);
            return this;
        }

        public Builder addSourceOtclCommandDtoStem(OtclCommandDto sourceOCD) {
            if (this.sourceOCDStems == null) {
                this.sourceOCDStems = new HashMap<String, OtclCommandDto>();
            }
            if (!this.sourceOCDStems.containsKey(sourceOCD.otclToken)) {
                this.sourceOCDStems.put(sourceOCD.otclToken, sourceOCD);
            }
            return this;
        }

        public Builder addTargetOtclCommandDtoStem(OtclCommandDto targetOCD) {
            if (this.targetOCDStems == null) {
                this.targetOCDStems = new HashMap<String, OtclCommandDto>();
            }
            if (!this.targetOCDStems.containsKey(targetOCD.otclToken)) {
                this.targetOCDStems.put(targetOCD.otclToken, targetOCD);
            }
            return this;
        }

        public OtclDto build() {
            return new OtclDto(this);
        }
    }
}

