/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.expression.test;

import java.io.StringReader;
import java.math.BigDecimal;
import java.util.Date;
import junit.framework.TestCase;
import org.outerj.expression.Expression;
import org.outerj.expression.ExpressionContext;
import org.outerj.expression.ExpressionException;
import org.outerj.expression.FormulaParser;
import org.outerj.expression.ParseException;

public class ExpressionTest
extends TestCase
implements ExpressionContext {
    private static final String VAR2_VALUE = "dit is wat tekst";
    private static final BigDecimal VAR1_VALUE = new BigDecimal(25.0);

    public ExpressionTest(String name) {
        super(name);
    }

    public void testString() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("\"abc\"");
        String result = (String)expression.evaluate(this);
        ExpressionTest.assertEquals((String)"abc", (String)result);
    }

    public void testIf() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("If(True(), \"ja\", \"nee\")");
        String result = (String)expression.evaluate(this);
        ExpressionTest.assertEquals((String)"ja", (String)result);
    }

    public void testAnd() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("And(True(),True(),True(),True())");
        Boolean result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)true, (boolean)result);
        expression = this.parseExpression("And(True(),True(),True(),False())");
        result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)false, (boolean)result);
    }

    public void testTextToDate() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("TextToDate(\"7/15/2002\")");
        Date result = (Date)expression.evaluate(this);
        ExpressionTest.assertEquals((long)new Date(102, 6, 15).getTime(), (long)result.getTime());
    }

    public void testEquals() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("\"abc\"=\"abc\"");
        Boolean result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)true, (boolean)result);
        expression = this.parseExpression("5.123=5.123");
        result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)true, (boolean)result);
        expression = this.parseExpression("TextToDate(\"7/15/2002\")=TextToDate(\"7/15/2002\")");
        result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)true, (boolean)result);
    }

    public void testNumericOperators() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("5+2*3/2");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(8.0), (Object)result);
    }

    public void testDayOfWeek() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("DayOfWeek(Date(2002,9,15))");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(1.0), (Object)result);
    }

    public void testDayOfMonth() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("DayOfMonth(Date(2002,9,15))");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(15.0), (Object)result);
    }

    public void testDayOfYear() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("DayOfYear(Date(2002,9,15))");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(258.0), (Object)result);
    }

    public void testDateCompare() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("TextToDate(\"7/15/2002\")=Date(2002,7,15)");
        Boolean result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)true, (boolean)result);
    }

    public void testBeginOfMonth() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("BeginOfMonth(Date(2003,2,15))=Date(2003,2,1)");
        Boolean result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)true, (boolean)result);
    }

    public void testEndOfMonth() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("EndOfMonth(Date(2003,2,15))=Date(2003,2,28)");
        Boolean result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)true, (boolean)result);
    }

    public void testBeginOfQuarter() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("BeginOfQuarter(Date(2003,2,15))=Date(2003,1,1)");
        Boolean result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)true, (boolean)result);
    }

    public void testEndOfQuarter() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("EndOfQuarter(Date(2003,2,15))=Date(2003,3,31)");
        Boolean result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)true, (boolean)result);
    }

    public void testBeginOfYear() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("BeginOfYear(Date(2002,2,15))=Date(2002,1,1)");
        Boolean result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)true, (boolean)result);
    }

    public void testEndOfYear() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("EndOfYear(Date(2002,2,15))=Date(2002,12,31)");
        Boolean result = (Boolean)expression.evaluate(this);
        ExpressionTest.assertEquals((boolean)true, (boolean)result);
    }

    public void testFloor() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("Floor(5.6)");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(5.0), (Object)result);
    }

    public void testCeiling() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("Ceiling(5.6)");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(6.0), (Object)result);
    }

    public void testRemainder() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("Remainder(20,3)");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(2.0), (Object)result);
    }

    public void testPower() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("Power(5,3)");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(125.0), (Object)result);
    }

    public void testAbs() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("Abs(-5)");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(5.0), (Object)result);
    }

    public void testUpperCase() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("UpperCase(\"abc\")");
        String result = (String)expression.evaluate(this);
        ExpressionTest.assertEquals((String)"ABC", (String)result);
    }

    public void testLowerCase() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("LowerCase(\"ABC\")");
        String result = (String)expression.evaluate(this);
        ExpressionTest.assertEquals((String)"abc", (String)result);
    }

    public void testConcat() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("Concat(\"abc\",\"def\")");
        String result = (String)expression.evaluate(this);
        ExpressionTest.assertEquals((String)"abcdef", (String)result);
    }

    public void testTrim() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("Trim(\"   abc    \")");
        String result = (String)expression.evaluate(this);
        ExpressionTest.assertEquals((String)"abc", (String)result);
    }

    public void testLength() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("Length(\"abc\")");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(3.0), (Object)result);
    }

    public void testSubstring() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("Substring(\"abc\", 1, 2)");
        String result = (String)expression.evaluate(this);
        ExpressionTest.assertEquals((String)"b", (String)result);
    }

    public void testDaysInMonth() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("DaysInMonth(Date(2003,6,26))");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(30.0), (Object)result);
    }

    public void testMonth() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("Month(Date(2003,6,26))");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(6.0), (Object)result);
    }

    public void testYear() throws ParseException, ExpressionException {
        Expression expression = this.parseExpression("Year(Date(2003,6,26))");
        BigDecimal result = (BigDecimal)expression.evaluate(this);
        ExpressionTest.assertEquals((Object)new BigDecimal(2003.0), (Object)result);
    }

    public void testNVL() throws ParseException, ExpressionException {
        Expression expr1 = this.parseExpression("NVL(\"normal\",\"backupValue\")");
        String res1 = (String)expr1.evaluate(this);
        ExpressionTest.assertEquals((String)"normal", (String)res1);
        Expression expr2 = this.parseExpression("NVL(Substring(\"short\",10,2),\"backupValue\")");
        String res2 = (String)expr2.evaluate(this);
        ExpressionTest.assertEquals((String)"backupValue", (String)res2);
        Expression expr3 = this.parseExpression("NVL(var3, var1)");
        Object res3 = expr3.evaluate(this);
        ExpressionTest.assertEquals((Object)VAR1_VALUE, (Object)res3);
        boolean catchedExpectedException = false;
        try {
            Expression expr4 = this.parseExpression("NVL(var3,TextToDate(\"nodate\"))");
            expr4.evaluate(this);
            ExpressionTest.fail((String)"NVL should have just thrown the exception");
        }
        catch (ExpressionException e) {
            catchedExpectedException = true;
        }
        ExpressionTest.assertTrue((String)"NVL apparently threw another Exception then the one we expected.", (boolean)catchedExpectedException);
    }

    protected Expression parseExpression(String expressionString) throws ParseException, ExpressionException {
        FormulaParser parser = new FormulaParser(new StringReader(expressionString));
        parser.sum();
        Expression expression = parser.getExpression();
        expression.check();
        return expression;
    }

    public Object resolveVariable(String name) {
        if (name.equals("var1")) {
            return VAR1_VALUE;
        }
        if (name.equals("var2")) {
            return VAR2_VALUE;
        }
        return null;
    }

    public Object get(String name) {
        return null;
    }
}

