/*
 * Decompiled with CFR 0.152.
 */
package org.outsideMyBox.testUtils;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.outsideMyBox.testUtils.BeanLikeTesterException;

public final class BeanLikeTester {
    private static final ConstructorSignatureAndPropertiesMapping NOARG_SIGNATUREANDPROPS = new ConstructorSignatureAndPropertiesMapping();
    private final Class<?> beanLikeClass;
    private final ConstructorSignatureAndPropertiesMapping constructorsSignaturesAndProperties;
    private final Set<String> gettablePropertyNames;
    private final Set<String> settablePropertyNames;
    private final Set<String> mutablePropertyNames;
    private final Map<String, Method> accessors;
    private final Map<String, Method> setters;

    public BeanLikeTester(Class<?> beanLikeClass, ConstructorSignatureAndPropertiesMapping constructorsSignaturesAndProperties) {
        this.beanLikeClass = beanLikeClass;
        this.constructorsSignaturesAndProperties = constructorsSignaturesAndProperties == null ? NOARG_SIGNATUREANDPROPS : constructorsSignaturesAndProperties;
        this.accessors = this.getAccessors();
        this.setters = this.getSetters();
        this.gettablePropertyNames = this.accessors.keySet();
        this.settablePropertyNames = this.setters.keySet();
        this.mutablePropertyNames = this.getMutableProperyNames();
        this.verifyConstructorSignaturesMatchSignaturesFromArgs();
        this.verifySettersAndAccessorsAreValid();
        this.verifyAllPropertiesHaveAnAccessor();
    }

    public BeanLikeTester(Class<?> beanClass) {
        this(beanClass, null);
    }

    private Set<String> getMutableProperyNames() {
        HashSet<String> settableProperties = new HashSet<String>();
        for (List props : this.constructorsSignaturesAndProperties.values()) {
            settableProperties.addAll(props);
        }
        settableProperties.addAll(this.settablePropertyNames);
        return settableProperties;
    }

    private void verifyConstructorSignaturesMatchSignaturesFromArgs() {
        Set signaturesFromArgs = this.constructorsSignaturesAndProperties.keySet();
        HashSet signaturesFromConstructor = new HashSet();
        for (Constructor<?> constructor : this.beanLikeClass.getConstructors()) {
            List<Class<?>> signature = Arrays.asList(constructor.getParameterTypes());
            signaturesFromConstructor.add(signature);
        }
        if (!signaturesFromArgs.equals(signaturesFromConstructor)) {
            throw new BeanLikeTesterException("The signatures from the constructor's argument must be the same as the bean:\nFrom args:  " + signaturesFromArgs + "\nFrom object:" + signaturesFromConstructor);
        }
    }

    private void verifySettersAndAccessorsAreValid() {
        Method[] methods;
        for (Method method : methods = this.beanLikeClass.getMethods()) {
            String methodName = method.getName();
            if (this.isSetter(method)) {
                throw new BeanLikeTesterException("The method '" + methodName + "' must not return an object.");
            }
            if (this.isIsGetter(method)) {
                throw new BeanLikeTesterException("The method '" + methodName + "' doesn't return a boolean");
            }
            if (!this.isGetGetter(method)) continue;
            throw new BeanLikeTesterException("The method '" + methodName + "' doesn't return an object");
        }
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && !method.getReturnType().equals(Void.TYPE);
    }

    private boolean isIsGetter(Method method) {
        return method.getName().startsWith("is") && !method.getReturnType().equals(Boolean.class) && !method.getReturnType().equals(Boolean.TYPE);
    }

    private boolean isGetGetter(Method method) {
        return method.getName().startsWith("get") && !method.getName().equals("getClass") && method.getParameterTypes().length == 0 && method.getReturnType().equals(Void.TYPE);
    }

    private void verifyAllPropertiesHaveAnAccessor() {
        HashSet<String> nonAccessibleProperties = new HashSet<String>(this.mutablePropertyNames);
        nonAccessibleProperties.removeAll(this.gettablePropertyNames);
        if (!nonAccessibleProperties.isEmpty()) {
            throw new BeanLikeTesterException("The following properties don't have any accessor:" + nonAccessibleProperties);
        }
    }

    private static Object createNewInstance(String fullyQualifiedClassName, Class<?>[] constructorSignature, Object ... constructorParams) {
        try {
            Class<?> classToInstantiate = Class.forName(fullyQualifiedClassName);
            Constructor<?> classConstructor = classToInstantiate.getConstructor(constructorSignature);
            return classConstructor.newInstance(constructorParams);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("exception msg: {0} \n\tfullyQualifiedClassName: {1} \n\tconstructorSignature: {2} \n\tconstructorParams: {3}", e, fullyQualifiedClassName, Arrays.asList(constructorSignature), Arrays.asList(constructorParams));
            throw new BeanLikeTesterException(msg, e);
        }
    }

    private static Object invokeMethod(Object object, Method method, Object ... args) {
        try {
            return method.invoke(object, args);
        }
        catch (Exception e) {
            throw new BeanLikeTesterException(e.getMessage(), e);
        }
    }

    private static String getPropertyNameFromMethodName(String methodName) {
        String propertyName = methodName.replaceFirst("^is|set|get", "");
        return Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private static Object[] createArrayFromArrayObject(Object o) {
        if (!o.getClass().getComponentType().isPrimitive()) {
            return (Object[])o;
        }
        int arrayLength = Array.getLength(o);
        Object[] elements = new Object[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            elements[i] = Array.get(o, i);
        }
        return elements;
    }

    private static boolean areValuesDifferent(Object value1, Object value2) {
        if (value1 != null && value2 != null && value1.getClass().isArray() && value2.getClass().isArray()) {
            Object[] array2;
            Object[] array1 = BeanLikeTester.createArrayFromArrayObject(value1);
            return !Arrays.deepEquals(array1, array2 = BeanLikeTester.createArrayFromArrayObject(value2));
        }
        boolean conditionToFail1 = value1 != null && (value2 == null || !value1.equals(value2));
        boolean conditionToFail2 = value2 != null && (value1 == null || !value2.equals(value1));
        return conditionToFail1 || conditionToFail2;
    }

    private void setProperty(Object beanLike, String propertyName, Object value) {
        Method setter = this.setters.get(propertyName);
        BeanLikeTester.invokeMethod(beanLike, setter, value);
    }

    private Map<String, Method> getAccessors() {
        Method[] methods;
        HashMap<String, Method> propsAndAccessors = new HashMap<String, Method>();
        for (Method method : methods = this.beanLikeClass.getMethods()) {
            String methodName = method.getName();
            if (methodName.startsWith("is")) {
                propsAndAccessors.put(BeanLikeTester.getPropertyNameFromMethodName(methodName), method);
                continue;
            }
            if (!methodName.startsWith("get") || methodName.equals("getClass") || method.getParameterTypes().length != 0) continue;
            propsAndAccessors.put(BeanLikeTester.getPropertyNameFromMethodName(methodName), method);
        }
        return propsAndAccessors;
    }

    private Object getNewInstance(Constructor<?> constructor, PropertiesAndValues propertiesAndValues) {
        Class<?>[] constructorSignature = constructor.getParameterTypes();
        List propertyNames = (List)this.constructorsSignaturesAndProperties.get(Arrays.asList(constructorSignature));
        ArrayList propertyValues = new ArrayList();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                propertyValues.add(propertiesAndValues.get(propertyName));
            }
        }
        return BeanLikeTester.createNewInstance(this.beanLikeClass.getName(), constructorSignature, propertyValues.toArray());
    }

    private Map<String, Method> getSetters() {
        Method[] methods;
        HashMap<String, Method> propsAndSetters = new HashMap<String, Method>();
        for (Method method : methods = this.beanLikeClass.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("set")) continue;
            propsAndSetters.put(BeanLikeTester.getPropertyNameFromMethodName(methodName), method);
        }
        return propsAndSetters;
    }

    private void verifyPropertyValuesFromAccessors(Object beanLike, List<String> propertiesToVerify, PropertiesAndValues propertiesAndValuesExpected) {
        for (String propertyToVerify : propertiesToVerify) {
            this.verifyPropertyValueFromAccessor(beanLike, propertyToVerify, propertiesAndValuesExpected.get(propertyToVerify));
        }
    }

    private void verifyPropertyValueFromAccessor(Object beanLike, String propertyName, Object expectedValue) {
        Object returnedValue = this.getProperty(beanLike, propertyName);
        if (BeanLikeTester.areValuesDifferent(expectedValue, returnedValue)) {
            throw new BeanLikeTesterException("The value of the property '" + propertyName + "' returned (" + returnedValue + ") is not the same as the one expected (" + expectedValue + ")");
        }
    }

    private Object getProperty(Object beanLike, String propertyName) {
        Method accessor = this.accessors.get(propertyName);
        Object returnedValue = BeanLikeTester.invokeMethod(beanLike, accessor, null);
        return returnedValue;
    }

    private void verifyPropertyNamesAreTheSameAs(Set<String> propertyNamesToTest) {
        if (!this.gettablePropertyNames.equals(propertyNamesToTest)) {
            throw new BeanLikeTesterException("The set of properties to test is different from the properties accessible from the object:\nFrom object: " + this.gettablePropertyNames + "\nTo test:     " + propertyNamesToTest);
        }
    }

    private void verifyContainsAtLeastAllMutableProperties(Set<String> properties) {
        if (!properties.containsAll(this.mutablePropertyNames)) {
            throw new BeanLikeTesterException("The properties defined in parameter must at least contain all the settable properties of the object.\nParameter:" + properties + "\nObject:" + this.mutablePropertyNames);
        }
    }

    private Object createObjectWithSecificPropertySet(PropertiesAndValues propsWithDefaultValue, String property, Object value) {
        PropertiesAndValues propsWithValue = new PropertiesAndValues(propsWithDefaultValue);
        propsWithValue.put(property, value);
        if (this.settablePropertyNames.contains(property)) {
            Object object = this.createObjectWithDefaultValues(propsWithDefaultValue);
            this.setProperty(object, property, value);
            return object;
        }
        for (Map.Entry entry : this.constructorsSignaturesAndProperties.entrySet()) {
            List constructorPropertyNames = (List)entry.getValue();
            if (!constructorPropertyNames.contains(property)) continue;
            Class[] constructorSignature = ((List)entry.getKey()).toArray(new Class[0]);
            ArrayList constructorValues = new ArrayList();
            for (String propertyName : constructorPropertyNames) {
                constructorValues.add(propsWithValue.get(propertyName));
            }
            return BeanLikeTester.createNewInstance(this.beanLikeClass.getName(), constructorSignature, constructorValues.toArray());
        }
        throw new RuntimeException("The property '" + property + "' must be settable by either a setter or a constructor!");
    }

    private Object createObjectWithDefaultValues(PropertiesAndValues propsWithDefaultValue) {
        Constructor<?> constructor = this.beanLikeClass.getConstructors()[0];
        return this.getNewInstance(constructor, propsWithDefaultValue);
    }

    private void verifyAllValuesFromMutablePropsAreDifferent(PropertiesAndValues propsWithValue, PropertiesAndValues propsWithOtherValue) {
        for (Map.Entry entry : propsWithValue.entrySet()) {
            String property = (String)entry.getKey();
            Object value = entry.getValue();
            if (!this.mutablePropertyNames.contains(property) || BeanLikeTester.areValuesDifferent(value, propsWithOtherValue.get(property))) continue;
            throw new BeanLikeTesterException("The value of the  property '" + property + "' must be different in the parameters.");
        }
    }

    public void testDefaultValues(PropertiesAndValues expectedDefaultValues) {
        this.verifyPropertyNamesAreTheSameAs(expectedDefaultValues.keySet());
        for (Constructor<?> constructor : this.beanLikeClass.getConstructors()) {
            Object beanLike = this.getNewInstance(constructor, expectedDefaultValues);
            for (Map.Entry<String, Method> entry : this.accessors.entrySet()) {
                String propertyName = entry.getKey();
                Object expected = expectedDefaultValues.get(propertyName);
                Object returned = this.getProperty(beanLike, propertyName);
                if (!BeanLikeTester.areValuesDifferent(returned, expected)) continue;
                throw new BeanLikeTesterException("The value of the property '" + propertyName + "' returned (" + returned + ") is not the same as the one expected (" + expected + ")");
            }
        }
    }

    public void testMutatorsAndAccessors(PropertiesAndValues propsWithValue, PropertiesAndValues otherPropsWithValue) {
        this.verifyContainsAtLeastAllMutableProperties(propsWithValue.keySet());
        this.verifyContainsAtLeastAllMutableProperties(otherPropsWithValue.keySet());
        for (Constructor<?> constructor : this.beanLikeClass.getConstructors()) {
            List<Class<?>> constructorSignature = Arrays.asList(constructor.getParameterTypes());
            Object beanLike = this.getNewInstance(constructor, otherPropsWithValue);
            if (!constructorSignature.isEmpty()) {
                List propertyNamesInConstructor = (List)this.constructorsSignaturesAndProperties.get(constructorSignature);
                this.verifyPropertyValuesFromAccessors(beanLike, propertyNamesInConstructor, otherPropsWithValue);
            }
            ArrayList<PropertiesAndValues> rounds = new ArrayList<PropertiesAndValues>();
            rounds.add(propsWithValue);
            rounds.add(otherPropsWithValue);
            for (PropertiesAndValues propertiesAndValues : rounds) {
                for (Map.Entry<String, Method> entry : this.setters.entrySet()) {
                    String propertyName = entry.getKey();
                    Object valueToSet = propertiesAndValues.get(propertyName);
                    this.setProperty(beanLike, propertyName, valueToSet);
                    this.verifyPropertyValueFromAccessor(beanLike, propertyName, valueToSet);
                }
            }
        }
    }

    public void testEqualsAndHash(PropertiesAndValues propsWithDefaultValue, PropertiesAndValues propsWithOtherValue) {
        this.verifyContainsAtLeastAllMutableProperties(propsWithDefaultValue.keySet());
        this.verifyContainsAtLeastAllMutableProperties(propsWithOtherValue.keySet());
        this.verifyAllValuesFromMutablePropsAreDifferent(propsWithDefaultValue, propsWithOtherValue);
        Object defaultObj = this.createObjectWithDefaultValues(propsWithDefaultValue);
        int defaultHashCode = defaultObj.hashCode();
        if (!defaultObj.equals(defaultObj)) {
            throw new BeanLikeTesterException("The equals method must return true when the object is compared to itself:\nObject:" + defaultObj);
        }
        if (defaultObj.equals(null)) {
            throw new BeanLikeTesterException("The comparison with null must return false.\nObject:" + defaultObj);
        }
        if (defaultObj.equals(AClassToBeTestedAgainst.instance)) {
            throw new BeanLikeTesterException("The comparison with another class must return false.\nObject:" + defaultObj);
        }
        for (Map.Entry entry : propsWithOtherValue.entrySet()) {
            String property = (String)entry.getKey();
            Object value = entry.getValue();
            if (!this.mutablePropertyNames.contains(property)) continue;
            Object otherObject1 = this.createObjectWithSecificPropertySet(propsWithDefaultValue, property, value);
            int otherHashCode1 = otherObject1.hashCode();
            if (!BeanLikeTester.areValuesDifferent(defaultHashCode, otherHashCode1)) {
                throw new BeanLikeTesterException("The hashcodes of different objects should be different for the tests, please change the values or check that hashcode() is correct\nobject1:" + defaultObj + " hashcode:" + defaultHashCode + "\nobject2:" + otherObject1 + " hashcode:" + otherHashCode1);
            }
            boolean equals1 = otherObject1.equals(defaultObj);
            boolean equals2 = defaultObj.equals(otherObject1);
            if (equals1 || equals2) {
                throw new BeanLikeTesterException("The equals method must return false for the comparison between objects with different properties:\nobject1:" + otherObject1 + "\nobject2:" + defaultObj);
            }
            Object otherObject2 = this.createObjectWithSecificPropertySet(propsWithDefaultValue, property, value);
            int otherHashCode2 = otherObject2.hashCode();
            if (!otherObject1.equals(otherObject2)) {
                throw new BeanLikeTesterException("The equals method should return true for the comparison between objects with the same properties:\nobject1:" + otherObject1 + "\nobject2:" + otherObject2);
            }
            if (otherHashCode1 == otherHashCode2) continue;
            throw new BeanLikeTesterException("The hashcodes must be equal:\nobject1:" + otherObject1 + " hashcode:" + otherHashCode1 + "\nobject2:" + otherObject2 + " hashcode:" + otherHashCode2);
        }
    }

    public void testToString(PropertiesAndValues propsWithDefaultValue, PropertiesAndValues propsWithOtherValue) {
        this.verifyContainsAtLeastAllMutableProperties(propsWithDefaultValue.keySet());
        this.verifyContainsAtLeastAllMutableProperties(propsWithOtherValue.keySet());
        this.verifyAllValuesFromMutablePropsAreDifferent(propsWithDefaultValue, propsWithOtherValue);
        Object defaultObj = this.createObjectWithDefaultValues(propsWithDefaultValue);
        String toStringFromDefaultValues = defaultObj.toString();
        for (Map.Entry entry : propsWithOtherValue.entrySet()) {
            Object object;
            String toStringFromOtherValues;
            String property = (String)entry.getKey();
            Object value = entry.getValue();
            if (!this.mutablePropertyNames.contains(property) || BeanLikeTester.areValuesDifferent(toStringFromDefaultValues, toStringFromOtherValues = (object = this.createObjectWithSecificPropertySet(propsWithDefaultValue, property, value)).toString())) continue;
            throw new BeanLikeTesterException("The result of toString() should depend on the property '" + property + "'");
        }
    }

    public void testBeanLike(PropertiesAndValues propsWithDefaultValue, PropertiesAndValues propsWithOtherValue) {
        this.testDefaultValues(propsWithDefaultValue);
        this.testMutatorsAndAccessors(propsWithDefaultValue, propsWithOtherValue);
        this.testEqualsAndHash(propsWithDefaultValue, propsWithOtherValue);
        this.testToString(propsWithDefaultValue, propsWithOtherValue);
    }

    static {
        NOARG_SIGNATUREANDPROPS.put(Collections.emptyList(), Collections.emptyList());
    }

    private static final class AClassToBeTestedAgainst {
        private static AClassToBeTestedAgainst instance = new AClassToBeTestedAgainst();

        private AClassToBeTestedAgainst() {
        }
    }

    public static final class ConstructorSignatureAndPropertiesMapping
    extends HashMap<List<Class<?>>, List<String>> {
        private static final long serialVersionUID = 1L;
    }

    public static final class PropertiesAndValues
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 1L;

        public PropertiesAndValues(PropertiesAndValues defaultValues) {
            super(defaultValues);
        }

        public PropertiesAndValues() {
        }
    }
}

