/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.jaxrs.util;

import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.ow2.authzforce.jaxrs.util.JaxbErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ServerErrorExceptionMapper
implements ExceptionMapper<ServerErrorException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerErrorExceptionMapper.class);
    private static final String INTERNAL_ERR_MSG = "Internal server error:";
    private static final JaxbErrorMessage ERROR = new JaxbErrorMessage("Internal server error. Retry later or contact the administrator.");

    public Response toResponse(ServerErrorException exception) {
        if (exception instanceof InternalServerErrorException) {
            LOGGER.error(INTERNAL_ERR_MSG, (Throwable)exception);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ERROR).build();
        }
        return exception.getResponse();
    }
}

