/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.jaxrs.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.ow2.authzforce.xacml.json.model.LimitsCheckingJSONObject;

@Produces(value={"application/json", "application/*+json"})
@Consumes(value={"application/json", "application/*+json"})
@Provider
public final class JsonRiJaxrsProvider
implements MessageBodyReader<JSONObject>,
MessageBodyWriter<JSONObject> {
    private static final BadRequestException EMPTY_JSON_OBJECT_BAD_REQUEST_EXCEPTION = new BadRequestException("object cannot be empty");
    private static final JsonObjectFactory DEFAULT_JSON_TOKENER_FACTORY = new BaseJsonObjectFactory();
    private final JsonObjectFactory jsonObjectFactory;

    public JsonRiJaxrsProvider() {
        this.jsonObjectFactory = DEFAULT_JSON_TOKENER_FACTORY;
    }

    public JsonRiJaxrsProvider(final Schema schema) {
        this.jsonObjectFactory = schema == null ? DEFAULT_JSON_TOKENER_FACTORY : new BaseJsonObjectFactory(){

            @Override
            protected void schemaValidate(JSONObject jsonObj) throws ValidationException {
                schema.validate((Object)jsonObj);
            }
        };
    }

    public JsonRiJaxrsProvider(final Map<String, Schema> schemasByPropertyName) {
        this.jsonObjectFactory = schemasByPropertyName == null || schemasByPropertyName.isEmpty() ? DEFAULT_JSON_TOKENER_FACTORY : new BaseJsonObjectFactory(){

            @Override
            protected void schemaValidate(JSONObject jsonObj) throws ValidationException {
                Iterator keysIt = jsonObj.keys();
                if (!keysIt.hasNext()) {
                    throw EMPTY_JSON_OBJECT_BAD_REQUEST_EXCEPTION;
                }
                Schema schema = (Schema)schemasByPropertyName.get(keysIt.next());
                if (schema != null) {
                    schema.validate((Object)jsonObj);
                }
            }
        };
    }

    public JsonRiJaxrsProvider(final Schema schema, int maxJsonStringSize, int maxNumOfImmediateChildren, int maxDepth) {
        if (maxJsonStringSize <= 0 || maxNumOfImmediateChildren <= 0 || maxDepth <= 0) {
            throw new IllegalArgumentException("one of the arguments maxJsonStringSize, maxNumOfImmediateChildren or maxDepth is negative or null");
        }
        this.jsonObjectFactory = schema == null ? new LimitsCheckingJsonObjectFactory(maxJsonStringSize, maxNumOfImmediateChildren, maxDepth) : new LimitsCheckingJsonObjectFactory(maxJsonStringSize, maxNumOfImmediateChildren, maxDepth){

            @Override
            protected void schemaValidate(JSONObject jsonObj) throws ValidationException {
                schema.validate((Object)jsonObj);
            }
        };
    }

    public JsonRiJaxrsProvider(final Map<String, Schema> schemasByPropertyName, int maxJsonStringSize, int maxNumOfImmediateChildren, int maxDepth) {
        if (maxJsonStringSize <= 0 || maxNumOfImmediateChildren <= 0 || maxDepth <= 0) {
            throw new IllegalArgumentException("one of the arguments maxJsonStringSize, maxNumOfImmediateChildren or maxDepth is negative or null");
        }
        this.jsonObjectFactory = schemasByPropertyName == null || schemasByPropertyName.isEmpty() ? new LimitsCheckingJsonObjectFactory(maxJsonStringSize, maxNumOfImmediateChildren, maxDepth) : new LimitsCheckingJsonObjectFactory(maxJsonStringSize, maxNumOfImmediateChildren, maxDepth){

            @Override
            protected void schemaValidate(JSONObject jsonObj) throws ValidationException {
                Iterator keysIt = jsonObj.keys();
                if (!keysIt.hasNext()) {
                    throw EMPTY_JSON_OBJECT_BAD_REQUEST_EXCEPTION;
                }
                Schema schema = (Schema)schemasByPropertyName.get(keysIt.next());
                if (schema != null) {
                    schema.validate((Object)jsonObj);
                }
            }
        };
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JSONObject.class.isAssignableFrom(type);
    }

    public long getSize(JSONObject o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(JSONObject o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try (OutputStreamWriter writer = new OutputStreamWriter(entityStream, StandardCharsets.UTF_8);){
            o.write((Writer)writer);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JSONObject.class.isAssignableFrom(type);
    }

    public JSONObject readFrom(Class<JSONObject> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return this.jsonObjectFactory.getInstance(entityStream);
        }
        catch (ValidationException | JSONException e) {
            throw new BadRequestException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ClientErrorException(Response.Status.REQUEST_ENTITY_TOO_LARGE, (Throwable)e);
        }
    }

    private static class LimitsCheckingJsonObjectFactory
    extends BaseJsonObjectFactory {
        private final int maxJsonStringSize;
        private final int maxNumOfImmediateChildren;
        private final int maxDepth;

        private LimitsCheckingJsonObjectFactory(int maxJsonStringSize, int maxNumOfImmediateChildren, int maxDepth) {
            this.maxJsonStringSize = maxJsonStringSize;
            this.maxNumOfImmediateChildren = maxNumOfImmediateChildren;
            this.maxDepth = maxDepth;
        }

        @Override
        protected final JSONObject parse(InputStream entityStream) {
            return new LimitsCheckingJSONObject(entityStream, this.maxJsonStringSize, this.maxNumOfImmediateChildren, this.maxDepth);
        }
    }

    private static class BaseJsonObjectFactory
    implements JsonObjectFactory {
        private BaseJsonObjectFactory() {
        }

        protected JSONObject parse(InputStream entityStream) {
            return new JSONObject(new JSONTokener(entityStream));
        }

        protected void schemaValidate(JSONObject jsonObj) {
        }

        @Override
        public final JSONObject getInstance(InputStream entityStream) throws ValidationException {
            JSONObject jsonObj = this.parse(entityStream);
            this.schemaValidate(jsonObj);
            return jsonObj;
        }
    }

    private static interface JsonObjectFactory {
        public JSONObject getInstance(InputStream var1) throws ValidationException;
    }
}

