/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.jaxrs.util;

import java.beans.ConstructorProperties;
import java.util.regex.Pattern;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBException;
import org.ow2.authzforce.jaxrs.util.JaxbErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Provider
public class BadRequestExceptionMapper
implements ExceptionMapper<BadRequestException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BadRequestExceptionMapper.class);
    private static final Pattern JAXBEXCEPTION_MSG_START_PATTERN = Pattern.compile("^JAXBException occurred :", 2);
    private static final String INVALID_PARAM_MSG_PREFIX = "Invalid parameters: ";
    private final int verbosityLevel;

    private static JaxbErrorMessage newJaxbErrorMessage(Throwable cause, int errVerbosityLevel) {
        if (errVerbosityLevel == 0 || cause == null) {
            return null;
        }
        return new JaxbErrorMessage(cause.getMessage(), BadRequestExceptionMapper.newJaxbErrorMessage(cause.getCause(), errVerbosityLevel - 1));
    }

    @ConstructorProperties(value={"verbosityLevel"})
    public BadRequestExceptionMapper(int verbosityLevel) {
        if (verbosityLevel < 0) {
            throw new IllegalArgumentException("Invalid verbosity level: " + verbosityLevel + ". Expected >= 0.");
        }
        this.verbosityLevel = verbosityLevel;
    }

    public BadRequestExceptionMapper() {
        this(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response toResponse(BadRequestException exception) {
        Throwable returnedCause;
        Object errMsg;
        LOGGER.info("Bad request", (Throwable)exception);
        Response oldResp = exception.getResponse();
        Throwable cause = exception.getCause();
        if (this.verbosityLevel == 0) {
            errMsg = "";
            returnedCause = null;
        } else if (cause == null) {
            returnedCause = null;
            Object oldEntity = oldResp.getEntity();
            if (!(oldEntity instanceof String)) return oldResp;
            errMsg = JAXBEXCEPTION_MSG_START_PATTERN.matcher((String)oldEntity).replaceFirst(INVALID_PARAM_MSG_PREFIX);
        } else if (cause instanceof SAXException) {
            Throwable internalCause = cause.getCause();
            if (internalCause instanceof JAXBException) {
                Throwable linkedEx = ((JAXBException)internalCause).getLinkedException();
                errMsg = INVALID_PARAM_MSG_PREFIX + linkedEx.getMessage();
                returnedCause = linkedEx.getCause();
            } else {
                errMsg = INVALID_PARAM_MSG_PREFIX + cause.getMessage();
                returnedCause = cause.getCause();
            }
        } else if (cause instanceof JAXBException) {
            Throwable linkedEx = ((JAXBException)cause).getLinkedException();
            errMsg = INVALID_PARAM_MSG_PREFIX + linkedEx.getMessage();
            returnedCause = linkedEx.getCause();
        } else if (cause instanceof ClassCastException) {
            errMsg = "Wrong type of input: " + cause.getMessage();
            returnedCause = null;
        } else {
            errMsg = cause.getMessage();
            returnedCause = cause.getCause();
        }
        JaxbErrorMessage errorEntity = errMsg == null ? new JaxbErrorMessage("", null) : new JaxbErrorMessage((String)errMsg, BadRequestExceptionMapper.newJaxbErrorMessage(returnedCause, this.verbosityLevel - 1));
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorEntity).build();
    }
}

