/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.jaxrs.util;

import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.MediaType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class AcceptMediaTypeCheckingRequestFilter
implements ContainerRequestFilter {
    private static final NotAcceptableException NOT_ACCEPTABLE_EXCEPTION = new NotAcceptableException();
    private final Set<MediaType> validMediaTypes;

    public AcceptMediaTypeCheckingRequestFilter(Iterable<String> mediaTypes) {
        Set updatableSet = StreamSupport.stream(mediaTypes.spliterator(), false).map(MediaType::valueOf).collect(Collectors.toSet());
        updatableSet.add(MediaType.WILDCARD_TYPE);
        this.validMediaTypes = Collections.unmodifiableSet(updatableSet);
    }

    public void filter(ContainerRequestContext context) {
        List acceptMediaTypes = context.getAcceptableMediaTypes();
        if (acceptMediaTypes.isEmpty()) {
            return;
        }
        if (this.validMediaTypes.contains(acceptMediaTypes.get(0))) {
            return;
        }
        throw NOT_ACCEPTABLE_EXCEPTION;
    }
}

