/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.jaxrs.util;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.ow2.authzforce.jaxrs.util.JaxbErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class DefaultExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExceptionMapper.class);
    private static final String INTERNAL_ERR_MSG = "Internal server error:";
    private static final JaxbErrorMessage ERROR = new JaxbErrorMessage("Internal server error. Retry later or contact the administrator.", null);

    public Response toResponse(Throwable exception) {
        if (exception instanceof WebApplicationException) {
            WebApplicationException ex = (WebApplicationException)exception;
            Response httpResp = ex.getResponse();
            switch (httpResp.getStatusInfo().getFamily()) {
                case SUCCESSFUL: 
                case CLIENT_ERROR: 
                case INFORMATIONAL: 
                case REDIRECTION: {
                    return httpResp;
                }
            }
        }
        LOGGER.error(INTERNAL_ERR_MSG, exception);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ERROR).build();
    }
}

