/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.pap.dao.flatfile;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.IdReferenceType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicySet;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.Request;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.Response;
import org.apache.cxf.staxutils.StaxUtils;
import org.json.JSONObject;
import org.ow2.authzforce.core.pap.api.dao.AuthzPolicy;
import org.ow2.authzforce.core.pap.api.dao.DomainDao;
import org.ow2.authzforce.core.pap.api.dao.DomainDaoClient;
import org.ow2.authzforce.core.pap.api.dao.DomainsDao;
import org.ow2.authzforce.core.pap.api.dao.PdpFeature;
import org.ow2.authzforce.core.pap.api.dao.PolicyDaoClient;
import org.ow2.authzforce.core.pap.api.dao.PolicyVersionDaoClient;
import org.ow2.authzforce.core.pap.api.dao.PrpRwProperties;
import org.ow2.authzforce.core.pap.api.dao.ReadableDomainProperties;
import org.ow2.authzforce.core.pap.api.dao.ReadablePdpProperties;
import org.ow2.authzforce.core.pap.api.dao.TooManyPoliciesException;
import org.ow2.authzforce.core.pap.api.dao.WritableDomainProperties;
import org.ow2.authzforce.core.pap.api.dao.WritablePdpProperties;
import org.ow2.authzforce.core.pdp.api.CloseablePdpEngine;
import org.ow2.authzforce.core.pdp.api.DecisionRequestPreprocessor;
import org.ow2.authzforce.core.pdp.api.DecisionResultPostprocessor;
import org.ow2.authzforce.core.pdp.api.EnvironmentProperties;
import org.ow2.authzforce.core.pdp.api.EnvironmentPropertyName;
import org.ow2.authzforce.core.pdp.api.HashCollections;
import org.ow2.authzforce.core.pdp.api.PdpExtension;
import org.ow2.authzforce.core.pdp.api.combining.CombiningAlg;
import org.ow2.authzforce.core.pdp.api.func.Function;
import org.ow2.authzforce.core.pdp.api.io.BaseXacmlJaxbResultPostprocessor;
import org.ow2.authzforce.core.pdp.api.io.IndividualXacmlJaxbRequest;
import org.ow2.authzforce.core.pdp.api.io.PdpEngineInoutAdapter;
import org.ow2.authzforce.core.pdp.api.policy.PolicyVersion;
import org.ow2.authzforce.core.pdp.api.policy.PrimaryPolicyMetadata;
import org.ow2.authzforce.core.pdp.api.policy.TopLevelPolicyElementType;
import org.ow2.authzforce.core.pdp.api.value.AttributeValueFactory;
import org.ow2.authzforce.core.pdp.api.value.AttributeValueFactoryRegistry;
import org.ow2.authzforce.core.pdp.impl.BasePdpEngine;
import org.ow2.authzforce.core.pdp.impl.DefaultEnvironmentProperties;
import org.ow2.authzforce.core.pdp.impl.PdpEngineConfiguration;
import org.ow2.authzforce.core.pdp.impl.PdpExtensions;
import org.ow2.authzforce.core.pdp.impl.PdpModelHandler;
import org.ow2.authzforce.core.pdp.impl.io.DecisionRequestPreprocessorSupplier;
import org.ow2.authzforce.core.pdp.impl.io.PdpEngineAdapters;
import org.ow2.authzforce.core.pdp.impl.io.SingleDecisionXacmlJaxbRequestPreprocessor;
import org.ow2.authzforce.core.pdp.impl.policy.PolicyVersions;
import org.ow2.authzforce.core.pdp.io.xacml.json.BaseXacmlJsonResultPostprocessor;
import org.ow2.authzforce.core.pdp.io.xacml.json.IndividualXacmlJsonRequest;
import org.ow2.authzforce.core.pdp.io.xacml.json.SingleDecisionXacmlJsonRequestPreprocessor;
import org.ow2.authzforce.core.xmlns.pdp.InOutProcChain;
import org.ow2.authzforce.core.xmlns.pdp.Pdp;
import org.ow2.authzforce.core.xmlns.pdp.StaticPolicyProvider;
import org.ow2.authzforce.core.xmlns.pdp.TopLevelPolicyElementRef;
import org.ow2.authzforce.pap.dao.flatfile.FlatFileBasedDomainDao;
import org.ow2.authzforce.pap.dao.flatfile.FlatFileDAOUtils;
import org.ow2.authzforce.pap.dao.flatfile.FlatFileDaoPolicyProvider;
import org.ow2.authzforce.pap.dao.flatfile.XmlnsAppendingDelegatingXMLStreamWriter;
import org.ow2.authzforce.pap.dao.flatfile.xmlns.DomainProperties;
import org.ow2.authzforce.pap.dao.flatfile.xmlns.StaticFlatFileDaoPolicyProviderDescriptor;
import org.ow2.authzforce.xacml.Xacml3JaxbHelper;
import org.ow2.authzforce.xmlns.pdp.ext.AbstractAttributeProvider;
import org.ow2.authzforce.xmlns.pdp.ext.AbstractPolicyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;
import org.xml.sax.SAXException;

public final class FlatFileBasedDomainsDao<VERSION_DAO_CLIENT extends PolicyVersionDaoClient, POLICY_DAO_CLIENT extends PolicyDaoClient, DOMAIN_DAO_CLIENT extends DomainDaoClient<FlatFileBasedDomainDao<VERSION_DAO_CLIENT, POLICY_DAO_CLIENT>>>
implements DomainsDao<DOMAIN_DAO_CLIENT> {
    public static final int SYNC_SERVICE_SHUTDOWN_TIMEOUT_SEC = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(FlatFileBasedDomainsDao.class);
    private static final IllegalArgumentException ILLEGAL_CONSTRUCTOR_ARGS_EXCEPTION = new IllegalArgumentException("One of the following FileBasedDomainsDao constructor arguments is undefined although required: domainsRoot == null || domainTmpl == null || schema == null || pdpModelHandler == null || domainDaoClientFactory == null || policyDaoClientFactory == null");
    private static final IllegalArgumentException NULL_DOMAIN_ID_ARG_EXCEPTION = new IllegalArgumentException("Undefined domain ID arg");
    private static final IllegalArgumentException ILLEGAL_POLICY_NOT_STATIC_EXCEPTION = new IllegalArgumentException("One of the policy finders in the domain PDP configuration is not static, or one of the policies required by PDP cannot be statically resolved");
    private static final RuntimeException NON_STATIC_POLICY_EXCEPTION = new RuntimeException("Unexpected error: Some policies are not statically resolved (pdp.getStaticApplicablePolicies() == null)");
    private static final IllegalArgumentException NULL_POLICY_ARGUMENT_EXCEPTION = new IllegalArgumentException("Null policySet arg");
    private static final IllegalArgumentException NULL_DOMAIN_PROPERTIES_ARGUMENT_EXCEPTION = new IllegalArgumentException("Null domain properties arg");
    private static final IllegalArgumentException NULL_PRP_PROPERTIES_ARGUMENT_EXCEPTION = new IllegalArgumentException("Null domain PRP properties arg");
    private static final IllegalArgumentException NULL_PDP_PROPERTIES_ARGUMENT_EXCEPTION = new IllegalArgumentException("Null domain PDP properties arg");
    private static final IllegalArgumentException NULL_ROOT_POLICY_REF_ARGUMENT_EXCEPTION = new IllegalArgumentException("Invalid domain PDP properties arg: rootPolicyRef undefined");
    private static final IllegalArgumentException NULL_ATTRIBUTE_PROVIDERS_ARGUMENT_EXCEPTION = new IllegalArgumentException("Null attributeProviders arg");
    private static final UnsupportedOperationException DISABLED_OPERATION_EXCEPTION = new UnsupportedOperationException("Unsupported operation: disabled by configuration");
    private static final RuntimeException PDP_IN_ERROR_STATE_RUNTIME_EXCEPTION = new RuntimeException("PDP in error state. Check the server logs or contact the administrator.");
    private static final UnsupportedOperationException UNSUPPORTED_XACML_JSON_PROFILE_OPERATION_EXCEPTION = new UnsupportedOperationException("Unsupported XACML/JSON (XACML Json Profile) format");
    private static final PolicyVersions<Path> EMPTY_POLICY_VERSIONS = new PolicyVersions(Collections.emptyMap());
    public static final String DOMAIN_PROPERTIES_XSD_LOCATION = "classpath:org.ow2.authzforce.pap.dao.flatfile.properties.xsd";
    public static final String DOMAIN_PROPERTIES_FILENAME = "properties.xml";
    public static final String DOMAIN_PDP_CONFIG_FILENAME = "pdp.xml";
    private static final JAXBContext DOMAIN_PROPERTIES_JAXB_CONTEXT;
    private static final Schema DOMAIN_PROPERTIES_SCHEMA;
    private static final IllegalArgumentException INVALID_FEATURE_ID_EXCEPTION;
    private static final Pattern XACML_JSON_PDP_REQUEST_PREPROC_ID_PATTERN;
    private static final Map<PdpFeatureType, Set<String>> PDP_FEATURE_IDENTIFIERS_BY_TYPE;
    private static final int PDP_FEATURE_COUNT;
    private static final DecisionRequestPreprocessor.Factory<Request, IndividualXacmlJaxbRequest> DEFAULT_XACML_XML_DECISION_REQUEST_PREPROC_FACTORY;
    private static final DecisionRequestPreprocessor.Factory<JSONObject, IndividualXacmlJsonRequest> DEFAULT_XACML_JSON_DECISION_REQUEST_PREPROC_FACTORY;
    private static final UnsupportedOperationException NULL_PDP_ERROR;
    private final TimeBasedGenerator uuidGen;
    private final Path domainsRootDir;
    private final ConcurrentMap<String, DOMAIN_DAO_CLIENT> domainMap = new ConcurrentHashMap<String, DOMAIN_DAO_CLIENT>();
    private final ConcurrentMap<String, String> domainIDsByExternalId = new ConcurrentHashMap<String, String>();
    private final Path domainTmplDirPath;
    private final PdpModelHandler pdpModelHandler;
    private final long domainDirToMemSyncIntervalSec;
    private final DomainDaoClient.Factory<VERSION_DAO_CLIENT, POLICY_DAO_CLIENT, FlatFileBasedDomainDao<VERSION_DAO_CLIENT, POLICY_DAO_CLIENT>, DOMAIN_DAO_CLIENT> domainDaoClientFactory;
    private final boolean enablePdpOnly;
    private final boolean enableXacmlJsonProfile;
    private final PolicyDaoClient.Factory<VERSION_DAO_CLIENT, POLICY_DAO_CLIENT> policyDaoClientFactory;
    private final PolicyVersionDaoClient.Factory<VERSION_DAO_CLIENT> policyVersionDaoClientFactory;

    private static TimeBasedGenerator initUUIDGenerator(boolean useRandomAddressBasedUUID) {
        EthernetAddress macAddress;
        if (useRandomAddressBasedUUID) {
            macAddress = EthernetAddress.constructMulticastAddress();
        } else {
            macAddress = EthernetAddress.fromInterface();
            if (macAddress == null) {
                throw new RuntimeException("Failed to create UUID generator (based on time and MAC address): no valid Ethernet MAC address found. Please enable at least one network interface for global uniqueness of UUIDs. If not, you can fall back to UUID generation based on random multicast address instead by setting argument: useRandomAddressBasedUUID = true");
            }
        }
        return Generators.timeBasedGenerator((EthernetAddress)macAddress);
    }

    private synchronized void removeDomainFromCache(String domainId) throws IOException {
        assert (domainId != null);
        DomainDaoClient domain = (DomainDaoClient)this.domainMap.remove(domainId);
        if (domain == null) {
            return;
        }
        try (FlatFileBasedDomainDao domainDAO = (FlatFileBasedDomainDao)domain.getDao();){
            String externalId = domainDAO.getExternalId();
            if (externalId != null) {
                this.domainIDsByExternalId.remove(externalId);
            }
        }
    }

    private synchronized DOMAIN_DAO_CLIENT addDomainToCacheAfterDirectoryCreated(String domainId, Path domainDirectory, WritableDomainProperties props) throws IOException, IllegalArgumentException {
        DomainDaoClient prevDomain = (DomainDaoClient)this.domainMap.get(domainId);
        if (prevDomain != null) {
            if (props != null) {
                throw new IllegalArgumentException("Domain '" + domainId + "' already exists with possibly different properties than the ones in arguments");
            }
            return (DOMAIN_DAO_CLIENT)prevDomain;
        }
        DomainDaoClient domainDaoClient = this.domainDaoClientFactory.getInstance(domainId, () -> {
            FileBasedDomainDaoImpl domainDao = new FileBasedDomainDaoImpl(domainDirectory, props);
            if (props != null) {
                domainDao.updateCachedExternalId(props.getExternalId());
            }
            return domainDao;
        });
        this.domainMap.put(domainId, domainDaoClient);
        return (DOMAIN_DAO_CLIENT)domainDaoClient;
    }

    @ConstructorProperties(value={"domainsRoot", "domainTmpl", "domainsSyncIntervalSec", "pdpModelHandler", "enablePdpOnly", "enableXacmlJsonProfile", "useRandomAddressBasedUUID", "domainDaoClientFactory"})
    public FlatFileBasedDomainsDao(Resource domainsRoot, Resource domainTmpl, int domainsSyncIntervalSec, PdpModelHandler pdpModelHandler, boolean enablePdpOnly, boolean enableXacmlJsonProfile, boolean useRandomAddressBasedUUID, DomainDaoClient.Factory<VERSION_DAO_CLIENT, POLICY_DAO_CLIENT, FlatFileBasedDomainDao<VERSION_DAO_CLIENT, POLICY_DAO_CLIENT>, DOMAIN_DAO_CLIENT> domainDaoClientFactory) throws IOException {
        File domainTmplFile;
        File domainsRootFile;
        if (domainsRoot == null || domainTmpl == null || pdpModelHandler == null || domainDaoClientFactory == null) {
            throw ILLEGAL_CONSTRUCTOR_ARGS_EXCEPTION;
        }
        this.domainDaoClientFactory = domainDaoClientFactory;
        this.enablePdpOnly = enablePdpOnly;
        if (enablePdpOnly) {
            this.policyDaoClientFactory = null;
            this.policyVersionDaoClientFactory = null;
        } else {
            this.policyDaoClientFactory = domainDaoClientFactory.getPolicyDaoClientFactory();
            this.policyVersionDaoClientFactory = this.policyDaoClientFactory.getVersionDaoClientFactory();
        }
        this.enableXacmlJsonProfile = enableXacmlJsonProfile;
        this.uuidGen = FlatFileBasedDomainsDao.initUUIDGenerator(useRandomAddressBasedUUID);
        this.pdpModelHandler = pdpModelHandler;
        if (!domainsRoot.exists()) {
            throw new IllegalArgumentException("'domainsRoot' resource does not exist: " + domainsRoot.getDescription());
        }
        String ioExMsg = "Cannot resolve 'domainsRoot' resource '" + domainsRoot.getDescription() + "' as a file on the file system";
        try {
            domainsRootFile = domainsRoot.getFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(ioExMsg, e);
        }
        this.domainsRootDir = domainsRootFile.toPath();
        FlatFileDAOUtils.checkFile("File defined by SecurityDomainManager parameter 'domainsRoot'", this.domainsRootDir, true, true);
        if (!domainTmpl.exists()) {
            throw new IllegalArgumentException("'domainTmpl' resource does not exist: " + domainTmpl.getDescription());
        }
        String ioExMsg2 = "Cannot resolve 'domainTmpl' resource '" + domainTmpl.getDescription() + "' as a file on the file system";
        try {
            domainTmplFile = domainTmpl.getFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(ioExMsg2, e);
        }
        this.domainTmplDirPath = domainTmplFile.toPath();
        FlatFileDAOUtils.checkFile("File defined by SecurityDomainManager parameter 'domainTmpl'", this.domainTmplDirPath, true, false);
        LOGGER.debug("Looking for domain sub-directories in directory {}", (Object)this.domainsRootDir);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.domainsRootDir);){
            for (Path domainPath : dirStream) {
                LOGGER.debug("Checking domain in file {}", (Object)domainPath);
                if (!Files.isDirectory(domainPath, new LinkOption[0])) {
                    LOGGER.warn("Ignoring invalid domain file {} (not a directory)", (Object)domainPath);
                    continue;
                }
                Path lastPathSegment = domainPath.getFileName();
                if (lastPathSegment == null) {
                    throw new RuntimeException("Invalid Domain folder path '" + domainPath + "': no filename");
                }
                String domainId = lastPathSegment.toString();
                DomainDaoClient domain = domainDaoClientFactory.getInstance(domainId, () -> {
                    try {
                        return new FileBasedDomainDaoImpl(domainPath, null);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Invalid domain data for domain '" + domainId + "'", e);
                    }
                });
                this.domainMap.put(domainId, domain);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to scan files in the domains root directory '" + this.domainsRootDir + "' looking for domain directories", e);
        }
        this.domainDirToMemSyncIntervalSec = Integer.valueOf(domainsSyncIntervalSec).longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDomains() {
        Path path = this.domainsRootDir;
        synchronized (path) {
            for (DomainDaoClient domain : this.domainMap.values()) {
                try {
                    FlatFileBasedDomainDao domainDAO = (FlatFileBasedDomainDao)domain.getDao();
                    domainDAO.close();
                }
                catch (Throwable t) {
                    LOGGER.error("Error closing domain {}", (Object)((FlatFileBasedDomainDao)domain.getDao()).getDomainId(), (Object)t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMAIN_DAO_CLIENT getDomainDaoClient(String domainId) throws IOException {
        if (domainId == null) {
            throw NULL_DOMAIN_ID_ARG_EXCEPTION;
        }
        Path path = this.domainsRootDir;
        synchronized (path) {
            Path domainDir;
            DomainDaoClient domain = (DomainDaoClient)this.domainMap.get(domainId);
            if (domain == null && Files.exists(domainDir = this.domainsRootDir.resolve(domainId), new LinkOption[0])) {
                return this.addDomainToCacheAfterDirectoryCreated(domainId, domainDir, null);
            }
            return (DOMAIN_DAO_CLIENT)domain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addDomain(WritableDomainProperties props) throws IOException, IllegalArgumentException {
        if (this.enablePdpOnly) {
            throw DISABLED_OPERATION_EXCEPTION;
        }
        UUID uuid = this.uuidGen.generate();
        ByteBuffer byteBuf = ByteBuffer.wrap(new byte[16]);
        byteBuf.putLong(uuid.getMostSignificantBits());
        byteBuf.putLong(uuid.getLeastSignificantBits());
        String domainId = FlatFileDAOUtils.base64UrlEncode(byteBuf.array());
        Path path = this.domainsRootDir;
        synchronized (path) {
            if (this.domainMap.containsKey(domainId)) {
                throw new ConcurrentModificationException("Generated domain ID conflicts (is same as) ID of existing domain (flawed domain UUID generator or ID generated in different way?): ID=" + domainId);
            }
            String newExternalId = props.getExternalId();
            if (newExternalId != null && this.domainIDsByExternalId.containsKey(newExternalId)) {
                throw new IllegalArgumentException("externalId conflict: '" + newExternalId + "' cannot be associated with domainId '" + domainId + "' because already associated with another");
            }
            Path domainDir = this.domainsRootDir.resolve(domainId);
            if (Files.notExists(domainDir, new LinkOption[0])) {
                FlatFileDAOUtils.copyDirectory(this.domainTmplDirPath, domainDir, 3);
            }
            this.addDomainToCacheAfterDirectoryCreated(domainId, domainDir, props);
        }
        return domainId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDomainIdentifiers(String externalId) throws IOException {
        if (this.enablePdpOnly) {
            throw DISABLED_OPERATION_EXCEPTION;
        }
        Path path = this.domainsRootDir;
        synchronized (path) {
            if (externalId != null) {
                String domainId = (String)this.domainIDsByExternalId.get(externalId);
                if (domainId == null) {
                    return Collections.emptySet();
                }
                Path domainDirPath = this.domainsRootDir.resolve(domainId);
                if (Files.exists(domainDirPath, LinkOption.NOFOLLOW_LINKS)) {
                    return Collections.singleton(domainId);
                }
                this.removeDomainFromCache(domainId);
                return Collections.emptySet();
            }
            HashSet oldDomainIDs = new HashSet(this.domainMap.keySet());
            HashSet<String> newDomainIDs = new HashSet<String>();
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.domainsRootDir);){
                for (Path domainDirPath : dirStream) {
                    LOGGER.debug("Checking domain in file {}", (Object)domainDirPath);
                    if (!Files.isDirectory(domainDirPath, new LinkOption[0])) {
                        LOGGER.warn("Ignoring invalid domain file {} (not a directory)", (Object)domainDirPath);
                        continue;
                    }
                    Path lastPathSegment = domainDirPath.getFileName();
                    if (lastPathSegment == null) {
                        throw new RuntimeException("Invalid Domain folder path '" + domainDirPath + "': no filename");
                    }
                    String domainId = lastPathSegment.toString();
                    newDomainIDs.add(domainId);
                    if (oldDomainIDs.remove(domainId)) {
                        DomainDaoClient domain = (DomainDaoClient)this.domainMap.get(domainId);
                        if (domain == null) continue;
                        ((FlatFileBasedDomainDao)domain.getDao()).sync();
                        continue;
                    }
                    this.addDomainToCacheAfterDirectoryCreated(domainId, domainDirPath, null);
                }
            }
            catch (IOException e) {
                throw new IOException("Failed to scan files in the domains root directory '" + this.domainsRootDir + "' looking for domain directories", e);
            }
            if (!oldDomainIDs.isEmpty()) {
                for (String domainId : oldDomainIDs) {
                    this.removeDomainFromCache(domainId);
                }
            }
            return newDomainIDs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDomain(String domainId) throws IOException {
        if (this.enablePdpOnly) {
            throw DISABLED_OPERATION_EXCEPTION;
        }
        if (domainId == null) {
            throw NULL_DOMAIN_ID_ARG_EXCEPTION;
        }
        Path path = this.domainsRootDir;
        synchronized (path) {
            boolean isMatched = this.domainMap.containsKey(domainId);
            if (isMatched) {
                return true;
            }
            Path domainDir = this.domainsRootDir.resolve(domainId);
            if (Files.exists(domainDir, new LinkOption[0])) {
                this.addDomainToCacheAfterDirectoryCreated(domainId, domainDir, null);
                return true;
            }
        }
        return false;
    }

    static {
        try {
            DOMAIN_PROPERTIES_JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{DomainProperties.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Error creating JAXB context for (un)marshalling domain properties (XML)", e);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            DOMAIN_PROPERTIES_SCHEMA = schemaFactory.newSchema(ResourceUtils.getURL((String)DOMAIN_PROPERTIES_XSD_LOCATION));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Domain properties schema not found", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Invalid domain properties schema file", e);
        }
        INVALID_FEATURE_ID_EXCEPTION = new IllegalArgumentException("Invalid feature ID: undefined");
        XACML_JSON_PDP_REQUEST_PREPROC_ID_PATTERN = Pattern.compile("^(.*\\W|)xacml-json(\\W.*|)$", 2);
        PDP_FEATURE_IDENTIFIERS_BY_TYPE = new EnumMap<PdpFeatureType, Set<String>>(PdpFeatureType.class);
        PdpCoreFeature[] pdpCoreFeatures = PdpCoreFeature.values();
        HashSet<String> coreFeatureIDs = new HashSet<String>(pdpCoreFeatures.length);
        for (PdpCoreFeature f : pdpCoreFeatures) {
            coreFeatureIDs.add(f.id);
        }
        PDP_FEATURE_IDENTIFIERS_BY_TYPE.put(PdpFeatureType.CORE, Collections.unmodifiableSet(coreFeatureIDs));
        int featureCount = coreFeatureIDs.size();
        for (PdpFeatureType featureType : PdpFeatureType.values()) {
            if (featureType.extensionClass == null) continue;
            Set extIDs = PdpExtensions.getNonJaxbBoundExtensionIDs(featureType.extensionClass);
            PDP_FEATURE_IDENTIFIERS_BY_TYPE.put(featureType, extIDs);
            featureCount += extIDs.size();
        }
        PDP_FEATURE_COUNT = featureCount;
        DEFAULT_XACML_XML_DECISION_REQUEST_PREPROC_FACTORY = SingleDecisionXacmlJaxbRequestPreprocessor.LaxVariantFactory.INSTANCE;
        DEFAULT_XACML_JSON_DECISION_REQUEST_PREPROC_FACTORY = SingleDecisionXacmlJsonRequestPreprocessor.LaxVariantFactory.INSTANCE;
        NULL_PDP_ERROR = new UnsupportedOperationException("PDP internal error. Contact the system or domain administrator.");
    }

    private final class FileBasedDomainDaoImpl
    implements FlatFileBasedDomainDao<VERSION_DAO_CLIENT, POLICY_DAO_CLIENT> {
        private final String domainId;
        private final Path domainDirPath;
        private final File propertiesFile;
        private final File pdpConfFile;
        private final Path policyParentDirPath;
        private final DefaultEnvironmentProperties pdpConfEnvProps;
        private final FlatFileDAOUtils.SuffixMatchingDirectoryStreamFilter policyFilePathFilter;
        private final ScheduledExecutorService dirToMemSyncScheduler;
        private volatile long propertiesFileLastSyncedTime = 0L;
        private volatile String cachedExternalId = null;
        private volatile PdpBundle pdp = null;
        private final DateFormat utcDateWithMillisFormatter;
        private volatile long lastPdpSyncedTime = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DomainProperties sync() throws IOException, IllegalArgumentException {
            DomainProperties props;
            Path path = FlatFileBasedDomainsDao.this.domainsRootDir;
            synchronized (path) {
                LOGGER.debug("Domain '{}': synchronizing...", (Object)this.domainId);
                if (Files.notExists(this.domainDirPath, LinkOption.NOFOLLOW_LINKS)) {
                    LOGGER.info("Domain '{}' removed from filesystem -> removing from cache", (Object)this.domainId);
                    FlatFileBasedDomainsDao.this.removeDomainFromCache(this.domainId);
                    return null;
                }
                props = this.syncDomainProperties(false);
                boolean isChanged = this.syncPDP();
                if (isChanged) {
                    LOGGER.info("Domain '{}': synchronization: change to PDP files since last sync -> PDP reloaded", (Object)this.domainId);
                }
                LOGGER.debug("Domain '{}': synchronization done.", (Object)this.domainId);
            }
            return props;
        }

        private FileBasedDomainDaoImpl(Path domainDirPath, WritableDomainProperties props) throws IOException {
            AbstractPolicyProvider policyProvider;
            assert (domainDirPath != null);
            Path domainFileName = domainDirPath.getFileName();
            if (domainFileName == null) {
                throw new IllegalArgumentException("Invalid domain directory path: " + domainDirPath);
            }
            this.domainId = domainFileName.toString();
            FlatFileDAOUtils.checkFile("Domain directory", domainDirPath, true, true);
            this.domainDirPath = domainDirPath;
            this.pdpConfEnvProps = new DefaultEnvironmentProperties(Collections.singletonMap(EnvironmentPropertyName.PARENT_DIR, domainDirPath.toUri().toString()));
            this.pdpConfFile = domainDirPath.resolve(FlatFileBasedDomainsDao.DOMAIN_PDP_CONFIG_FILENAME).toFile();
            Pdp pdpConf = this.loadPDPConfTmpl();
            List policyProviders = pdpConf.getPolicyProviders();
            if (policyProviders.size() != 1 || !((policyProvider = (AbstractPolicyProvider)policyProviders.get(0)) instanceof StaticFlatFileDaoPolicyProviderDescriptor)) {
                throw new RuntimeException("Invalid PDP configuration of domain '" + this.domainId + "' in file '" + this.pdpConfFile + "': there is not exactly one policyProvider or it is not an instance of " + StaticFlatFileDaoPolicyProviderDescriptor.class + " as expected.");
            }
            StaticFlatFileDaoPolicyProviderDescriptor fileBasedPolicyProvider = (StaticFlatFileDaoPolicyProviderDescriptor)policyProvider;
            String policyLocation = this.pdpConfEnvProps.replacePlaceholders(fileBasedPolicyProvider.getPolicyLocationPattern());
            Map.Entry<Path, String> result = FlatFileDaoPolicyProvider.validateConf(policyLocation);
            this.policyParentDirPath = result.getKey();
            FlatFileDAOUtils.checkFile("Domain policies directory", this.policyParentDirPath, true, true);
            String policyFilenameSuffix = result.getValue();
            this.policyFilePathFilter = new FlatFileDAOUtils.SuffixMatchingDirectoryStreamFilter(policyFilenameSuffix);
            if (LOGGER.isDebugEnabled()) {
                this.utcDateWithMillisFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ('UTC')");
                this.utcDateWithMillisFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                this.utcDateWithMillisFormatter = null;
            }
            this.propertiesFile = domainDirPath.resolve(FlatFileBasedDomainsDao.DOMAIN_PROPERTIES_FILENAME).toFile();
            this.updateDomainProperties(props);
            this.reloadPDP();
            if (FlatFileBasedDomainsDao.this.domainDirToMemSyncIntervalSec > 0L) {
                DirectoryToMemorySyncTask syncTask = new DirectoryToMemorySyncTask();
                this.dirToMemSyncScheduler = Executors.newScheduledThreadPool(1);
                this.dirToMemSyncScheduler.scheduleWithFixedDelay(syncTask, FlatFileBasedDomainsDao.this.domainDirToMemSyncIntervalSec, FlatFileBasedDomainsDao.this.domainDirToMemSyncIntervalSec, TimeUnit.SECONDS);
                LOGGER.info("Domain '{}': scheduled periodic directory-to-memory synchronization (initial delay={}s, period={}s)", new Object[]{this.domainId, FlatFileBasedDomainsDao.this.domainDirToMemSyncIntervalSec, FlatFileBasedDomainsDao.this.domainDirToMemSyncIntervalSec});
            } else {
                this.dirToMemSyncScheduler = null;
            }
        }

        @Override
        public String getDomainId() {
            return this.domainId;
        }

        @Override
        public String getExternalId() {
            return this.cachedExternalId;
        }

        private void reloadPDP() throws IOException, IllegalArgumentException {
            this.lastPdpSyncedTime = System.currentTimeMillis();
            PdpEngineConfiguration pdpEngineConf = PdpEngineConfiguration.getInstance((File)this.pdpConfFile, (PdpModelHandler)FlatFileBasedDomainsDao.this.pdpModelHandler);
            PdpBundle newPdpBundle = new PdpBundle(pdpEngineConf, FlatFileBasedDomainsDao.this.enableXacmlJsonProfile);
            if (this.pdp != null && this.pdp.engine != null) {
                this.pdp.engine.close();
            }
            this.pdp = newPdpBundle;
        }

        private void reloadPDP(Pdp pdpConfTmpl) throws IllegalArgumentException, IOException {
            PdpEngineConfiguration pdpEngineConf = new PdpEngineConfiguration(pdpConfTmpl, (EnvironmentProperties)this.pdpConfEnvProps);
            PdpBundle newPdpBundle = new PdpBundle(pdpEngineConf, FlatFileBasedDomainsDao.this.enableXacmlJsonProfile);
            try {
                FlatFileBasedDomainsDao.this.pdpModelHandler.marshal(pdpConfTmpl, this.pdpConfFile);
            }
            catch (JAXBException e) {
                throw new IOException("Error writing new PDP configuration of domain '" + this.domainId + "'", e);
            }
            if (this.pdp != null && this.pdp.engine != null) {
                this.pdp.engine.close();
            }
            this.pdp = newPdpBundle;
        }

        private void setPdpInErrorState() throws IOException {
            if (this.pdp != null && this.pdp.engine != null) {
                this.pdp.engine.close();
            }
            this.pdp = null;
        }

        private void saveProperties(DomainProperties props) throws IOException {
            Marshaller marshaller;
            try {
                marshaller = DOMAIN_PROPERTIES_JAXB_CONTEXT.createMarshaller();
                marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            }
            catch (JAXBException e) {
                throw new RuntimeException("Error creating JAXB unmarshaller for domain properties (XML)", e);
            }
            marshaller.setSchema(DOMAIN_PROPERTIES_SCHEMA);
            try {
                marshaller.marshal((Object)props, this.propertiesFile);
            }
            catch (JAXBException e) {
                throw new IOException("Error persisting properties (XML) of domain '" + this.domainId + "'", e);
            }
        }

        private DomainProperties loadProperties() throws IOException {
            JAXBElement jaxbElt;
            Unmarshaller unmarshaller;
            try {
                unmarshaller = DOMAIN_PROPERTIES_JAXB_CONTEXT.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException("Error creating JAXB unmarshaller for domain properties (XML)", e);
            }
            unmarshaller.setSchema(DOMAIN_PROPERTIES_SCHEMA);
            try {
                jaxbElt = unmarshaller.unmarshal((Source)new StreamSource(this.propertiesFile), DomainProperties.class);
            }
            catch (JAXBException e) {
                throw new IOException("Error getting properties (XML) of domain '" + this.domainId + "'", e);
            }
            return (DomainProperties)jaxbElt.getValue();
        }

        private void updateCachedExternalId(String newExternalId) throws IllegalArgumentException {
            String alreadyAssociatedDomainId;
            if (this.cachedExternalId != null) {
                if (this.cachedExternalId.equals(newExternalId)) {
                    return;
                }
                FlatFileBasedDomainsDao.this.domainIDsByExternalId.remove(this.cachedExternalId);
            }
            if (newExternalId != null && (alreadyAssociatedDomainId = FlatFileBasedDomainsDao.this.domainIDsByExternalId.putIfAbsent(newExternalId, this.domainId)) != null) {
                throw new IllegalArgumentException("externalId conflict: '" + newExternalId + "' cannot be associated with domainId '" + this.domainId + "' because already associated with another");
            }
            this.cachedExternalId = newExternalId;
        }

        private void updateDomainProperties(WritableDomainProperties props) throws IOException {
            if (props != null) {
                String newExternalId = props.getExternalId();
                if (newExternalId != null && !newExternalId.equals(this.cachedExternalId) && FlatFileBasedDomainsDao.this.domainIDsByExternalId.containsKey(newExternalId)) {
                    throw new IllegalArgumentException("externalId conflict: '" + newExternalId + "' cannot be associated with domainId '" + this.domainId + "' because already associated with another");
                }
                DomainProperties updatedProps = this.loadProperties();
                updatedProps.setDescription(props.getDescription());
                updatedProps.setExternalId(props.getExternalId());
                this.saveProperties(updatedProps);
                this.syncDomainProperties(true);
            } else {
                this.syncDomainProperties(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReadableDomainProperties setDomainProperties(WritableDomainProperties props) throws IOException, IllegalArgumentException {
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (props == null) {
                throw NULL_DOMAIN_PROPERTIES_ARGUMENT_EXCEPTION;
            }
            Path path = FlatFileBasedDomainsDao.this.domainsRootDir;
            synchronized (path) {
                this.updateDomainProperties(props);
            }
            return new ReadableDomainPropertiesImpl(this.domainId, props.getDescription(), props.getExternalId());
        }

        private DomainProperties syncDomainProperties(boolean force) throws IOException {
            boolean isFileModified;
            long lastModifiedTime = this.propertiesFile.lastModified();
            boolean bl = isFileModified = lastModifiedTime > this.propertiesFileLastSyncedTime;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Domain '{}': domain properties file '{}': lastModifiedTime (= {}) {} last sync time (= {}){}", new Object[]{this.domainId, this.propertiesFile, this.utcDateWithMillisFormatter.format(new Date(lastModifiedTime)), isFileModified ? ">" : "<=", this.utcDateWithMillisFormatter.format(new Date(this.propertiesFileLastSyncedTime)), isFileModified ? " -> updating externalId in externalId-to-domain map" : ""});
            }
            this.propertiesFileLastSyncedTime = System.currentTimeMillis();
            DomainProperties props = this.loadProperties();
            if (force || isFileModified) {
                this.updateCachedExternalId(props.getExternalId());
            }
            return props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReadableDomainProperties getDomainProperties() throws IOException {
            DomainProperties props;
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            Path path = FlatFileBasedDomainsDao.this.domainsRootDir;
            synchronized (path) {
                props = this.syncDomainProperties(false);
            }
            return new ReadableDomainPropertiesImpl(this.domainId, props.getDescription(), props.getExternalId());
        }

        public boolean isPapEnabled() {
            return !FlatFileBasedDomainsDao.this.enablePdpOnly;
        }

        private Pdp loadPDPConfTmpl() throws IOException {
            try {
                return (Pdp)FlatFileBasedDomainsDao.this.pdpModelHandler.unmarshal((Source)new StreamSource(this.pdpConfFile), Pdp.class);
            }
            catch (JAXBException e) {
                throw new IOException("Error reading PDP configuration of domain '" + this.domainId + "'", e);
            }
        }

        private boolean syncPdpPolicies() throws IllegalArgumentException, IOException {
            if (this.pdp == null || this.pdp.engine == null) {
                return false;
            }
            Iterable pdpApplicablePolicies = this.pdp.engine.getApplicablePolicies();
            if (pdpApplicablePolicies == null) {
                throw NON_STATIC_POLICY_EXCEPTION;
            }
            for (PrimaryPolicyMetadata usedPolicyMetadata : pdpApplicablePolicies) {
                boolean isFileModified;
                String policyId = usedPolicyMetadata.getId();
                Path policyDir = this.getPolicyDirectory(policyId);
                if (!Files.exists(policyDir, LinkOption.NOFOLLOW_LINKS)) {
                    try {
                        this.reloadPDP();
                    }
                    catch (Throwable t) {
                        this.setPdpInErrorState();
                        throw new RuntimeException("Unrecoverable error occurred when reloading the PDP after detecting the removal of a policy ('" + policyId + "') - previously used by the PDP - from the backend domain repository. Setting the PDP in error state until following errors are fixed by the administrator and the PDP re-synced via the PAP API", t);
                    }
                    return true;
                }
                long lastModifiedTime = Files.getLastModifiedTime(policyDir, LinkOption.NOFOLLOW_LINKS).toMillis();
                boolean bl = isFileModified = lastModifiedTime > this.lastPdpSyncedTime;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Domain '{}': policy '{}': file '{}': lastModifiedTime (= {}) {} last sync time (= {}){}", new Object[]{this.domainId, policyId, policyDir, this.utcDateWithMillisFormatter.format(new Date(lastModifiedTime)), isFileModified ? ">" : "<=", this.utcDateWithMillisFormatter.format(new Date(this.lastPdpSyncedTime)), isFileModified ? " -> reloading PDP" : ""});
                }
                if (!isFileModified) continue;
                try {
                    this.reloadPDP();
                }
                catch (Throwable t) {
                    this.setPdpInErrorState();
                    throw new RuntimeException("Unrecoverable error occurred when reloading the PDP after detecting a change to the policy ('" + policyId + "') - used by the PDP - in the backend domain repository. Setting the PDP in error state until following errors are fixed by the administrator and the PDP re-synced via the PAP API", t);
                }
                return true;
            }
            return false;
        }

        private boolean syncPDP() throws IllegalArgumentException, IOException {
            boolean isFileModified;
            long lastModifiedTime = this.pdpConfFile.lastModified();
            boolean bl = isFileModified = lastModifiedTime > this.lastPdpSyncedTime;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Domain '{}': PDP conf file '{}': lastModifiedTime (= {}) {} last sync time (= {}){}", new Object[]{this.domainId, this.pdpConfFile, this.utcDateWithMillisFormatter.format(new Date(lastModifiedTime)), isFileModified ? ">" : "<=", this.utcDateWithMillisFormatter.format(new Date(this.lastPdpSyncedTime)), isFileModified ? " -> reloading PDP" : ""});
            }
            if (isFileModified) {
                this.reloadPDP();
                return true;
            }
            return this.syncPdpPolicies();
        }

        private List<TopLevelPolicyElementRef> getPdpApplicablePolicyRefs() {
            if (this.pdp == null || this.pdp.engine == null) {
                throw PDP_IN_ERROR_STATE_RUNTIME_EXCEPTION;
            }
            Iterable pdpApplicablePolicies = this.pdp.engine.getApplicablePolicies();
            if (pdpApplicablePolicies == null) {
                throw NON_STATIC_POLICY_EXCEPTION;
            }
            ArrayList<TopLevelPolicyElementRef> staticPolicyRefs = new ArrayList<TopLevelPolicyElementRef>();
            pdpApplicablePolicies.forEach(policyMeta -> staticPolicyRefs.add(new TopLevelPolicyElementRef(policyMeta.getId(), policyMeta.getVersion().toString(), Boolean.valueOf(true))));
            return staticPolicyRefs;
        }

        private List<PdpFeature> getPdpFeatures(Pdp pdpConf) {
            ArrayList<PdpFeature> features = new ArrayList<PdpFeature>(PDP_FEATURE_COUNT);
            for (PdpFeatureType featureType : PdpFeatureType.values()) {
                Set enabledFeatures;
                switch (featureType) {
                    case CORE: {
                        PdpCoreFeature[] coreFeatures = PdpCoreFeature.values();
                        enabledFeatures = HashCollections.newUpdatableSet((int)coreFeatures.length);
                        block13: for (PdpCoreFeature coreFeature : coreFeatures) {
                            switch (coreFeature) {
                                case XPATH_EVAL: {
                                    if (!pdpConf.isXPathEnabled()) continue block13;
                                    enabledFeatures.add(coreFeature.id);
                                    continue block13;
                                }
                                case STRICT_ATTRIBUTE_ISSUER_MATCH: {
                                    if (!pdpConf.isStrictAttributeIssuerMatch()) continue block13;
                                    enabledFeatures.add(coreFeature.id);
                                    continue block13;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Unsupported PDP CORE feature: " + coreFeature.id);
                                }
                            }
                        }
                        break;
                    }
                    case DATATYPE: {
                        enabledFeatures = HashCollections.newImmutableSet((Iterable)pdpConf.getAttributeDatatypes());
                        break;
                    }
                    case FUNCTION: {
                        enabledFeatures = HashCollections.newImmutableSet((Iterable)pdpConf.getFunctions());
                        break;
                    }
                    case COMBINING_ALGORITHM: {
                        enabledFeatures = HashCollections.newImmutableSet((Iterable)pdpConf.getCombiningAlgorithms());
                        break;
                    }
                    case REQUEST_PREPROC: {
                        enabledFeatures = pdpConf.getIoProcChains().stream().map(InOutProcChain::getRequestPreproc).filter(Objects::nonNull).collect(Collectors.toSet());
                        if (enabledFeatures.isEmpty()) {
                            enabledFeatures.add(DEFAULT_XACML_XML_DECISION_REQUEST_PREPROC_FACTORY.getId());
                            if (!FlatFileBasedDomainsDao.this.enableXacmlJsonProfile) break;
                            enabledFeatures.add(DEFAULT_XACML_JSON_DECISION_REQUEST_PREPROC_FACTORY.getId());
                            break;
                        }
                        if (enabledFeatures.size() >= 2 || !FlatFileBasedDomainsDao.this.enableXacmlJsonProfile) break;
                        String enabledReqPreprocId = (String)enabledFeatures.iterator().next();
                        enabledFeatures.add(XACML_JSON_PDP_REQUEST_PREPROC_ID_PATTERN.matcher(enabledReqPreprocId).matches() ? DEFAULT_XACML_XML_DECISION_REQUEST_PREPROC_FACTORY.getId() : DEFAULT_XACML_JSON_DECISION_REQUEST_PREPROC_FACTORY.getId());
                        break;
                    }
                    case RESULT_POSTPROC: {
                        enabledFeatures = pdpConf.getIoProcChains().stream().map(InOutProcChain::getResultPostproc).filter(Objects::nonNull).collect(Collectors.toSet());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported PDP feature type: " + featureType);
                    }
                }
                HashSet disabledFeatures = new HashSet(PDP_FEATURE_IDENTIFIERS_BY_TYPE.get((Object)featureType));
                for (String featureId : enabledFeatures) {
                    features.add(new PdpFeature(featureId, featureType.id, true));
                    disabledFeatures.remove(featureId);
                }
                for (String disabledFeatureID : disabledFeatures) {
                    features.add(new PdpFeature(disabledFeatureID, featureType.id, false));
                }
            }
            return features;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReadablePdpProperties setOtherPdpProperties(WritablePdpProperties properties) throws IOException, IllegalArgumentException {
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (properties == null) {
                throw NULL_PDP_PROPERTIES_ARGUMENT_EXCEPTION;
            }
            IdReferenceType newRootPolicyRefExpression = properties.getRootPolicyRefExpression();
            if (newRootPolicyRefExpression == null) {
                throw NULL_ROOT_POLICY_REF_ARGUMENT_EXCEPTION;
            }
            Path path = this.domainDirPath;
            synchronized (path) {
                long pdpConfLastSyncTime = System.currentTimeMillis();
                Pdp pdpConf = this.loadPDPConfTmpl();
                this.lastPdpSyncedTime = pdpConfLastSyncTime;
                boolean enableXPath = false;
                boolean enableStrictAttIssuerMatch = false;
                ArrayList<InOutProcChain> newIoProcChains = new ArrayList<InOutProcChain>();
                ArrayList<String> newAttDatatypes = new ArrayList<String>();
                ArrayList<String> newCombiningAlgs = new ArrayList<String>();
                ArrayList<String> newPdpFunctions = new ArrayList<String>();
                List inputFeatures = properties.getFeatures();
                HashSet<String> featureIDs = new HashSet<String>(inputFeatures.size());
                Map reqPreprocFactoriesByInputType = HashCollections.newUpdatableMap((int)inputFeatures.size());
                Map resultProcIdentifiersByInputType = HashCollections.newUpdatableMap((int)inputFeatures.size());
                block15: for (PdpFeature feature : properties.getFeatures()) {
                    PdpFeatureType nonNullFeatureType;
                    String featureID = feature.getId();
                    if (featureID == null) {
                        throw INVALID_FEATURE_ID_EXCEPTION;
                    }
                    String inputFeatureTypeId = feature.getType();
                    if (inputFeatureTypeId == null) {
                        nonNullFeatureType = PdpFeatureType.CORE;
                    } else {
                        nonNullFeatureType = PdpFeatureType.ID_TO_FEATURE_MAP.get(inputFeatureTypeId);
                        if (nonNullFeatureType == null) {
                            throw new IllegalArgumentException("Invalid feature type: '" + inputFeatureTypeId + "'. Expected: " + PdpFeatureType.ID_TO_FEATURE_MAP.keySet());
                        }
                    }
                    if (!featureIDs.add(featureID)) {
                        throw new IllegalArgumentException("Duplicate feature: " + featureID);
                    }
                    if (!feature.isEnabled()) continue;
                    switch (nonNullFeatureType) {
                        case CORE: {
                            PdpCoreFeature coreFeature = PdpCoreFeature.fromId(featureID);
                            if (coreFeature == null) {
                                throw new IllegalArgumentException("Invalid " + nonNullFeatureType + " feature: '" + featureID + "'. Expected: " + PDP_FEATURE_IDENTIFIERS_BY_TYPE.get((Object)nonNullFeatureType));
                            }
                            switch (coreFeature) {
                                case XPATH_EVAL: {
                                    enableXPath = true;
                                    continue block15;
                                }
                                case STRICT_ATTRIBUTE_ISSUER_MATCH: {
                                    enableStrictAttIssuerMatch = true;
                                    continue block15;
                                }
                            }
                            throw new UnsupportedOperationException("Unsupported " + nonNullFeatureType + " feature: '" + featureID + "'. Expected: " + PDP_FEATURE_IDENTIFIERS_BY_TYPE.get((Object)nonNullFeatureType));
                        }
                        case DATATYPE: {
                            newAttDatatypes.add(featureID);
                            continue block15;
                        }
                        case FUNCTION: {
                            newPdpFunctions.add(featureID);
                            continue block15;
                        }
                        case COMBINING_ALGORITHM: {
                            newCombiningAlgs.add(featureID);
                            continue block15;
                        }
                        case REQUEST_PREPROC: {
                            DecisionRequestPreprocessor.Factory reqPreprocFactory = (DecisionRequestPreprocessor.Factory)PdpExtensions.getExtension(DecisionRequestPreprocessor.Factory.class, (String)featureID);
                            Class reqPreprocInType = reqPreprocFactory.getInputRequestType();
                            DecisionRequestPreprocessor.Factory conflictingReqPreprocFactory = reqPreprocFactoriesByInputType.put(reqPreprocInType, reqPreprocFactory);
                            if (conflictingReqPreprocFactory != null && !conflictingReqPreprocFactory.getId().equals(featureID)) {
                                throw new IllegalArgumentException("Feature conflict on '" + conflictingReqPreprocFactory.getId() + "' and '" + featureID + "'. These request preprocessors (feature type '" + PdpFeatureType.REQUEST_PREPROC.id + "') have same input type (" + reqPreprocInType + "). Only one of them may be enabled at a time.");
                            }
                            resultProcIdentifiersByInputType.put(reqPreprocFactory.getOutputRequestType(), null);
                            continue block15;
                        }
                        case RESULT_POSTPROC: {
                            DecisionResultPostprocessor.Factory resultPostprocFactory = (DecisionResultPostprocessor.Factory)PdpExtensions.getExtension(DecisionResultPostprocessor.Factory.class, (String)featureID);
                            Class resultPostprocInType = resultPostprocFactory.getRequestType();
                            if (!resultProcIdentifiersByInputType.containsKey(resultPostprocInType)) {
                                throw new IllegalArgumentException("Cannot enable feature '" + featureID + "' (type " + PdpFeatureType.RESULT_POSTPROC.id + ") because no compatible request preprocessor (feature type " + PdpFeatureType.REQUEST_PREPROC.id + ") previously defined. Make sure you enable such a request-preproc feature (output must be " + resultPostprocInType + ") before this one.");
                            }
                            String conflictingResultPostprocId = resultProcIdentifiersByInputType.put(resultPostprocInType, resultPostprocFactory.getId());
                            if (conflictingResultPostprocId == null || conflictingResultPostprocId.equals(featureID)) continue block15;
                            throw new IllegalArgumentException("Feature conflict on '" + conflictingResultPostprocId + "' and '" + featureID + "'. These result postprocessors (feature type '" + PdpFeatureType.RESULT_POSTPROC.id + "') have same input type (" + resultPostprocInType + "). Only one of them may be enabled at a time.");
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported PDP feature type: '" + nonNullFeatureType.id + "'. Expected: " + PdpFeatureType.ID_TO_FEATURE_MAP.keySet());
                }
                for (DecisionRequestPreprocessor.Factory reqPreprocFactory : reqPreprocFactoriesByInputType.values()) {
                    String reqPreprocId = reqPreprocFactory.getId();
                    String resultPreprocId = (String)resultProcIdentifiersByInputType.get(reqPreprocFactory.getOutputRequestType());
                    newIoProcChains.add(new InOutProcChain(reqPreprocId, resultPreprocId));
                }
                TopLevelPolicyElementRef rootPolicyRef = new TopLevelPolicyElementRef(newRootPolicyRefExpression.getValue(), newRootPolicyRefExpression.getVersion(), Boolean.valueOf(true));
                Pdp newPdpConf = new Pdp(newAttDatatypes, newPdpFunctions, newCombiningAlgs, pdpConf.getAttributeProviders(), pdpConf.getPolicyProviders(), rootPolicyRef, pdpConf.getDecisionCache(), newIoProcChains, pdpConf.getVersion(), Boolean.valueOf(pdpConf.isStandardDatatypesEnabled()), Boolean.valueOf(pdpConf.isStandardFunctionsEnabled()), Boolean.valueOf(pdpConf.isStandardCombiningAlgorithmsEnabled()), Boolean.valueOf(pdpConf.isStandardAttributeProvidersEnabled()), Boolean.valueOf(enableXPath), Boolean.valueOf(enableStrictAttIssuerMatch), pdpConf.getMaxIntegerValue(), pdpConf.getMaxVariableRefDepth(), pdpConf.getMaxPolicyRefDepth(), pdpConf.getClientRequestErrorVerbosityLevel());
                this.reloadPDP(newPdpConf);
                List<PdpFeature> pdpFeatures = this.getPdpFeatures(newPdpConf);
                List<TopLevelPolicyElementRef> activePolicyRefs = this.getPdpApplicablePolicyRefs();
                return new ReadablePdpPropertiesImpl(pdpFeatures, rootPolicyRef, activePolicyRefs.get(0), activePolicyRefs.subList(1, activePolicyRefs.size()), this.lastPdpSyncedTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReadablePdpProperties getOtherPdpProperties() throws IOException {
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            Path path = this.domainDirPath;
            synchronized (path) {
                boolean isFileModified;
                long lastModifiedTime = this.pdpConfFile.lastModified();
                boolean bl = isFileModified = lastModifiedTime > this.lastPdpSyncedTime;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Domain '{}': PDP conf file '{}': lastModifiedTime (= {}) {} last sync time (= {}){}", new Object[]{this.domainId, this.pdpConfFile, this.utcDateWithMillisFormatter.format(new Date(lastModifiedTime)), isFileModified ? ">" : "<=", this.utcDateWithMillisFormatter.format(new Date(this.lastPdpSyncedTime)), isFileModified ? " -> reload PDP" : ""});
                }
                long pdpConfLastSyncedTime = System.currentTimeMillis();
                Pdp pdpConf = this.loadPDPConfTmpl();
                if (isFileModified) {
                    this.lastPdpSyncedTime = pdpConfLastSyncedTime;
                    this.reloadPDP(pdpConf);
                } else {
                    boolean isPdpReloaded = this.syncPdpPolicies();
                    if (!isPdpReloaded) {
                        this.lastPdpSyncedTime = pdpConfLastSyncedTime;
                    }
                }
                List<PdpFeature> features = this.getPdpFeatures(pdpConf);
                List<TopLevelPolicyElementRef> activePolicyRefs = this.getPdpApplicablePolicyRefs();
                return new ReadablePdpPropertiesImpl(features, pdpConf.getRootPolicyRef(), activePolicyRefs.get(0), activePolicyRefs.subList(1, activePolicyRefs.size()), this.lastPdpSyncedTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<AbstractAttributeProvider> setAttributeProviders(List<AbstractAttributeProvider> attributeproviders) throws IOException, IllegalArgumentException {
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (attributeproviders == null) {
                throw NULL_ATTRIBUTE_PROVIDERS_ARGUMENT_EXCEPTION;
            }
            Path path = this.domainDirPath;
            synchronized (path) {
                this.lastPdpSyncedTime = System.currentTimeMillis();
                Pdp pdpConf = this.loadPDPConfTmpl();
                Pdp newPdpConf = new Pdp(pdpConf.getAttributeDatatypes(), pdpConf.getFunctions(), pdpConf.getCombiningAlgorithms(), attributeproviders, pdpConf.getPolicyProviders(), pdpConf.getRootPolicyRef(), pdpConf.getDecisionCache(), pdpConf.getIoProcChains(), pdpConf.getVersion(), Boolean.valueOf(pdpConf.isStandardDatatypesEnabled()), Boolean.valueOf(pdpConf.isStandardFunctionsEnabled()), Boolean.valueOf(pdpConf.isStandardCombiningAlgorithmsEnabled()), Boolean.valueOf(pdpConf.isStandardAttributeProvidersEnabled()), Boolean.valueOf(pdpConf.isXPathEnabled()), Boolean.valueOf(pdpConf.isStrictAttributeIssuerMatch()), pdpConf.getMaxIntegerValue(), pdpConf.getMaxVariableRefDepth(), pdpConf.getMaxPolicyRefDepth(), pdpConf.getClientRequestErrorVerbosityLevel());
                this.reloadPDP(newPdpConf);
            }
            return attributeproviders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<AbstractAttributeProvider> getAttributeProviders() throws IOException {
            Pdp pdpConf;
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            Path path = this.domainDirPath;
            synchronized (path) {
                boolean isFileModified;
                long lastModifiedTime = this.pdpConfFile.lastModified();
                boolean bl = isFileModified = lastModifiedTime > this.lastPdpSyncedTime;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Domain '{}': PDP conf file '{}': lastModifiedTime (= {}) {} last sync time (= {}){}", new Object[]{this.domainId, this.pdpConfFile, this.utcDateWithMillisFormatter.format(new Date(lastModifiedTime)), isFileModified ? ">" : "<=", this.utcDateWithMillisFormatter.format(new Date(this.lastPdpSyncedTime)), isFileModified ? " -> reloading PDP" : ""});
                }
                long pdpConfLastLoadTime = System.currentTimeMillis();
                pdpConf = this.loadPDPConfTmpl();
                if (isFileModified) {
                    this.lastPdpSyncedTime = pdpConfLastLoadTime;
                    this.reloadPDP(pdpConf);
                }
            }
            return pdpConf.getAttributeProviders();
        }

        private Path getPolicyDirectory(String policyId) {
            assert (policyId != null);
            String policyDirName = FlatFileDAOUtils.base64UrlEncode(policyId);
            return this.policyParentDirPath.resolve(policyDirName);
        }

        private void savePolicy(PolicySet policy, Path path, Map<String, String> xpathNamespaceContexts) throws IOException {
            assert (policy != null);
            assert (path != null);
            Path policyDir = path.getParent();
            if (policyDir == null) {
                throw new RuntimeException("savePolicy(..., path) called with path having no parent! Root path?");
            }
            try {
                Files.createDirectories(policyDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IOException("Error creating parent directory for new policy ('" + policy.getPolicySetId() + "' v" + policy.getVersion() + ") in domain '" + this.domainId + "'", e);
            }
            XMLStreamWriter xmlStreamWriter = null;
            try (FileWriter fileWriter = new FileWriter(path.toFile(), StandardCharsets.UTF_8);){
                xmlStreamWriter = StaxUtils.createXMLStreamWriter((Writer)fileWriter);
                Marshaller marshaller = Xacml3JaxbHelper.createXacml3Marshaller();
                marshaller.marshal((Object)policy, (XMLStreamWriter)(xpathNamespaceContexts.isEmpty() ? xmlStreamWriter : new XmlnsAppendingDelegatingXMLStreamWriter(xmlStreamWriter, (ImmutableMap<String, String>)ImmutableMap.copyOf(xpathNamespaceContexts))));
                xmlStreamWriter.close();
            }
            catch (JAXBException | XMLStreamException e) {
                try {
                    throw new IOException("Error saving policy in domain '" + this.domainId + "'", e);
                }
                catch (Throwable throwable) {
                    StaxUtils.close(xmlStreamWriter);
                    throw throwable;
                }
            }
            StaxUtils.close((XMLStreamWriter)xmlStreamWriter);
        }

        private Path getPolicyVersionPath(Path policyDirPath, PolicyVersion version) {
            return policyDirPath.resolve(version + this.policyFilePathFilter.getMatchedSuffix());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AuthzPolicy addPolicy(AuthzPolicy policy) throws IOException, IllegalArgumentException, TooManyPoliciesException {
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (policy == null) {
                throw NULL_POLICY_ARGUMENT_EXCEPTION;
            }
            if (this.pdp == null || this.pdp.engine == null) {
                throw PDP_IN_ERROR_STATE_RUNTIME_EXCEPTION;
            }
            PolicySet policySet = policy.toXacml();
            String policyId = policySet.getPolicySetId();
            Path policyDirPath = this.getPolicyDirectory(policyId);
            PolicyVersion newPolicyVersion = new PolicyVersion(policySet.getVersion());
            Path policyVersionFile = this.getPolicyVersionPath(policyDirPath, newPolicyVersion);
            Path path = this.domainDirPath;
            synchronized (path) {
                int excessOfPolicyVersionsToBeRemoved;
                BigInteger maxPolicyCount;
                if (Files.exists(policyVersionFile, LinkOption.NOFOLLOW_LINKS)) {
                    this.syncPDP();
                    try {
                        return FlatFileDAOUtils.loadPolicy(policyVersionFile);
                    }
                    catch (JAXBException e) {
                        throw new IOException("Error getting a policy of domain '" + this.domainId + "'", e);
                    }
                }
                DomainProperties domainProps = this.loadProperties();
                if (!Files.exists(policyDirPath, new LinkOption[0]) && (maxPolicyCount = domainProps.getMaxPolicyCount()) != null) {
                    int existingPolicyCount = 0;
                    try (DirectoryStream<Path> policyParentDirStream = Files.newDirectoryStream(this.policyParentDirPath, FlatFileDAOUtils.SUB_DIRECTORY_STREAM_FILTER);){
                        Iterator<Path> fileIt = policyParentDirStream.iterator();
                        while (fileIt.hasNext()) {
                            ++existingPolicyCount;
                            fileIt.next();
                        }
                    }
                    catch (IOException e) {
                        throw new IOException("Error listing files in policies directory '" + this.policyParentDirPath + "' of domain '" + this.domainId + "'", e);
                    }
                    if (existingPolicyCount >= maxPolicyCount.intValue()) {
                        throw new TooManyPoliciesException("Max number of policies (" + maxPolicyCount + ") reached for the domain");
                    }
                }
                BigInteger maxVersionCountPerPolicy = domainProps.getMaxVersionCountPerPolicy();
                TooManyPoliciesException maxNumOfVersionsReachedException = new TooManyPoliciesException("Max number of versions (" + maxVersionCountPerPolicy + ") reached for the policy and none can be removed");
                PolicyVersions<Path> policyVersions = this.getPolicyVersions(policyDirPath);
                if (maxVersionCountPerPolicy != null) {
                    excessOfPolicyVersionsToBeRemoved = policyVersions.size() + 1 - maxVersionCountPerPolicy.intValue();
                    if (excessOfPolicyVersionsToBeRemoved > 0 && !domainProps.isVersionRollingEnabled()) {
                        throw maxNumOfVersionsReachedException;
                    }
                } else {
                    excessOfPolicyVersionsToBeRemoved = 0;
                }
                this.syncPDP();
                Pdp pdpConfTmpl = this.loadPDPConfTmpl();
                ArrayList<StaticPolicyProvider> newPolicyProviders = new ArrayList<StaticPolicyProvider>(pdpConfTmpl.getPolicyProviders());
                newPolicyProviders.add(new StaticPolicyProvider(Collections.singletonList(policySet), Boolean.valueOf(true)));
                TopLevelPolicyElementRef newRootPolicyRef = new TopLevelPolicyElementRef(policyId, policySet.getVersion(), Boolean.valueOf(true));
                Pdp newPdpConf = new Pdp(pdpConfTmpl.getAttributeDatatypes(), pdpConfTmpl.getFunctions(), pdpConfTmpl.getCombiningAlgorithms(), pdpConfTmpl.getAttributeProviders(), newPolicyProviders, newRootPolicyRef, pdpConfTmpl.getDecisionCache(), pdpConfTmpl.getIoProcChains(), pdpConfTmpl.getVersion(), Boolean.valueOf(pdpConfTmpl.isStandardDatatypesEnabled()), Boolean.valueOf(pdpConfTmpl.isStandardFunctionsEnabled()), Boolean.valueOf(pdpConfTmpl.isStandardCombiningAlgorithmsEnabled()), Boolean.valueOf(pdpConfTmpl.isStandardAttributeProvidersEnabled()), Boolean.valueOf(pdpConfTmpl.isXPathEnabled()), Boolean.valueOf(pdpConfTmpl.isStrictAttributeIssuerMatch()), pdpConfTmpl.getMaxIntegerValue(), pdpConfTmpl.getMaxVariableRefDepth(), pdpConfTmpl.getMaxPolicyRefDepth(), pdpConfTmpl.getClientRequestErrorVerbosityLevel());
                Map xpathNamespaceContexts = policy.getXPathNamespaceContexts();
                PdpEngineConfiguration pdpEngineConf = new PdpEngineConfiguration(newPdpConf, (EnvironmentProperties)this.pdpConfEnvProps, xpathNamespaceContexts);
                try (BasePdpEngine tempPdp = new BasePdpEngine(pdpEngineConf);){
                    LOGGER.debug("New policy '{}' v{} validated (successfully loaded a temporary PDP with this policy as root: {})", new Object[]{policyId, newPolicyVersion, tempPdp});
                }
                this.savePolicy(policySet, policyVersionFile, xpathNamespaceContexts);
                Optional<PrimaryPolicyMetadata> matchingRequiredPolicySetMetadata = StreamSupport.stream(this.pdp.engine.getApplicablePolicies().spliterator(), false).filter(policyMeta -> policyMeta.getType() == TopLevelPolicyElementType.POLICY_SET && policyMeta.getId().equals(policyId)).findFirst();
                PolicyVersion currentlyUsedPolicyVersion = matchingRequiredPolicySetMetadata.map(PrimaryPolicyMetadata::getVersion).orElse(null);
                if (currentlyUsedPolicyVersion != null && currentlyUsedPolicyVersion.compareTo(newPolicyVersion) < 0) {
                    try {
                        this.reloadPDP();
                    }
                    catch (Throwable e) {
                        this.removePolicyVersionFile(policyVersionFile, e);
                        throw e;
                    }
                }
                if (excessOfPolicyVersionsToBeRemoved > 0) {
                    UnmodifiableIterator oldestToLatestVersionIterator = policyVersions.oldestToLatestIterator();
                    int numRemoved = 0;
                    while (oldestToLatestVersionIterator.hasNext() && numRemoved < excessOfPolicyVersionsToBeRemoved) {
                        Map.Entry versionWithPath = (Map.Entry)oldestToLatestVersionIterator.next();
                        PolicyVersion version = (PolicyVersion)versionWithPath.getKey();
                        if (version.equals((Object)currentlyUsedPolicyVersion)) continue;
                        this.removePolicyVersionFile((Path)versionWithPath.getValue(), null);
                        if (version.equals((Object)newPolicyVersion)) {
                            throw maxNumOfVersionsReachedException;
                        }
                        ++numRemoved;
                    }
                    if (numRemoved < excessOfPolicyVersionsToBeRemoved) {
                        throw maxNumOfVersionsReachedException;
                    }
                }
            }
            return null;
        }

        private Path getPolicyVersionPath(String policyId, PolicyVersion versionId) {
            return this.getPolicyDirectory(policyId).resolve(versionId + this.policyFilePathFilter.getMatchedSuffix());
        }

        public AuthzPolicy getPolicyVersion(String policyId, PolicyVersion version) throws IOException {
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (policyId == null || version == null) {
                return null;
            }
            Path path = this.domainDirPath;
            synchronized (path) {
                this.syncPDP();
                Path policyVersionFile = this.getPolicyVersionPath(policyId, version);
                if (!Files.exists(policyVersionFile, LinkOption.NOFOLLOW_LINKS)) {
                    return null;
                }
                try {
                    return FlatFileDAOUtils.loadPolicy(policyVersionFile);
                }
                catch (IllegalArgumentException | JAXBException e) {
                    throw new IOException("Error getting policy version from file '" + policyVersionFile + "'", e);
                }
            }
        }

        private void removePolicyVersionFile(Path policyVersionFilepath, Throwable causeForRemoving) throws IOException {
            try {
                Files.deleteIfExists(policyVersionFilepath);
                Path policyDirPath = policyVersionFilepath.getParent();
                if (policyDirPath == null || !Files.exists(policyDirPath, LinkOption.NOFOLLOW_LINKS)) {
                    return;
                }
                try (DirectoryStream<Path> policyDirStream = Files.newDirectoryStream(policyDirPath, this.policyFilePathFilter);){
                    if (!policyDirStream.iterator().hasNext()) {
                        FlatFileDAOUtils.deleteDirectory(policyDirPath, 1);
                    }
                }
                catch (IOException e) {
                    throw new IOException("Error checking if policy directory '" + policyDirPath + "' is empty or removing it after removing last version" + (String)(causeForRemoving == null ? "" : " causing PDP instantiation failure: " + causeForRemoving) + ". Please delete the directory manually and reload the domain.", e);
                }
            }
            catch (IOException e) {
                throw new IOException("Failed to delete policy file: '" + policyVersionFilepath + "'" + (String)(causeForRemoving == null ? "" : " causing PDP instantiation failure: " + e.getMessage()), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AuthzPolicy removePolicyVersion(String policyId, PolicyVersion tobeRemovedPolicyVersion) throws IOException, IllegalArgumentException {
            AuthzPolicy policy;
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (policyId == null || tobeRemovedPolicyVersion == null) {
                return null;
            }
            if (this.pdp == null || this.pdp.engine == null) {
                throw PDP_IN_ERROR_STATE_RUNTIME_EXCEPTION;
            }
            Path policyVersionFile = this.getPolicyVersionPath(policyId, tobeRemovedPolicyVersion);
            Path path = this.domainDirPath;
            synchronized (path) {
                this.syncPDP();
                Optional<PrimaryPolicyMetadata> matchingRequiredPolicySetMetadata = StreamSupport.stream(this.pdp.engine.getApplicablePolicies().spliterator(), false).filter(policyMeta -> policyMeta.getType() == TopLevelPolicyElementType.POLICY_SET && policyMeta.getId().equals(policyId)).findFirst();
                PolicyVersion currentlyUsedVersion = matchingRequiredPolicySetMetadata.map(PrimaryPolicyMetadata::getVersion).orElse(null);
                if (tobeRemovedPolicyVersion.equals((Object)currentlyUsedVersion)) {
                    throw new IllegalArgumentException("Policy '" + policyId + "' / Version " + tobeRemovedPolicyVersion + " cannot be removed because it is still used by the PDP, either as root policy or referenced directly/indirectly by the root policy.");
                }
                if (!Files.exists(policyVersionFile, LinkOption.NOFOLLOW_LINKS)) {
                    return null;
                }
                try {
                    policy = FlatFileDAOUtils.loadPolicy(policyVersionFile);
                }
                catch (JAXBException e) {
                    throw new IOException("Error getting policy version from file '" + policyVersionFile + "'", e);
                }
                this.removePolicyVersionFile(policyVersionFile, null);
            }
            return policy;
        }

        public VERSION_DAO_CLIENT getVersionDaoClient(String policyId, PolicyVersion version) {
            if (FlatFileBasedDomainsDao.this.policyVersionDaoClientFactory == null) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (policyId == null || version == null) {
                return null;
            }
            return FlatFileBasedDomainsDao.this.policyVersionDaoClientFactory.getInstance(policyId, version, (DomainDao)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PolicyVersion getLatestPolicyVersionId(String policyId) throws IOException {
            Map.Entry<PolicyVersion, Path> latestVersionAndFilepath;
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (policyId == null) {
                return null;
            }
            Path path = this.domainDirPath;
            synchronized (path) {
                Path policyDirPath = this.getPolicyDirectory(policyId);
                if (!Files.exists(policyDirPath, new LinkOption[0]) || !Files.isDirectory(policyDirPath, new LinkOption[0])) {
                    return null;
                }
                try {
                    latestVersionAndFilepath = FlatFileDAOUtils.getLatestPolicyVersion(policyDirPath, this.policyFilePathFilter);
                }
                catch (IOException e) {
                    throw new IOException("Error listing policy version files in policy directory '" + policyDirPath + "' of domain '" + this.domainId + "'", e);
                }
                this.syncPDP();
            }
            return latestVersionAndFilepath.getKey();
        }

        private PolicyVersions<Path> getPolicyVersions(Path policyDirPath) throws IOException {
            assert (policyDirPath != null);
            if (!Files.exists(policyDirPath, new LinkOption[0]) || !Files.isDirectory(policyDirPath, new LinkOption[0])) {
                return EMPTY_POLICY_VERSIONS;
            }
            try {
                return FlatFileDAOUtils.getPolicyVersions(policyDirPath, this.policyFilePathFilter);
            }
            catch (IOException e) {
                throw new IOException("Error listing policy version files in policy directory '" + policyDirPath + "' of domain '" + this.domainId + "'", e);
            }
        }

        private int getPolicyVersionCount(Path policyDirPath) throws IOException {
            assert (policyDirPath != null);
            if (!Files.exists(policyDirPath, new LinkOption[0]) || !Files.isDirectory(policyDirPath, new LinkOption[0])) {
                return 0;
            }
            int count = 0;
            try (DirectoryStream<Path> policyDirStream = Files.newDirectoryStream(policyDirPath, this.policyFilePathFilter);){
                Iterator<Path> fileIt = policyDirStream.iterator();
                while (fileIt.hasNext()) {
                    ++count;
                    fileIt.next();
                }
            }
            catch (IOException e) {
                throw new IOException("Error listing policy version files in policy directory '" + policyDirPath + "' of domain '" + this.domainId + "'", e);
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableSet<PolicyVersion> getPolicyVersions(String policyId) throws IOException {
            NavigableSet versions;
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (policyId == null) {
                return ImmutableSortedSet.of();
            }
            Path path = this.domainDirPath;
            synchronized (path) {
                Path policyDir = this.getPolicyDirectory(policyId);
                versions = this.getPolicyVersions(policyDir).latestToOldestSet();
                this.syncPDP();
            }
            return versions;
        }

        public POLICY_DAO_CLIENT getPolicyDaoClient(String policyId) {
            if (FlatFileBasedDomainsDao.this.policyDaoClientFactory == null) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (policyId == null) {
                return null;
            }
            return FlatFileBasedDomainsDao.this.policyDaoClientFactory.getInstance(policyId, (DomainDao)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableSet<PolicyVersion> removePolicy(String policyId) throws IOException, IllegalArgumentException {
            NavigableSet versions;
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (policyId == null) {
                return ImmutableSortedSet.of();
            }
            if (this.pdp == null || this.pdp.engine == null) {
                throw PDP_IN_ERROR_STATE_RUNTIME_EXCEPTION;
            }
            Path path = this.domainDirPath;
            synchronized (path) {
                this.syncPDP();
                Optional<PrimaryPolicyMetadata> matchingRequiredPolicySetMetadata = StreamSupport.stream(this.pdp.engine.getApplicablePolicies().spliterator(), false).filter(policyMeta -> policyMeta.getType() == TopLevelPolicyElementType.POLICY_SET && policyMeta.getId().equals(policyId)).findFirst();
                PolicyVersion currentlyUsedVersion = matchingRequiredPolicySetMetadata.map(PrimaryPolicyMetadata::getVersion).orElse(null);
                if (currentlyUsedVersion != null) {
                    throw new IllegalArgumentException("Policy '" + policyId + "' cannot be removed because this policy (version " + currentlyUsedVersion + ") is still used by the PDP, either as root policy or referenced directly/indirectly by the root policy.");
                }
                Path policyDir = this.getPolicyDirectory(policyId);
                versions = this.getPolicyVersions(policyDir).latestToOldestSet();
                try {
                    FlatFileDAOUtils.deleteDirectory(policyDir, 1);
                }
                catch (IOException e) {
                    throw new IOException("Error removing policy directory: " + policyDir, e);
                }
            }
            return versions;
        }

        private int getPolicyCount() throws IOException {
            int count = 0;
            try (DirectoryStream<Path> policyParentDirStream = Files.newDirectoryStream(this.policyParentDirPath, FlatFileDAOUtils.SUB_DIRECTORY_STREAM_FILTER);){
                Iterator<Path> fileIt = policyParentDirStream.iterator();
                while (fileIt.hasNext()) {
                    ++count;
                    fileIt.next();
                }
            }
            catch (IOException e) {
                throw new IOException("Error listing files in policies directory '" + this.policyParentDirPath + "' of domain '" + this.domainId + "'", e);
            }
            return count;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Map.Entry<String, Integer> checkPolicyVersionCount(int maxAllowedVersionCount) throws IOException {
            if (maxAllowedVersionCount < 1) {
                return null;
            }
            try (DirectoryStream<Path> policyParentDirStream = Files.newDirectoryStream(this.policyParentDirPath, FlatFileDAOUtils.SUB_DIRECTORY_STREAM_FILTER);){
                String policyId;
                Path policyDirPath;
                int versionCount;
                Iterator<Path> iterator = policyParentDirStream.iterator();
                do {
                    if (!iterator.hasNext()) return null;
                } while ((versionCount = this.getPolicyVersionCount(policyDirPath = iterator.next())) <= maxAllowedVersionCount);
                Path policyDirName = policyDirPath.getFileName();
                if (policyDirName == null) {
                    throw new IOException("Invalid policy (versions) directory path: " + policyDirPath);
                }
                String encodedPolicyId = policyDirName.toString();
                try {
                    policyId = FlatFileDAOUtils.base64UrlDecode(encodedPolicyId);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Invalid policy directory name (bad encoding): " + policyDirName, e);
                }
                AbstractMap.SimpleImmutableEntry<String, Integer> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<String, Integer>(policyId, versionCount);
                return simpleImmutableEntry;
            }
            catch (IOException e) {
                throw new IOException("Error listing files in policies directory '" + this.policyParentDirPath + "' of domain '" + this.domainId + "'", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> getPolicyIdentifiers() throws IOException {
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            TreeSet<String> policyIds = new TreeSet<String>();
            Path path = this.domainDirPath;
            synchronized (path) {
                try (DirectoryStream<Path> policyParentDirStream = Files.newDirectoryStream(this.policyParentDirPath, FlatFileDAOUtils.SUB_DIRECTORY_STREAM_FILTER);){
                    for (Path policyDirPath : policyParentDirStream) {
                        String policyId;
                        Path policyDirName = policyDirPath.getFileName();
                        if (policyDirName == null) {
                            throw new IOException("Invalid policy (versions) directory path: " + policyDirPath);
                        }
                        String encodedPolicyId = policyDirName.toString();
                        try {
                            policyId = FlatFileDAOUtils.base64UrlDecode(encodedPolicyId);
                        }
                        catch (IllegalArgumentException e) {
                            throw new RuntimeException("Invalid policy directory name (bad encoding): " + policyDirName, e);
                        }
                        policyIds.add(policyId);
                    }
                }
                catch (IOException e) {
                    throw new IOException("Error listing files in policies directory '" + this.policyParentDirPath + "' of domain '" + this.domainId + "'", e);
                }
                this.syncPDP();
            }
            return policyIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReadableDomainProperties removeDomain() throws IOException {
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            Path path = this.domainDirPath;
            synchronized (path) {
                if (Files.exists(this.domainDirPath, LinkOption.NOFOLLOW_LINKS)) {
                    FlatFileDAOUtils.deleteDirectory(this.domainDirPath, 3);
                }
                Path path2 = FlatFileBasedDomainsDao.this.domainsRootDir;
                synchronized (path2) {
                    FlatFileBasedDomainsDao.this.removeDomainFromCache(this.domainId);
                }
            }
            return new ReadableDomainPropertiesImpl(this.domainId, null, this.cachedExternalId);
        }

        public void close() throws IOException {
            if (this.dirToMemSyncScheduler != null) {
                this.dirToMemSyncScheduler.shutdown();
                try {
                    if (!this.dirToMemSyncScheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                        LOGGER.error("Domain '{}': scheduler wait timeout ({}s) occurred before task could terminate after shutdown request.", (Object)this.domainId, (Object)FlatFileBasedDomainsDao.this.domainDirToMemSyncIntervalSec);
                        this.dirToMemSyncScheduler.shutdownNow();
                        if (!this.dirToMemSyncScheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                            LOGGER.error("Domain '{}': scheduler wait timeout ({}s) occurred before task could terminate after shudownNow request.", (Object)this.domainId, (Object)FlatFileBasedDomainsDao.this.domainDirToMemSyncIntervalSec);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    LOGGER.error("Domain '{}': scheduler interrupted while waiting for sync task to complete", (Object)this.domainId, (Object)ie);
                    this.dirToMemSyncScheduler.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
            if (this.pdp != null && this.pdp.engine != null) {
                this.pdp.engine.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrpRwProperties getOtherPrpProperties() throws IOException {
            DomainProperties props;
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            Path path = FlatFileBasedDomainsDao.this.domainsRootDir;
            synchronized (path) {
                props = this.syncDomainProperties(false);
            }
            BigInteger maxPolicyCount = props.getMaxPolicyCount();
            BigInteger maxVersionCount = props.getMaxVersionCountPerPolicy();
            int mpc = maxPolicyCount == null ? -1 : maxPolicyCount.intValue();
            int mvc = maxVersionCount == null ? -1 : maxVersionCount.intValue();
            return new PrpRwPropertiesImpl(mpc, mvc, props.isVersionRollingEnabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrpRwProperties setOtherPrpProperties(PrpRwProperties props) throws IOException, IllegalArgumentException {
            if (FlatFileBasedDomainsDao.this.enablePdpOnly) {
                throw DISABLED_OPERATION_EXCEPTION;
            }
            if (props == null) {
                throw NULL_PRP_PROPERTIES_ARGUMENT_EXCEPTION;
            }
            Path path = FlatFileBasedDomainsDao.this.domainsRootDir;
            synchronized (path) {
                DomainProperties updatedProps = this.loadProperties();
                int maxPolicyCount = props.getMaxPolicyCountPerDomain();
                int policyCount = this.getPolicyCount();
                if (maxPolicyCount > 0 && maxPolicyCount < policyCount) {
                    throw new IllegalArgumentException("Invalid maxPolicyCount (" + maxPolicyCount + "): < current policy count (" + policyCount + ")!");
                }
                updatedProps.setMaxPolicyCount(maxPolicyCount > 0 ? BigInteger.valueOf(maxPolicyCount) : null);
                int maxAllowedVersionCountPerPolicy = props.getMaxVersionCountPerPolicy();
                Map.Entry<String, Integer> invalidPolicyVersion = this.checkPolicyVersionCount(maxAllowedVersionCountPerPolicy);
                if (invalidPolicyVersion != null) {
                    throw new IllegalArgumentException("Invalid maxVersionCount (" + maxAllowedVersionCountPerPolicy + "): < number of versions (" + invalidPolicyVersion.getValue() + ") of policy " + invalidPolicyVersion.getKey() + "!");
                }
                updatedProps.setMaxVersionCountPerPolicy(maxAllowedVersionCountPerPolicy > 0 ? BigInteger.valueOf(maxAllowedVersionCountPerPolicy) : null);
                updatedProps.setVersionRollingEnabled(props.isVersionRollingEnabled());
                this.saveProperties(updatedProps);
                this.syncDomainProperties(true);
            }
            return new PrpRwPropertiesImpl(props.getMaxPolicyCountPerDomain(), props.getMaxVersionCountPerPolicy(), props.isVersionRollingEnabled());
        }

        public boolean isXacmlXmlSupported() {
            return this.pdp.isXacmlXmlSupportEnabled();
        }

        public boolean isXacmlJsonSupported() {
            return this.pdp.isXacmlJsonSupportEnabled();
        }

        public Response evaluatePolicyDecision(Request request) throws UnsupportedOperationException {
            if (this.pdp == null) {
                throw NULL_PDP_ERROR;
            }
            return this.pdp.evaluate(request);
        }

        public JSONObject evaluatePolicyDecision(JSONObject request) throws UnsupportedOperationException {
            if (this.pdp == null) {
                throw NULL_PDP_ERROR;
            }
            return this.pdp.evaluate(request);
        }

        private final class DirectoryToMemorySyncTask
        implements Runnable {
            private DirectoryToMemorySyncTask() {
            }

            @Override
            public void run() {
                try {
                    FileBasedDomainDaoImpl.this.sync();
                }
                catch (Throwable e) {
                    LOGGER.error("Domain '{}': error occurred during synchronization", (Object)FileBasedDomainDaoImpl.this.domainId, (Object)e);
                }
            }
        }
    }

    private static final class PdpBundle {
        private final CloseablePdpEngine engine;
        private final PdpEngineInoutAdapter<Request, Response> xacmlJaxbIoAdapter;
        private final PdpEngineInoutAdapter<JSONObject, JSONObject> xacmlJsonIoAdapter;

        private PdpBundle(PdpEngineConfiguration pdpConf, boolean enableXacmlJsonProfile) throws IllegalArgumentException, IOException {
            this.engine = new BasePdpEngine(pdpConf);
            Iterable pdpApplicablePolicies = this.engine.getApplicablePolicies();
            if (pdpApplicablePolicies == null) {
                this.engine.close();
                throw ILLEGAL_POLICY_NOT_STATIC_EXCEPTION;
            }
            Map ioProcChains = pdpConf.getInOutProcChains();
            int clientReqErrVerbosityLevel = pdpConf.getClientRequestErrorVerbosityLevel();
            AttributeValueFactoryRegistry attValFactoryRegistry = pdpConf.getAttributeValueFactoryRegistry();
            boolean isStrictAttIssuerMatchEnabled = pdpConf.isStrictAttributeIssuerMatchEnabled();
            boolean isXpathEnabled = pdpConf.isXPathEnabled();
            DecisionRequestPreprocessorSupplier defaultXacmlXmlReqPreprocSupplier = extraPdpFeatures -> DEFAULT_XACML_XML_DECISION_REQUEST_PREPROC_FACTORY.getInstance(attValFactoryRegistry, isStrictAttIssuerMatchEnabled, isXpathEnabled, extraPdpFeatures);
            Supplier<DecisionResultPostprocessor> defaultXacmlXmlResultPostproc = () -> new BaseXacmlJaxbResultPostprocessor(clientReqErrVerbosityLevel);
            this.xacmlJaxbIoAdapter = PdpEngineAdapters.newInoutAdapter(Request.class, Response.class, (CloseablePdpEngine)this.engine, (Map)ioProcChains, (DecisionRequestPreprocessorSupplier)defaultXacmlXmlReqPreprocSupplier, defaultXacmlXmlResultPostproc);
            if (enableXacmlJsonProfile) {
                DecisionRequestPreprocessorSupplier defaultXacmlJsonReqPreprocSupplier = extraPdpFeatures -> DEFAULT_XACML_JSON_DECISION_REQUEST_PREPROC_FACTORY.getInstance(attValFactoryRegistry, isStrictAttIssuerMatchEnabled, isXpathEnabled, extraPdpFeatures);
                Supplier<DecisionResultPostprocessor> defaultXacmlJsonResultPostproc = () -> new BaseXacmlJsonResultPostprocessor(clientReqErrVerbosityLevel);
                this.xacmlJsonIoAdapter = PdpEngineAdapters.newInoutAdapter(JSONObject.class, JSONObject.class, (CloseablePdpEngine)this.engine, (Map)ioProcChains, (DecisionRequestPreprocessorSupplier)defaultXacmlJsonReqPreprocSupplier, defaultXacmlJsonResultPostproc);
            } else {
                this.xacmlJsonIoAdapter = null;
            }
        }

        private boolean isXacmlXmlSupportEnabled() {
            return this.xacmlJaxbIoAdapter != null;
        }

        private boolean isXacmlJsonSupportEnabled() {
            return this.xacmlJsonIoAdapter != null;
        }

        private Response evaluate(Request request) {
            assert (this.xacmlJaxbIoAdapter != null);
            return (Response)this.xacmlJaxbIoAdapter.evaluate((Object)request);
        }

        private JSONObject evaluate(JSONObject request) {
            if (this.xacmlJsonIoAdapter == null) {
                throw UNSUPPORTED_XACML_JSON_PROFILE_OPERATION_EXCEPTION;
            }
            return (JSONObject)this.xacmlJsonIoAdapter.evaluate((Object)request);
        }
    }

    public static enum PdpCoreFeature {
        XPATH_EVAL("urn:ow2:authzforce:feature:pdp:core:xpath-eval"),
        STRICT_ATTRIBUTE_ISSUER_MATCH("urn:ow2:authzforce:feature:pdp:core:strict-attribute-issuer-match");

        private final String id;

        private PdpCoreFeature(String id) {
            this.id = id;
        }

        private static PdpCoreFeature fromId(String id) {
            for (PdpCoreFeature f : PdpCoreFeature.values()) {
                if (!f.id.equals(id)) continue;
                return f;
            }
            return null;
        }

        public String toString() {
            return this.id;
        }
    }

    public static final class PdpFeatureType
    extends Enum<PdpFeatureType> {
        public static final /* enum */ PdpFeatureType CORE = new PdpFeatureType("urn:ow2:authzforce:feature-type:pdp:core", null);
        public static final /* enum */ PdpFeatureType DATATYPE = new PdpFeatureType("urn:ow2:authzforce:feature-type:pdp:data-type", AttributeValueFactory.class);
        public static final /* enum */ PdpFeatureType FUNCTION = new PdpFeatureType("urn:ow2:authzforce:feature-type:pdp:function", Function.class);
        public static final /* enum */ PdpFeatureType COMBINING_ALGORITHM = new PdpFeatureType("urn:ow2:authzforce:feature-type:pdp:combining-algorithm", CombiningAlg.class);
        public static final /* enum */ PdpFeatureType REQUEST_PREPROC = new PdpFeatureType("urn:ow2:authzforce:feature-type:pdp:request-preproc", DecisionRequestPreprocessor.Factory.class);
        public static final /* enum */ PdpFeatureType RESULT_POSTPROC = new PdpFeatureType("urn:ow2:authzforce:feature-type:pdp:result-postproc", DecisionResultPostprocessor.Factory.class);
        private final Class<? extends PdpExtension> extensionClass;
        private final String id;
        private static final Map<String, PdpFeatureType> ID_TO_FEATURE_MAP;
        private static final /* synthetic */ PdpFeatureType[] $VALUES;

        public static PdpFeatureType[] values() {
            return (PdpFeatureType[])$VALUES.clone();
        }

        public static PdpFeatureType valueOf(String name) {
            return Enum.valueOf(PdpFeatureType.class, name);
        }

        private PdpFeatureType(String id, Class<? extends PdpExtension> extensionClass) {
            assert (id != null);
            this.id = id;
            this.extensionClass = extensionClass;
        }

        public String toString() {
            return this.id;
        }

        static {
            $VALUES = new PdpFeatureType[]{CORE, DATATYPE, FUNCTION, COMBINING_ALGORITHM, REQUEST_PREPROC, RESULT_POSTPROC};
            ID_TO_FEATURE_MAP = Maps.uniqueIndex(Arrays.asList(PdpFeatureType.values()), input -> {
                assert (input != null);
                return input.id;
            });
        }
    }

    private static class ReadablePdpPropertiesImpl
    implements ReadablePdpProperties {
        private final List<PdpFeature> features;
        private final IdReferenceType rootPolicyRefExpression;
        private final IdReferenceType applicableRootPolicyRef;
        private final List<IdReferenceType> applicableRefPolicyRefs;
        private final long lastModified;

        private ReadablePdpPropertiesImpl(List<PdpFeature> features, TopLevelPolicyElementRef rootPolicyRef, TopLevelPolicyElementRef applicableRootPolicyRef, List<TopLevelPolicyElementRef> applicableRefPolicyRefs, long lastModified) {
            assert (rootPolicyRef != null && applicableRootPolicyRef != null && applicableRefPolicyRefs != null && features != null);
            this.features = features;
            this.rootPolicyRefExpression = new IdReferenceType(rootPolicyRef.getValue(), rootPolicyRef.getVersion(), null, null);
            this.applicableRootPolicyRef = new IdReferenceType(applicableRootPolicyRef.getValue(), applicableRootPolicyRef.getVersion(), null, null);
            this.applicableRefPolicyRefs = applicableRefPolicyRefs.stream().map(ref -> new IdReferenceType(ref.getValue(), ref.getVersion(), null, null)).collect(Collectors.toList());
            this.lastModified = lastModified;
        }

        public List<PdpFeature> getFeatures() {
            return this.features;
        }

        public IdReferenceType getRootPolicyRefExpression() {
            return this.rootPolicyRefExpression;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public IdReferenceType getApplicableRootPolicyRef() {
            return this.applicableRootPolicyRef;
        }

        public List<IdReferenceType> getApplicableRefPolicyRefs() {
            return this.applicableRefPolicyRefs;
        }
    }

    private static class PrpRwPropertiesImpl
    implements PrpRwProperties {
        private final int maxPolicyCount;
        private final int maxVersionCountPerPolicy;
        private final boolean isVersionRollingEnabled;

        private PrpRwPropertiesImpl(int maxPolicyCount, int maxVersionCountPerPolicy, boolean enableVersionRolling) {
            this.maxPolicyCount = maxPolicyCount;
            this.maxVersionCountPerPolicy = maxVersionCountPerPolicy;
            this.isVersionRollingEnabled = enableVersionRolling;
        }

        public boolean isVersionRollingEnabled() {
            return this.isVersionRollingEnabled;
        }

        public int getMaxVersionCountPerPolicy() {
            return this.maxVersionCountPerPolicy;
        }

        public int getMaxPolicyCountPerDomain() {
            return this.maxPolicyCount;
        }
    }

    private static class ReadableDomainPropertiesImpl
    implements ReadableDomainProperties {
        private final String domainId;
        private final String description;
        private final String externalId;

        private ReadableDomainPropertiesImpl(String domainId, String description, String externalId) {
            assert (domainId != null);
            this.domainId = domainId;
            this.description = description;
            this.externalId = externalId;
        }

        public String getInternalId() {
            return this.domainId;
        }

        public String getExternalId() {
            return this.externalId;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

