/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.pap.dao.flatfile;

import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicySet;
import org.ow2.authzforce.core.pap.api.dao.AuthzPolicy;
import org.ow2.authzforce.core.pap.api.dao.JaxbXacmlAuthzPolicy;
import org.ow2.authzforce.core.pdp.api.HashCollections;
import org.ow2.authzforce.core.pdp.api.XmlUtils;
import org.ow2.authzforce.core.pdp.api.policy.PolicyVersion;
import org.ow2.authzforce.core.pdp.impl.policy.PolicyVersions;
import org.ow2.authzforce.xacml.Xacml3JaxbHelper;

public final class FlatFileDAOUtils {
    private static final Base64.Encoder BASE64URL_NO_PADDING_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder BASE64URL_NO_PADDING_DECODER = Base64.getUrlDecoder();
    private static final IllegalArgumentException NULL_FILE_ARGUMENT_EXCEPTION = new IllegalArgumentException("Null file arg");
    public static final DirectoryStream.Filter<Path> SUB_DIRECTORY_STREAM_FILTER = x$0 -> Files.isDirectory(x$0, new LinkOption[0]);
    private static final FileVisitor<Path> DELETING_FILE_VISITOR = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (attrs.isRegularFile()) {
                Files.delete(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc == null) {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
            throw exc;
        }
    };

    public static String base64UrlEncode(byte[] bytes) {
        return BASE64URL_NO_PADDING_ENCODER.encodeToString(bytes);
    }

    public static String base64UrlEncode(String input) {
        return FlatFileDAOUtils.base64UrlEncode(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String base64UrlDecode(String encoded) throws IllegalArgumentException {
        return new String(BASE64URL_NO_PADDING_DECODER.decode(encoded), StandardCharsets.UTF_8);
    }

    public static String getPrefix(Path file, int filenameSuffixLength) throws IllegalArgumentException {
        assert (file != null);
        Path fileName = file.getFileName();
        if (fileName == null) {
            throw new IllegalArgumentException("Invalid file (no filename, probably root?): " + file);
        }
        String filename = fileName.toString();
        return filename.substring(0, filename.length() - filenameSuffixLength);
    }

    public static void checkFile(String friendlyname, Path file, boolean isdirectory, boolean canwrite) throws IllegalArgumentException {
        if (file == null) {
            throw NULL_FILE_ARGUMENT_EXCEPTION;
        }
        String exStartMsg = friendlyname + " = '" + file.toAbsolutePath() + "' ";
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IllegalArgumentException(exStartMsg + "not found");
        }
        if (!Files.isReadable(file)) {
            throw new IllegalArgumentException(exStartMsg + "cannot be read");
        }
        if (isdirectory && !Files.isDirectory(file, new LinkOption[0])) {
            throw new IllegalArgumentException(exStartMsg + "is not a directory");
        }
        if (!isdirectory && !Files.isDirectory(file, new LinkOption[0])) {
            throw new IllegalArgumentException(exStartMsg + "is not a normal file");
        }
        if (canwrite && !Files.isWritable(file)) {
            throw new IllegalArgumentException(exStartMsg + "cannot be written to");
        }
    }

    public static void copyDirectory(Path source, Path target, int maxDepth) throws IOException, IllegalArgumentException {
        Files.walkFileTree(source, Collections.emptySet(), maxDepth, new CopyingFileVisitor(source, target));
    }

    public static void deleteDirectory(Path dir, int maxDepth) throws IOException, IllegalArgumentException {
        Files.walkFileTree(dir, Collections.emptySet(), maxDepth, DELETING_FILE_VISITOR);
    }

    public static AuthzPolicy loadPolicy(Path policyFilepath) throws IllegalArgumentException, JAXBException {
        Object jaxbPolicyOrPolicySetObj;
        URL policyURL;
        try {
            policyURL = Objects.requireNonNull(policyFilepath, "Undefined policyFilepath").toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to locate policy file: " + policyFilepath, e);
        }
        XmlUtils.SAXBasedXmlnsFilteringParser nonNullXacmlParser = new XmlUtils.SAXBasedXmlnsFilteringParser(Xacml3JaxbHelper.createXacml3Unmarshaller());
        try {
            jaxbPolicyOrPolicySetObj = nonNullXacmlParser.parse(policyURL);
        }
        catch (JAXBException e) {
            throw new JAXBException("Failed to unmarshall Policy(Set) XML document from policy location: " + policyURL, (Throwable)e);
        }
        if (!(jaxbPolicyOrPolicySetObj instanceof PolicySet)) {
            throw new IllegalArgumentException("Unexpected/unsupported element found as root of the XML document at policy location '" + policyURL + "': " + jaxbPolicyOrPolicySetObj.getClass().getSimpleName());
        }
        return new JaxbXacmlAuthzPolicy((PolicySet)jaxbPolicyOrPolicySetObj, nonNullXacmlParser.getNamespacePrefixUriMap());
    }

    public static Map.Entry<PolicyVersion, Path> getLatestPolicyVersion(Path versionsDirectory, SuffixMatchingDirectoryStreamFilter filenameSuffixMatchingFilter) throws IOException {
        try (DirectoryStream<Path> policyDirStream = Files.newDirectoryStream(Objects.requireNonNull(versionsDirectory, "Undefined versionsDirectory"), Objects.requireNonNull(filenameSuffixMatchingFilter, "Undefined filenameSuffixMatchingFilter"));){
            PolicyVersion latestVersion = null;
            Path latestFilepath = null;
            for (Path policyVersionFilePath : policyDirStream) {
                Path policyVersionFileName = policyVersionFilePath.getFileName();
                if (policyVersionFileName == null) {
                    throw new IOException("Invalid policy file path: " + policyVersionFilePath);
                }
                String versionPlusSuffix = policyVersionFileName.toString();
                String versionId = versionPlusSuffix.substring(0, versionPlusSuffix.length() - filenameSuffixMatchingFilter.pathSuffix.length());
                PolicyVersion version = new PolicyVersion(versionId);
                if (latestVersion != null && latestVersion.compareTo(version) >= 0) continue;
                latestVersion = version;
                latestFilepath = policyVersionFilePath;
            }
            AbstractMap.SimpleImmutableEntry<Object, Object> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Object, Object>(latestVersion, latestFilepath);
            return simpleImmutableEntry;
        }
    }

    public static PolicyVersions<Path> getPolicyVersions(Path versionsDirectory, SuffixMatchingDirectoryStreamFilter filenameSuffixMatchingFilter) throws IOException {
        Objects.requireNonNull(versionsDirectory, "Undefined versionsDirectory");
        Objects.requireNonNull(versionsDirectory, "Undefined filenameSuffixMatchingFilter");
        Map versions = HashCollections.newUpdatableMap();
        try (DirectoryStream<Path> policyDirStream = Files.newDirectoryStream(versionsDirectory, filenameSuffixMatchingFilter);){
            for (Path policyVersionFilePath : policyDirStream) {
                Path policyVersionFileName = policyVersionFilePath.getFileName();
                if (policyVersionFileName == null) {
                    throw new IOException("Invalid policy file path: " + policyVersionFilePath);
                }
                String versionPlusSuffix = policyVersionFileName.toString();
                String versionId = versionPlusSuffix.substring(0, versionPlusSuffix.length() - filenameSuffixMatchingFilter.pathSuffix.length());
                PolicyVersion version = new PolicyVersion(versionId);
                versions.put(version, policyVersionFilePath);
            }
        }
        return new PolicyVersions(versions);
    }

    private FlatFileDAOUtils() {
    }

    private static class CopyingFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path source;
        private final Path target;

        private CopyingFileVisitor(Path source, Path target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Files.copy(file, this.target.resolve(this.source.relativize(file)), new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) throws IOException {
            block2: {
                Path targetDirectory = this.target.resolve(this.source.relativize(directory));
                try {
                    Files.copy(directory, targetDirectory, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException e) {
                    if (Files.isDirectory(targetDirectory, new LinkOption[0])) break block2;
                    throw e;
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }

    public static final class SuffixMatchingDirectoryStreamFilter
    implements DirectoryStream.Filter<Path> {
        private final PathMatcher pathSuffixMatcher;
        private final String pathSuffix;

        public SuffixMatchingDirectoryStreamFilter(String suffix) {
            this.pathSuffix = suffix;
            this.pathSuffixMatcher = FileSystems.getDefault().getPathMatcher("glob:*" + suffix);
        }

        public String getMatchedSuffix() {
            return this.pathSuffix;
        }

        @Override
        public boolean accept(Path entry) {
            return Files.isRegularFile(entry, new LinkOption[0]) && this.pathSuffixMatcher.matches(entry.getFileName());
        }
    }
}

