/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.pap.dao.flatfile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;

public final class XmlnsAppendingDelegatingXMLStreamWriter
extends DelegatingXMLStreamWriter {
    private static final UnsupportedOperationException UNSUPPORTED_OPERATION_EXCEPTION = new UnsupportedOperationException();
    private final ImmutableMap<String, String> xpathNamespaceContexts;
    private boolean xpathNsAppended = false;

    public XmlnsAppendingDelegatingXMLStreamWriter(XMLStreamWriter delegate, ImmutableMap<String, String> xmlNamespaceContexts) throws XMLStreamException {
        super(delegate);
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0);
        Preconditions.checkArgument((xmlNamespaceContexts != null ? 1 : 0) != 0);
        try {
            super.setNamespaceContext((NamespaceContext)new MapNamespaceContext(xmlNamespaceContexts));
        }
        catch (UnsupportedOperationException e) {
            for (Map.Entry nsEntry : xmlNamespaceContexts.entrySet()) {
                super.setPrefix((String)nsEntry.getKey(), (String)nsEntry.getValue());
            }
        }
        this.xpathNamespaceContexts = xmlNamespaceContexts;
    }

    private void appendNamespaces() throws XMLStreamException {
        if (this.xpathNsAppended) {
            return;
        }
        for (Map.Entry nsContext : this.xpathNamespaceContexts.entrySet()) {
            super.writeNamespace((String)nsContext.getKey(), (String)nsContext.getValue());
        }
        this.xpathNsAppended = true;
    }

    public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
        super.writeStartElement(prefix, local, uri);
        this.appendNamespaces();
    }

    public void setDefaultNamespace(String uri) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void setNamespaceContext(NamespaceContext ctx) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void setPrefix(String pfx, String uri) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }
}

