/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.pap.dao.flatfile;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;

public final class FlatFileDAOUtils {
    private static final BaseEncoding BASE64URL_NO_PADDING_ENCODING = BaseEncoding.base64Url().omitPadding();
    private static final IllegalArgumentException NULL_FILE_ARGUMENT_EXCEPTION = new IllegalArgumentException("Null file arg");
    private static FileVisitor<Path> DELETING_FILE_VISITOR = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (attrs.isRegularFile()) {
                Files.delete(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc == null) {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
            throw exc;
        }
    };

    public static String base64UrlEncode(byte[] bytes) {
        return BASE64URL_NO_PADDING_ENCODING.encode(bytes);
    }

    public static String base64UrlEncode(String input) {
        return BASE64URL_NO_PADDING_ENCODING.encode(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String base64UrlDecode(String encoded) throws IllegalArgumentException {
        return new String(BASE64URL_NO_PADDING_ENCODING.decode((CharSequence)encoded), StandardCharsets.UTF_8);
    }

    private FlatFileDAOUtils() {
    }

    public static void checkFile(String friendlyname, Path file, boolean isdirectory, boolean canwrite) throws IllegalArgumentException {
        if (file == null) {
            throw NULL_FILE_ARGUMENT_EXCEPTION;
        }
        String exStartMsg = String.valueOf(friendlyname) + " = '" + file.toAbsolutePath() + "' ";
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IllegalArgumentException(String.valueOf(exStartMsg) + "not found");
        }
        if (!Files.isReadable(file)) {
            throw new IllegalArgumentException(String.valueOf(exStartMsg) + "cannot be read");
        }
        if (isdirectory && !Files.isDirectory(file, new LinkOption[0])) {
            throw new IllegalArgumentException(String.valueOf(exStartMsg) + "is not a directory");
        }
        if (!isdirectory && !Files.isDirectory(file, new LinkOption[0])) {
            throw new IllegalArgumentException(String.valueOf(exStartMsg) + "is not a normal file");
        }
        if (canwrite && !Files.isWritable(file)) {
            throw new IllegalArgumentException(String.valueOf(exStartMsg) + "cannot be written to");
        }
    }

    public static void copyDirectory(Path source, Path target, int maxDepth) throws IOException, IllegalArgumentException {
        Files.walkFileTree(source, Collections.emptySet(), maxDepth, new CopyingFileVisitor(source, target));
    }

    public static void deleteDirectory(Path dir, int maxDepth) throws IOException, IllegalArgumentException {
        Files.walkFileTree(dir, Collections.emptySet(), maxDepth, DELETING_FILE_VISITOR);
    }

    private static class CopyingFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path source;
        private final Path target;

        private CopyingFileVisitor(Path source, Path target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Files.copy(file, this.target.resolve(this.source.relativize(file)), new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) throws IOException {
            block2: {
                Path targetDirectory = this.target.resolve(this.source.relativize(directory));
                try {
                    Files.copy(directory, targetDirectory, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException e) {
                    if (Files.isDirectory(targetDirectory, new LinkOption[0])) break block2;
                    throw e;
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }

    public static final class SuffixMatchingDirectoryStreamFilter
    implements DirectoryStream.Filter<Path> {
        private final PathMatcher pathSuffixMatcher;

        public SuffixMatchingDirectoryStreamFilter(String suffix) {
            this.pathSuffixMatcher = FileSystems.getDefault().getPathMatcher("glob:*" + suffix);
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            boolean isAccepted = Files.isRegularFile(entry, new LinkOption[0]) && Files.isReadable(entry) && this.pathSuffixMatcher.matches(entry.getFileName());
            return isAccepted;
        }
    }
}

