/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.pap.dao.flatfile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.JAXBException;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicySet;
import org.ow2.authzforce.core.pdp.api.EnvironmentProperties;
import org.ow2.authzforce.core.pdp.api.HashCollections;
import org.ow2.authzforce.core.pdp.api.IndeterminateEvaluationException;
import org.ow2.authzforce.core.pdp.api.XmlUtils;
import org.ow2.authzforce.core.pdp.api.combining.CombiningAlgRegistry;
import org.ow2.authzforce.core.pdp.api.expression.ExpressionFactory;
import org.ow2.authzforce.core.pdp.api.policy.BaseStaticRefPolicyProvider;
import org.ow2.authzforce.core.pdp.api.policy.CloseableRefPolicyProvider;
import org.ow2.authzforce.core.pdp.api.policy.PolicyRefsMetadata;
import org.ow2.authzforce.core.pdp.api.policy.PolicyVersion;
import org.ow2.authzforce.core.pdp.api.policy.StaticRefPolicyProvider;
import org.ow2.authzforce.core.pdp.api.policy.StaticTopLevelPolicyElementEvaluator;
import org.ow2.authzforce.core.pdp.api.policy.VersionPatterns;
import org.ow2.authzforce.core.pdp.impl.policy.PolicyEvaluators;
import org.ow2.authzforce.core.pdp.impl.policy.PolicyMap;
import org.ow2.authzforce.pap.dao.flatfile.FlatFileDAOUtils;
import org.ow2.authzforce.pap.dao.flatfile.xmlns.StaticFlatFileDAORefPolicyProvider;
import org.ow2.authzforce.xacml.identifiers.XacmlStatusCode;
import org.springframework.util.ResourceUtils;

public final class FlatFileDAORefPolicyProviderModule
extends BaseStaticRefPolicyProvider {
    private static final IllegalArgumentException NULL_POLICY_LOCATION_PATTERN_ARGUMENT_EXCEPTION = new IllegalArgumentException("policyLocationPattern argument undefined");
    private static final IllegalArgumentException NULL_XML_CONF_ARGUMENT_EXCEPTION = new IllegalArgumentException("XML/JAXB configuration argument undefined");
    private static final IllegalArgumentException UNSUPPORTED_POLICY_REFERENCE_EXCEPTION = new IllegalArgumentException("PolicyIdReferences not supported");
    private final XmlUtils.XmlnsFilteringParserFactory xacmlParserFactory;
    private final ExpressionFactory expressionFactory;
    private final CombiningAlgRegistry combiningAlgRegistry;
    private final PolicyMap<PolicyEvaluatorSupplier> policyCache;

    public static Map.Entry<Path, String> validateConf(String policyLocationPattern) throws IllegalArgumentException {
        Path policyParentDirectory;
        if (policyLocationPattern == null) {
            throw NULL_POLICY_LOCATION_PATTERN_ARGUMENT_EXCEPTION;
        }
        int index = policyLocationPattern.indexOf("/*");
        if (index == -1) {
            throw new IllegalArgumentException("Invalid policyLocationPattern in refPolicyProvider configuration: " + policyLocationPattern + ": '/*' not found");
        }
        String prefix = policyLocationPattern.substring(0, index);
        try {
            policyParentDirectory = ResourceUtils.getFile((String)prefix).toPath();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Invalid policy directory path in refPolicyProvider/policyLocationPattern (prefix before '/*'): " + policyLocationPattern, e);
        }
        String suffix = policyLocationPattern.substring(index + 2);
        return new AbstractMap.SimpleImmutableEntry<Path, String>(policyParentDirectory, suffix);
    }

    private FlatFileDAORefPolicyProviderModule(Path policyParentDirectory, String suffix, XmlUtils.XmlnsFilteringParserFactory xacmlParserFactory, ExpressionFactory expressionFactory, CombiningAlgRegistry combiningAlgRegistry, int maxPolicySetRefDepth) throws IllegalArgumentException {
        super(maxPolicySetRefDepth);
        assert (policyParentDirectory != null);
        assert (xacmlParserFactory != null);
        assert (expressionFactory != null);
        assert (combiningAlgRegistry != null);
        FlatFileDAOUtils.checkFile("RefPolicyProvider's policy directory", policyParentDirectory, true, false);
        Map updatablePolicyMap = HashCollections.newUpdatableMap();
        FlatFileDAOUtils.SuffixMatchingDirectoryStreamFilter policyFilenameSuffixMatchingDirStreamFilter = new FlatFileDAOUtils.SuffixMatchingDirectoryStreamFilter(suffix);
        try (DirectoryStream<Path> policyParentDirStream = Files.newDirectoryStream(policyParentDirectory, FlatFileDAOUtils.SUB_DIRECTORY_STREAM_FILTER);){
            for (Path policyVersionsDir : policyParentDirStream) {
                String policyId;
                Path lastPathSegment = policyVersionsDir.getFileName();
                if (lastPathSegment == null) {
                    throw new IllegalArgumentException("Invalid policy directory: no filename (root of filesystem?): " + policyVersionsDir);
                }
                String policyDirName = lastPathSegment.toString();
                try {
                    policyId = FlatFileDAOUtils.base64UrlDecode(policyDirName);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid policy directory: bad filename (not Base64URL-encoded): " + policyDirName, e);
                }
                Map policySetSuppliersByVersion = HashCollections.newUpdatableMap();
                try (DirectoryStream<Path> policyVersionsDirStream = Files.newDirectoryStream(policyVersionsDir, policyFilenameSuffixMatchingDirStreamFilter);){
                    for (Path policyVersionFile : policyVersionsDirStream) {
                        policySetSuppliersByVersion.put(new PolicyVersion(FlatFileDAOUtils.getPrefix(policyVersionFile, suffix.length())), new PolicyEvaluatorSupplier(policyVersionFile));
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Error listing files of each version of policy '" + policyId + "' in directory: " + policyParentDirectory, e);
                }
                updatablePolicyMap.put(policyId, policySetSuppliersByVersion);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error listing files in policies parent directory '" + policyParentDirectory, e);
        }
        this.policyCache = new PolicyMap(updatablePolicyMap);
        this.xacmlParserFactory = xacmlParserFactory;
        this.expressionFactory = expressionFactory;
        this.combiningAlgRegistry = combiningAlgRegistry;
    }

    public StaticTopLevelPolicyElementEvaluator getPolicy(String id, Optional<VersionPatterns> versionPatterns) throws IndeterminateEvaluationException {
        throw UNSUPPORTED_POLICY_REFERENCE_EXCEPTION;
    }

    public StaticTopLevelPolicyElementEvaluator getPolicySet(String id, Optional<VersionPatterns> versionPatterns, Deque<String> policySetRefChain) throws IndeterminateEvaluationException {
        List resultPolicyLongestRefChain;
        Optional policyRefsMeta;
        StaticTopLevelPolicyElementEvaluator policyEvaluator;
        Map.Entry policyEntry = this.policyCache.get(id, versionPatterns);
        if (policyEntry == null) {
            return null;
        }
        try {
            policyEvaluator = ((PolicyEvaluatorSupplier)policyEntry.getValue()).get(this, policySetRefChain);
        }
        catch (IndeterminateEvaluationException e) {
            PolicyVersion version = (PolicyVersion)policyEntry.getKey();
            throw new IndeterminateEvaluationException("Matched PolicySet '" + id + "' (version " + version + ") is invalid or its content is unavailable", XacmlStatusCode.PROCESSING_ERROR.value(), (Throwable)e);
        }
        if (policySetRefChain != null && !policySetRefChain.isEmpty() && (policyRefsMeta = policyEvaluator.getPolicyRefsMetadata()).isPresent() && !(resultPolicyLongestRefChain = ((PolicyRefsMetadata)policyRefsMeta.get()).getLongestPolicyRefChain()).isEmpty()) {
            this.joinPolicyRefChains(policySetRefChain, resultPolicyLongestRefChain);
        }
        return policyEvaluator;
    }

    public void close() throws IOException {
    }

    public static final class Factory
    extends CloseableRefPolicyProvider.Factory<StaticFlatFileDAORefPolicyProvider> {
        private static final IllegalArgumentException ILLEGAL_COMBINING_ALG_REGISTRY_ARGUMENT_EXCEPTION = new IllegalArgumentException("Undefined CombiningAlgorithm registry");
        private static final IllegalArgumentException ILLEGAL_EXPRESSION_FACTORY_ARGUMENT_EXCEPTION = new IllegalArgumentException("Undefined Expression factory");
        private static final IllegalArgumentException ILLEGAL_XACML_PARSER_FACTORY_ARGUMENT_EXCEPTION = new IllegalArgumentException("Undefined XACML parser factory");

        public CloseableRefPolicyProvider getInstance(StaticFlatFileDAORefPolicyProvider conf, XmlUtils.XmlnsFilteringParserFactory xacmlParserFactory, int maxPolicySetRefDepth, ExpressionFactory expressionFactory, CombiningAlgRegistry combiningAlgRegistry, EnvironmentProperties environmentProperties) throws IllegalArgumentException {
            if (conf == null) {
                throw NULL_XML_CONF_ARGUMENT_EXCEPTION;
            }
            if (xacmlParserFactory == null) {
                throw ILLEGAL_XACML_PARSER_FACTORY_ARGUMENT_EXCEPTION;
            }
            if (expressionFactory == null) {
                throw ILLEGAL_EXPRESSION_FACTORY_ARGUMENT_EXCEPTION;
            }
            if (combiningAlgRegistry == null) {
                throw ILLEGAL_COMBINING_ALG_REGISTRY_ARGUMENT_EXCEPTION;
            }
            String policyLocationPattern = environmentProperties.replacePlaceholders(conf.getPolicyLocationPattern());
            Map.Entry<Path, String> result = FlatFileDAORefPolicyProviderModule.validateConf(policyLocationPattern);
            return new FlatFileDAORefPolicyProviderModule(result.getKey(), result.getValue(), xacmlParserFactory, expressionFactory, combiningAlgRegistry, maxPolicySetRefDepth);
        }

        public Class<StaticFlatFileDAORefPolicyProvider> getJaxbClass() {
            return StaticFlatFileDAORefPolicyProvider.class;
        }
    }

    private static final class PolicyEvaluatorSupplier {
        private final Path policyFilepath;
        private transient StaticTopLevelPolicyElementEvaluator policyEvaluator = null;

        private PolicyEvaluatorSupplier(Path policyFilepath) {
            assert (policyFilepath != null && Files.isRegularFile(policyFilepath, LinkOption.NOFOLLOW_LINKS) && Files.isReadable(policyFilepath));
            this.policyFilepath = policyFilepath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StaticTopLevelPolicyElementEvaluator get(FlatFileDAORefPolicyProviderModule refPolicyProviderModule, Deque<String> policySetRefChain) throws IndeterminateEvaluationException {
            Path path = this.policyFilepath;
            synchronized (path) {
                if (this.policyEvaluator == null) {
                    PolicySet jaxbPolicySet;
                    XmlUtils.XmlnsFilteringParser xacmlParser;
                    if (!Files.isRegularFile(this.policyFilepath, LinkOption.NOFOLLOW_LINKS)) {
                        throw new IndeterminateEvaluationException("Unable to find PolicySet file: " + this.policyFilepath, XacmlStatusCode.PROCESSING_ERROR.value());
                    }
                    try {
                        xacmlParser = refPolicyProviderModule.xacmlParserFactory.getInstance();
                        jaxbPolicySet = FlatFileDAOUtils.loadPolicy(this.policyFilepath, xacmlParser);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IndeterminateEvaluationException("Invalid PolicySet in file: " + this.policyFilepath, XacmlStatusCode.PROCESSING_ERROR.value(), (Throwable)e);
                    }
                    catch (JAXBException e1) {
                        throw new IndeterminateEvaluationException("Error loading PolicySet from file: " + this.policyFilepath, XacmlStatusCode.PROCESSING_ERROR.value(), (Throwable)e1);
                    }
                    try {
                        this.policyEvaluator = PolicyEvaluators.getInstanceStatic((PolicySet)jaxbPolicySet, null, (Map)xacmlParser.getNamespacePrefixUriMap(), (ExpressionFactory)refPolicyProviderModule.expressionFactory, (CombiningAlgRegistry)refPolicyProviderModule.combiningAlgRegistry, (StaticRefPolicyProvider)refPolicyProviderModule, policySetRefChain);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IndeterminateEvaluationException("Invalid PolicySet in file: " + this.policyFilepath, XacmlStatusCode.PROCESSING_ERROR.value(), (Throwable)e);
                    }
                }
            }
            return this.policyEvaluator;
        }
    }
}

