/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.rest.service.jaxrs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicySet;
import org.ow2.authzforce.core.pap.api.dao.AuthzPolicy;
import org.ow2.authzforce.core.pap.api.dao.DomainDao;
import org.ow2.authzforce.core.pap.api.dao.PolicyVersionDaoClient;
import org.ow2.authzforce.core.pdp.api.policy.PolicyVersion;
import org.ow2.authzforce.rest.api.jaxrs.PolicyVersionResource;

public class PolicyVersionResourceImpl
implements PolicyVersionDaoClient,
PolicyVersionResource {
    private static final NotFoundException NOT_FOUND_EXCEPTION = new NotFoundException();
    private static final IllegalArgumentException ILLEGAL_VERSION_ARGUMENT_EXCEPTION = new IllegalArgumentException("Version for policy version resource undefined");
    private static final IllegalArgumentException ILLEGAL_VERSION_DAO_ARGUMENT_EXCEPTION = new IllegalArgumentException("Policy version DAO for policy version resource undefined");
    public static final String XML_NS_CONTEXTS_CXF_MESSAGE_CONTEXT_PROPERTY_NAME = PolicyVersionResourceImpl.class.getName() + ".xmlnsContexts";
    public static final ThreadLocal<Map<String, String>> OUTPUT_POLICY_XPATH_NAMESPACE_CONTEXT = ThreadLocal.withInitial(HashMap::new);
    public static final PolicyVersionDaoClient.Factory<PolicyVersionResourceImpl> FACTORY = (policyId, versionId, domainDAO) -> {
        if (versionId == null) {
            throw ILLEGAL_VERSION_ARGUMENT_EXCEPTION;
        }
        if (domainDAO == null) {
            throw ILLEGAL_VERSION_DAO_ARGUMENT_EXCEPTION;
        }
        return new PolicyVersionResourceImpl(policyId, versionId, domainDAO);
    };
    private final PolicyVersion versionId;
    private final DomainDao<?, ?> domainDAO;
    private final String policyId;

    private PolicyVersionResourceImpl(String policyId, PolicyVersion versionId, DomainDao<?, ?> domainDAO) {
        assert (versionId != null && domainDAO != null);
        this.policyId = policyId;
        this.versionId = versionId;
        this.domainDAO = domainDAO;
    }

    public PolicySet getPolicyVersion() {
        AuthzPolicy policyVersion;
        try {
            policyVersion = this.domainDAO.getPolicyVersion(this.policyId, this.versionId);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error getting policy version '" + this.versionId + "'", (Throwable)e);
        }
        if (policyVersion == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        OUTPUT_POLICY_XPATH_NAMESPACE_CONTEXT.get().putAll(policyVersion.getXPathNamespaceContexts());
        return policyVersion.toXacml();
    }

    public PolicySet deletePolicyVersion() throws IllegalArgumentException {
        AuthzPolicy deletedPolicyVersion;
        try {
            deletedPolicyVersion = this.domainDAO.removePolicyVersion(this.policyId, this.versionId);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error removing policy version '" + this.versionId + "'", (Throwable)e);
        }
        if (deletedPolicyVersion == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        OUTPUT_POLICY_XPATH_NAMESPACE_CONTEXT.get().putAll(deletedPolicyVersion.getXPathNamespaceContexts());
        return deletedPolicyVersion.toXacml();
    }
}

