/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.rest.service.jaxrs;

import java.util.regex.Pattern;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBException;
import org.ow2.authzforce.rest.api.xmlns.Error;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Provider
public class BadRequestExceptionMapper
implements ExceptionMapper<BadRequestException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BadRequestExceptionMapper.class);
    private static final Pattern JAXBEXCEPTION_MSG_START_PATTERN = Pattern.compile("^JAXBException occurred :", 2);
    private static final String INVALID_PARAM_MSG_PREFIX = "Invalid parameters: ";

    public Response toResponse(BadRequestException exception) {
        String errMsg;
        LOGGER.warn("Bad request", (Throwable)exception);
        Response oldResp = exception.getResponse();
        Throwable cause = exception.getCause();
        if (cause != null) {
            Throwable internalCause;
            if (cause instanceof SAXException) {
                internalCause = cause.getCause();
                if (internalCause instanceof JAXBException) {
                    Throwable linkedEx = ((JAXBException)internalCause).getLinkedException();
                    errMsg = INVALID_PARAM_MSG_PREFIX + linkedEx.getMessage();
                } else {
                    errMsg = INVALID_PARAM_MSG_PREFIX + cause.getMessage();
                }
            } else if (cause instanceof JAXBException) {
                Throwable linkedEx = ((JAXBException)cause).getLinkedException();
                errMsg = INVALID_PARAM_MSG_PREFIX + linkedEx.getMessage();
            } else if (cause instanceof IllegalArgumentException) {
                internalCause = cause.getCause();
                errMsg = cause.getMessage() + (internalCause == null ? "" : ": " + internalCause.getMessage());
            } else {
                errMsg = cause.getMessage();
            }
        } else {
            Object oldEntity = oldResp.getEntity();
            errMsg = oldEntity instanceof String ? JAXBEXCEPTION_MSG_START_PATTERN.matcher((String)oldEntity).replaceFirst(INVALID_PARAM_MSG_PREFIX) : null;
        }
        if (errMsg != null) {
            Error errorEntity = new Error(errMsg);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorEntity).build();
        }
        return oldResp;
    }
}

