/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.rest.service.jaxrs;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.ow2.authzforce.core.pap.api.dao.DomainsDAO;
import org.ow2.authzforce.core.pap.api.dao.WritableDomainProperties;
import org.ow2.authzforce.rest.api.jaxrs.DomainResource;
import org.ow2.authzforce.rest.api.jaxrs.DomainsResource;
import org.ow2.authzforce.rest.api.xmlns.DomainProperties;
import org.ow2.authzforce.rest.api.xmlns.Resources;
import org.ow2.authzforce.rest.service.jaxrs.DomainResourceImpl;
import org.ow2.authzforce.rest.service.jaxrs.WritableDomainPropertiesImpl;
import org.w3._2005.atom.Link;
import org.w3._2005.atom.Relation;

public class DomainsResourceImpl
implements DomainsResource {
    private static final NotFoundException NOT_FOUND_EXCEPTION = new NotFoundException();
    private static final BadRequestException INVALID_ARG_BAD_REQUEST_EXCEPTION = new BadRequestException("Invalid argument");
    private static final Escaper URL_PATH_SEGMENT_ESCAPER = UrlEscapers.urlPathSegmentEscaper();
    @Context
    private MessageContext messageContext;
    private final DomainsDAO<DomainResourceImpl<?>> domainRepo;
    private final String authorizedResourceAttrId;
    private final String anyResourceId;

    @ConstructorProperties(value={"domainsDAO", "authorizedResourceAttribute", "anyResourceId"})
    public DomainsResourceImpl(DomainsDAO<DomainResourceImpl<?>> domainsDAO, String authorizedResourceAttribute, String anyResourceId) {
        this.domainRepo = domainsDAO;
        this.authorizedResourceAttrId = authorizedResourceAttribute;
        this.anyResourceId = anyResourceId;
    }

    public Link addDomain(DomainProperties props) {
        String domainId;
        if (props == null) {
            throw INVALID_ARG_BAD_REQUEST_EXCEPTION;
        }
        try {
            domainId = this.domainRepo.addDomain((WritableDomainProperties)new WritableDomainPropertiesImpl(props));
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        String encodedUrlPathSegment = URL_PATH_SEGMENT_ESCAPER.escape(domainId);
        Link link = new Link();
        link.setHref(encodedUrlPathSegment);
        link.setRel(Relation.ITEM);
        link.setTitle(domainId);
        return link;
    }

    public Resources getDomains(String externalId) {
        HashSet<String> authorizedDomainIDs = new HashSet<String>();
        Object attrVal = this.messageContext.getHttpServletRequest().getAttribute(this.authorizedResourceAttrId);
        if (attrVal == null) {
            if (this.anyResourceId == null) {
                authorizedDomainIDs.addAll(this.domainRepo.getDomainIDs(externalId));
            }
        } else if (attrVal instanceof List) {
            List resourceIds = (List)attrVal;
            if (resourceIds.contains(this.anyResourceId)) {
                authorizedDomainIDs.addAll(this.domainRepo.getDomainIDs(externalId));
            } else {
                for (Object resourceId : resourceIds) {
                    String domainId = resourceId.toString();
                    if (!this.domainRepo.containsDomain(domainId)) continue;
                    authorizedDomainIDs.add(domainId);
                }
            }
        } else {
            throw new InternalServerErrorException((Throwable)new IllegalArgumentException("Invalid type of value for ServletRequest attribute '" + this.authorizedResourceAttrId + "' = " + attrVal + " used to specify autorized resource. Expected: java.util.List<String>"));
        }
        ArrayList<Link> domainResourceLinks = new ArrayList<Link>(authorizedDomainIDs.size());
        for (String domainId : authorizedDomainIDs) {
            String encodedUrlPathSegment = URL_PATH_SEGMENT_ESCAPER.escape(domainId);
            Link link = new Link();
            link.setHref(encodedUrlPathSegment);
            link.setRel(Relation.ITEM);
            link.setTitle(domainId);
            domainResourceLinks.add(link);
        }
        return new Resources(domainResourceLinks);
    }

    public DomainResource getDomainResource(String domainId) {
        if (domainId == null) {
            throw INVALID_ARG_BAD_REQUEST_EXCEPTION;
        }
        DomainResource domainRes = (DomainResource)this.domainRepo.getDomainDAOClient(domainId);
        if (domainRes == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        return domainRes;
    }
}

