/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.rest.service.jaxrs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NavigableSet;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import org.ow2.authzforce.core.pap.api.dao.DomainDAO;
import org.ow2.authzforce.core.pap.api.dao.PolicyDAOClient;
import org.ow2.authzforce.core.pap.api.dao.PolicyVersionDAOClient;
import org.ow2.authzforce.core.pdp.api.PolicyVersion;
import org.ow2.authzforce.rest.api.jaxrs.PolicyResource;
import org.ow2.authzforce.rest.api.jaxrs.PolicyVersionResource;
import org.ow2.authzforce.rest.api.xmlns.Resources;
import org.ow2.authzforce.rest.service.jaxrs.PolicyVersionResourceImpl;
import org.w3._2005.atom.Link;
import org.w3._2005.atom.Relation;

public class PolicyResourceImpl
implements PolicyDAOClient,
PolicyResource {
    private static final NotFoundException NOT_FOUND_EXCEPTION = new NotFoundException();
    private static final BadRequestException INVALID_ARG_BAD_REQUEST_EXCEPTION = new BadRequestException("Invalid argument");
    private static final IllegalArgumentException ILLEGAL_POLICY_ID_ARGUMENT_EXCEPTION = new IllegalArgumentException("Policy ID for policy resource undefined");
    private static final IllegalArgumentException ILLEGAL_POLICY_DAO_ARGUMENT_EXCEPTION = new IllegalArgumentException("Policy DAO for policy resource undefined");
    public static final PolicyDAOClient.Factory<PolicyVersionResourceImpl, PolicyResourceImpl> FACTORY = new PolicyDAOClient.Factory<PolicyVersionResourceImpl, PolicyResourceImpl>(){

        public PolicyResourceImpl getInstance(String policyId, DomainDAO<PolicyVersionResourceImpl, ?> policyDAO) {
            if (policyId == null) {
                throw ILLEGAL_POLICY_ID_ARGUMENT_EXCEPTION;
            }
            if (policyDAO == null) {
                throw ILLEGAL_POLICY_DAO_ARGUMENT_EXCEPTION;
            }
            return new PolicyResourceImpl(policyId, policyDAO);
        }

        public PolicyVersionDAOClient.Factory<PolicyVersionResourceImpl> getVersionDAOClientFactory() {
            return PolicyVersionResourceImpl.FACTORY;
        }
    };
    private final DomainDAO<PolicyVersionResourceImpl, ?> domainDAO;
    private final String policyId;

    private PolicyResourceImpl(String policyId, DomainDAO<PolicyVersionResourceImpl, ?> domainDAO) {
        assert (domainDAO != null);
        this.policyId = policyId;
        this.domainDAO = domainDAO;
    }

    private static Resources getVersionResources(NavigableSet<PolicyVersion> versions) {
        ArrayList<Link> policyVersionLinks = new ArrayList<Link>(versions.size());
        Iterator<PolicyVersion> versionIterator = versions.descendingIterator();
        while (versionIterator.hasNext()) {
            Link link = new Link();
            policyVersionLinks.add(link);
            link.setHref(versionIterator.next().toString());
            link.setRel(Relation.ITEM);
        }
        return new Resources(policyVersionLinks);
    }

    public Resources deletePolicy() {
        NavigableSet removedPolicyVersions;
        try {
            removedPolicyVersions = this.domainDAO.removePolicy(this.policyId);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error removing policy '" + this.policyId + "' (all versions)", (Throwable)e);
        }
        if (removedPolicyVersions.isEmpty()) {
            throw NOT_FOUND_EXCEPTION;
        }
        return PolicyResourceImpl.getVersionResources(removedPolicyVersions);
    }

    public Resources getPolicyVersions() {
        NavigableSet policyVersions;
        try {
            policyVersions = this.domainDAO.getPolicyVersions(this.policyId);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error getting all versions of policy '" + this.policyId + "'", (Throwable)e);
        }
        if (policyVersions.isEmpty()) {
            throw NOT_FOUND_EXCEPTION;
        }
        return PolicyResourceImpl.getVersionResources(policyVersions);
    }

    public PolicyVersionResource getPolicyVersionResource(String version) {
        if (version == null) {
            throw INVALID_ARG_BAD_REQUEST_EXCEPTION;
        }
        PolicyVersionResource versionResource = (PolicyVersionResource)this.domainDAO.getVersionDAOClient(this.policyId, version);
        if (versionResource == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        return versionResource;
    }
}

