/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.rest.service.jaxrs;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicySet;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.Request;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.Response;
import org.ow2.authzforce.core.pap.api.dao.DomainDAO;
import org.ow2.authzforce.core.pap.api.dao.DomainDAOClient;
import org.ow2.authzforce.core.pap.api.dao.PdpFeature;
import org.ow2.authzforce.core.pap.api.dao.PolicyDAOClient;
import org.ow2.authzforce.core.pap.api.dao.PrpRWProperties;
import org.ow2.authzforce.core.pap.api.dao.ReadableDomainProperties;
import org.ow2.authzforce.core.pap.api.dao.ReadablePdpProperties;
import org.ow2.authzforce.core.pap.api.dao.TooManyPoliciesException;
import org.ow2.authzforce.core.pap.api.dao.WritableDomainProperties;
import org.ow2.authzforce.core.pap.api.dao.WritablePdpProperties;
import org.ow2.authzforce.core.pdp.api.PDP;
import org.ow2.authzforce.rest.api.jaxrs.AttributeProvidersResource;
import org.ow2.authzforce.rest.api.jaxrs.DomainPropertiesResource;
import org.ow2.authzforce.rest.api.jaxrs.DomainResource;
import org.ow2.authzforce.rest.api.jaxrs.PapResource;
import org.ow2.authzforce.rest.api.jaxrs.PdpPropertiesResource;
import org.ow2.authzforce.rest.api.jaxrs.PdpResource;
import org.ow2.authzforce.rest.api.jaxrs.PoliciesResource;
import org.ow2.authzforce.rest.api.jaxrs.PolicyResource;
import org.ow2.authzforce.rest.api.jaxrs.PrpPropertiesResource;
import org.ow2.authzforce.rest.api.xmlns.ApplicablePolicies;
import org.ow2.authzforce.rest.api.xmlns.AttributeProviders;
import org.ow2.authzforce.rest.api.xmlns.Domain;
import org.ow2.authzforce.rest.api.xmlns.DomainProperties;
import org.ow2.authzforce.rest.api.xmlns.Feature;
import org.ow2.authzforce.rest.api.xmlns.PdpProperties;
import org.ow2.authzforce.rest.api.xmlns.PdpPropertiesUpdate;
import org.ow2.authzforce.rest.api.xmlns.PrpProperties;
import org.ow2.authzforce.rest.api.xmlns.ResourceContent;
import org.ow2.authzforce.rest.api.xmlns.Resources;
import org.ow2.authzforce.rest.service.jaxrs.PolicyResourceImpl;
import org.ow2.authzforce.rest.service.jaxrs.PolicyVersionResourceImpl;
import org.ow2.authzforce.rest.service.jaxrs.PrpRWPropertiesImpl;
import org.ow2.authzforce.rest.service.jaxrs.WritableDomainPropertiesImpl;
import org.ow2.authzforce.rest.service.jaxrs.WritablePdpPropertiesImpl;
import org.w3._2005.atom.Link;
import org.w3._2005.atom.Relation;

public class DomainResourceImpl<DAO extends DomainDAO<PolicyVersionResourceImpl, PolicyResourceImpl>>
implements DomainDAOClient<DAO>,
DomainResource,
DomainPropertiesResource,
PapResource,
PdpResource,
PoliciesResource,
AttributeProvidersResource,
PdpPropertiesResource,
PrpPropertiesResource {
    public static final Escaper URL_PATH_SEGMENT_ESCAPER = UrlEscapers.urlPathSegmentEscaper();
    private static final InternalServerErrorException NULL_PDP_INTERNAL_SERVER_ERROR_EXCEPTION = new InternalServerErrorException("PDP is in erroneous state. Please contact the domain or system administrator.");
    private static final ClientErrorException ADD_POLICY_CONFLICT_EXCEPTION = new ClientErrorException("PolicySet already exists with same PolicySetId and Version", Response.Status.CONFLICT);
    private static final NotFoundException NOT_FOUND_EXCEPTION = new NotFoundException();
    private static final BadRequestException INVALID_ARG_BAD_REQUEST_EXCEPTION = new BadRequestException("Invalid argument");
    private static final DatatypeFactory XML_DATATYPE_FACTORY;
    private static final TimeZone UTC_TZ;
    private static final String GET_PROPERTIES_RESOURCE_METHOD_NAME = "getDomainPropertiesResource";
    private static final String GET_PAP_RESOURCE_METHOD_NAME = "getPapResource";
    private static final String GET_PDP_PROPERTIES_RESOURCE_METHOD_NAME = "getPdpPropertiesResource";
    private static final String GET_PRP_PROPERTIES_RESOURCE_METHOD_NAME = "getPrpPropertiesResource";
    private static final String GET_PDP_RESOURCE_METHOD_NAME = "getPdpResource";
    private static final String GET_POLICIES_RESOURCE_METHOD_NAME = "getPoliciesResource";
    private static final String GET_ATTRIBUTE_PROVIDERS_RESOURCE_METHOD_NAME = "getAttributeProvidersResource";
    private final String domainId;
    private final DAO domainDAO;

    private DomainResourceImpl(String domainId, DAO domainDAO) {
        assert (domainDAO != null);
        this.domainId = domainId;
        this.domainDAO = domainDAO;
    }

    public Domain getDomain() {
        ReadableDomainProperties props;
        Path pdpResourcePath;
        Path papResourcePath;
        Path propsResourcePath;
        Link propsLink = new Link();
        try {
            propsResourcePath = DomainResource.class.getDeclaredMethod(GET_PROPERTIES_RESOURCE_METHOD_NAME, new Class[0]).getAnnotation(Path.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InternalServerErrorException("Error getting the 'properties' resource of domain '" + this.domainId + "'", (Throwable)e);
        }
        propsLink.setHref(propsResourcePath.value());
        propsLink.setTitle("Domain properties");
        propsLink.setRel(Relation.ITEM);
        Link papLink = new Link();
        try {
            papResourcePath = DomainResource.class.getDeclaredMethod(GET_PAP_RESOURCE_METHOD_NAME, new Class[0]).getAnnotation(Path.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InternalServerErrorException("Error getting the 'pap' resource of domain '" + this.domainId + "'", (Throwable)e);
        }
        papLink.setHref(papResourcePath.value());
        papLink.setTitle("Policy Administration Point");
        papLink.setRel(Relation.ITEM);
        Link pdpLink = new Link();
        try {
            pdpResourcePath = DomainResource.class.getDeclaredMethod(GET_PDP_RESOURCE_METHOD_NAME, new Class[0]).getAnnotation(Path.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InternalServerErrorException("Error getting the 'pdp' resource of domain '" + this.domainId + "'", (Throwable)e);
        }
        pdpLink.setHref(pdpResourcePath.value());
        pdpLink.setTitle("Policy Decision Point");
        pdpLink.setRel(Relation.ITEM);
        Resources childResources = new Resources(Arrays.asList(propsLink, papLink, pdpLink));
        try {
            props = this.domainDAO.getDomainProperties();
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error getting the properties of domain '" + this.domainId + "'", (Throwable)e);
        }
        if (props == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        return new Domain(new DomainProperties(props.getDescription(), props.getExternalId()), childResources);
    }

    public DomainProperties deleteDomain() {
        ReadableDomainProperties props;
        try {
            props = this.domainDAO.removeDomain();
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error removing the domain '" + this.domainId + "'", (Throwable)e);
        }
        if (props == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        return new DomainProperties(props.getDescription(), props.getExternalId());
    }

    public PapResource getPapResource() {
        return this;
    }

    public PdpResource getPdpResource() {
        return this;
    }

    public DomainPropertiesResource getDomainPropertiesResource() {
        return this;
    }

    public Response requestPolicyDecision(Request request) {
        PDP pdp = this.domainDAO.getPDP();
        if (pdp == null) {
            throw NULL_PDP_INTERNAL_SERVER_ERROR_EXCEPTION;
        }
        return pdp.evaluate(request);
    }

    public ResourceContent getPAP() {
        Path attrProvidersResourcePath;
        Path policiesResourcePath;
        Path prpPropsResourcePath;
        Path pdpPropsResourcePath;
        Link pdpPropsLink = new Link();
        try {
            pdpPropsResourcePath = PapResource.class.getDeclaredMethod(GET_PDP_PROPERTIES_RESOURCE_METHOD_NAME, new Class[0]).getAnnotation(Path.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InternalServerErrorException("Error getting the 'pdp.properties' resource of the domain '" + this.domainId + "'", (Throwable)e);
        }
        pdpPropsLink.setHref(pdpPropsResourcePath.value());
        pdpPropsLink.setTitle("PDP properties");
        pdpPropsLink.setRel(Relation.ITEM);
        Link prpPropsLink = new Link();
        try {
            prpPropsResourcePath = PapResource.class.getDeclaredMethod(GET_PRP_PROPERTIES_RESOURCE_METHOD_NAME, new Class[0]).getAnnotation(Path.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InternalServerErrorException("Error getting the 'prp.properties' resource of the domain '" + this.domainId + "'", (Throwable)e);
        }
        prpPropsLink.setHref(prpPropsResourcePath.value());
        prpPropsLink.setTitle("PRP properties");
        prpPropsLink.setRel(Relation.ITEM);
        Link policiesLink = new Link();
        try {
            policiesResourcePath = PapResource.class.getDeclaredMethod(GET_POLICIES_RESOURCE_METHOD_NAME, new Class[0]).getAnnotation(Path.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InternalServerErrorException("Error getting the 'policies' resource of the domain '" + this.domainId + "'", (Throwable)e);
        }
        policiesLink.setHref(policiesResourcePath.value());
        policiesLink.setTitle("PRP policies");
        policiesLink.setRel(Relation.ITEM);
        Link attrProvidersLink = new Link();
        try {
            attrProvidersResourcePath = PapResource.class.getDeclaredMethod(GET_ATTRIBUTE_PROVIDERS_RESOURCE_METHOD_NAME, new Class[0]).getAnnotation(Path.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InternalServerErrorException("Error getting the 'attributeProviders' resource of the domain '" + this.domainId + "'", (Throwable)e);
        }
        attrProvidersLink.setHref(attrProvidersResourcePath.value());
        attrProvidersLink.setTitle("PDP Attribute Providers");
        attrProvidersLink.setRel(Relation.ITEM);
        Resources childResources = new Resources(Arrays.asList(pdpPropsLink, prpPropsLink, policiesLink, attrProvidersLink));
        return new ResourceContent(null, childResources);
    }

    public PoliciesResource getPoliciesResource() {
        return this;
    }

    public AttributeProvidersResource getAttributeProvidersResource() {
        return this;
    }

    public DomainProperties getDomainProperties() {
        ReadableDomainProperties props;
        try {
            props = this.domainDAO.getDomainProperties();
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error getting the properties of domain '" + this.domainId + "'", (Throwable)e);
        }
        if (props == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        return new DomainProperties(props.getDescription(), props.getExternalId());
    }

    public DomainProperties updateDomainProperties(DomainProperties properties) {
        if (properties == null) {
            throw INVALID_ARG_BAD_REQUEST_EXCEPTION;
        }
        WritableDomainPropertiesImpl newProps = new WritableDomainPropertiesImpl(properties);
        try {
            this.domainDAO.setDomainProperties((WritableDomainProperties)newProps);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error updating the properties of domain '" + this.domainId + "'", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        return properties;
    }

    public AttributeProviders getAttributeProviderList() {
        List attributeProviders;
        try {
            attributeProviders = this.domainDAO.getAttributeProviders();
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error getting the attributeProviders configuration of domain '" + this.domainId + "'", (Throwable)e);
        }
        return new AttributeProviders(attributeProviders);
    }

    public AttributeProviders updateAttributeProviderList(AttributeProviders attributeproviders) {
        if (attributeproviders == null) {
            throw INVALID_ARG_BAD_REQUEST_EXCEPTION;
        }
        try {
            this.domainDAO.setAttributeProviders(attributeproviders.getAttributeProviders());
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error updating the attributeProviders configuration of domain '" + this.domainId + "'", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        return attributeproviders;
    }

    public Link addPolicy(PolicySet policy) {
        PolicySet conflictingPolicy;
        if (policy == null) {
            throw INVALID_ARG_BAD_REQUEST_EXCEPTION;
        }
        try {
            conflictingPolicy = this.domainDAO.addPolicy(policy);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error adding policy to domain '" + this.domainId + "'", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        catch (TooManyPoliciesException e) {
            throw new ForbiddenException((Throwable)e);
        }
        if (conflictingPolicy != null) {
            throw ADD_POLICY_CONFLICT_EXCEPTION;
        }
        String policyIdUrlPathSegment = URL_PATH_SEGMENT_ESCAPER.escape(policy.getPolicySetId());
        Link policyResourceLink = new Link();
        policyResourceLink.setHref(policyIdUrlPathSegment + "/" + policy.getVersion());
        policyResourceLink.setTitle("Policy '" + policy.getPolicySetId() + "' v" + policy.getVersion());
        policyResourceLink.setRel(Relation.ITEM);
        return policyResourceLink;
    }

    public PolicyResource getPolicyResource(String policyId) {
        if (policyId == null) {
            throw INVALID_ARG_BAD_REQUEST_EXCEPTION;
        }
        PolicyResource policyRes = (PolicyResource)this.domainDAO.getPolicyDAOClient(policyId);
        if (policyRes == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        return policyRes;
    }

    public Resources getPolicies() {
        Set policyResourceIDs;
        try {
            policyResourceIDs = this.domainDAO.getPolicyIDs();
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error getting policy resource IDs in domain '" + this.domainId + "'", (Throwable)e);
        }
        if (policyResourceIDs.size() < 1) {
            throw new InternalServerErrorException("Missing root policy resource from DAO in domain '" + this.domainId + "'");
        }
        ArrayList<Link> policyResourceLinks = new ArrayList<Link>(policyResourceIDs.size());
        for (String policyResourceId : policyResourceIDs) {
            Link link = new Link();
            policyResourceLinks.add(link);
            link.setHref(policyResourceId);
            link.setRel(Relation.ITEM);
        }
        return new Resources(policyResourceLinks);
    }

    public DAO getDAO() {
        return this.domainDAO;
    }

    public PdpPropertiesResource getPdpPropertiesResource() {
        return this;
    }

    public PdpProperties getOtherPdpProperties() {
        ReadablePdpProperties props;
        try {
            props = this.domainDAO.getOtherPdpProperties();
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error getting the properties of the PDP of domain '" + this.domainId + "'", (Throwable)e);
        }
        if (props == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        GregorianCalendar cal = new GregorianCalendar(UTC_TZ);
        cal.setTimeInMillis(props.getLastModified());
        List pdpFeatures = props.getFeatures();
        ArrayList<Feature> features = new ArrayList<Feature>(pdpFeatures.size());
        for (PdpFeature pdpFeature : pdpFeatures) {
            features.add(new Feature(pdpFeature.getID(), pdpFeature.getType(), Boolean.valueOf(pdpFeature.isEnabled())));
        }
        return new PdpProperties(features, props.getRootPolicyRefExpression(), new ApplicablePolicies(props.getApplicableRootPolicyRef(), props.getApplicableRefPolicyRefs()), XML_DATATYPE_FACTORY.newXMLGregorianCalendar(cal));
    }

    public PdpProperties updateOtherPdpProperties(PdpPropertiesUpdate properties) {
        ReadablePdpProperties allProps;
        if (properties == null) {
            throw INVALID_ARG_BAD_REQUEST_EXCEPTION;
        }
        WritablePdpPropertiesImpl propsUpdate = new WritablePdpPropertiesImpl(properties);
        try {
            allProps = this.domainDAO.setOtherPdpProperties((WritablePdpProperties)propsUpdate);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error updating the properties of the PDP of domain '" + this.domainId + "'", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        GregorianCalendar cal = new GregorianCalendar(UTC_TZ);
        cal.setTimeInMillis(allProps.getLastModified());
        List allPdpFeatures = allProps.getFeatures();
        ArrayList<Feature> allFeatures = new ArrayList<Feature>(allPdpFeatures.size());
        for (PdpFeature pdpFeature : allPdpFeatures) {
            allFeatures.add(new Feature(pdpFeature.getID(), pdpFeature.getType(), Boolean.valueOf(pdpFeature.isEnabled())));
        }
        return new PdpProperties(allFeatures, allProps.getRootPolicyRefExpression(), new ApplicablePolicies(allProps.getApplicableRootPolicyRef(), allProps.getApplicableRefPolicyRefs()), XML_DATATYPE_FACTORY.newXMLGregorianCalendar(cal));
    }

    public PrpPropertiesResource getPrpPropertiesResource() {
        return this;
    }

    public PrpProperties updateOtherPrpProperties(PrpProperties properties) {
        PrpRWProperties allProps;
        if (properties == null) {
            throw INVALID_ARG_BAD_REQUEST_EXCEPTION;
        }
        PrpRWPropertiesImpl propsUpdate = new PrpRWPropertiesImpl(properties);
        try {
            allProps = this.domainDAO.setOtherPrpProperties((PrpRWProperties)propsUpdate);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error updating the properties of the PRP of domain '" + this.domainId + "'", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        int maxPolicyCount = allProps.getMaxPolicyCountPerDomain();
        BigInteger mpc = maxPolicyCount > 0 ? BigInteger.valueOf(maxPolicyCount) : null;
        int maxVersionCount = allProps.getMaxVersionCountPerPolicy();
        BigInteger mvc = maxVersionCount > 0 ? BigInteger.valueOf(maxVersionCount) : null;
        return new PrpProperties(mpc, mvc, Boolean.valueOf(allProps.isVersionRollingEnabled()));
    }

    public PrpProperties getOtherPrpProperties() {
        PrpRWProperties props;
        try {
            props = this.domainDAO.getOtherPrpProperties();
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error getting the properties of the PRP of domain '" + this.domainId + "'", (Throwable)e);
        }
        if (props == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        int maxPolicyCount = props.getMaxPolicyCountPerDomain();
        BigInteger mpc = maxPolicyCount > 0 ? BigInteger.valueOf(maxPolicyCount) : null;
        int maxVersionCount = props.getMaxVersionCountPerPolicy();
        BigInteger mvc = maxVersionCount > 0 ? BigInteger.valueOf(maxVersionCount) : null;
        return new PrpProperties(mpc, mvc, Boolean.valueOf(props.isVersionRollingEnabled()));
    }

    /* synthetic */ DomainResourceImpl(String x0, DomainDAO x1, 1 x2) {
        this(x0, x1);
    }

    static {
        try {
            XML_DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        UTC_TZ = TimeZone.getTimeZone("UTC");
    }

    static class 1 {
    }

    public static class Factory<DOMAIN_DAO extends DomainDAO<PolicyVersionResourceImpl, PolicyResourceImpl>>
    implements DomainDAOClient.Factory<PolicyVersionResourceImpl, PolicyResourceImpl, DOMAIN_DAO, DomainResourceImpl<DOMAIN_DAO>> {
        private static final IllegalArgumentException ILLEGAL_DOMAIN_ID_ARGUMENT_EXCEPTION = new IllegalArgumentException("Domain ID for domain resource undefined");
        private static final IllegalArgumentException ILLEGAL_DOMAIN_DAO_ARGUMENT_EXCEPTION = new IllegalArgumentException("Domain DAO for domain resource undefined");

        public DomainResourceImpl<DOMAIN_DAO> getInstance(String domainId, DOMAIN_DAO domainDAO) {
            if (domainId == null) {
                throw ILLEGAL_DOMAIN_ID_ARGUMENT_EXCEPTION;
            }
            if (domainDAO == null) {
                throw ILLEGAL_DOMAIN_DAO_ARGUMENT_EXCEPTION;
            }
            return new DomainResourceImpl(domainId, (DomainDAO)domainDAO, null);
        }

        public PolicyDAOClient.Factory<PolicyVersionResourceImpl, PolicyResourceImpl> getPolicyDAOClientFactory() {
            return PolicyResourceImpl.FACTORY;
        }
    }
}

