/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.rest.service.jaxrs;

import java.util.List;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;

public class XmlAndJsonOnlyMediaTypeRequestFilter
implements ContainerRequestFilter {
    private static final NotAcceptableException NOT_ACCEPTABLE_EXCEPTION = new NotAcceptableException();
    private static final String APPLICATION_MEDIA_TYPE = MediaType.APPLICATION_XML_TYPE.getType();
    private static final String XML_SUB_MEDIA_TYPE = MediaType.APPLICATION_XML_TYPE.getSubtype();
    private static final String JSON_SUB_MEDIA_TYPE = MediaType.APPLICATION_JSON_TYPE.getSubtype();

    public void filter(ContainerRequestContext context) {
        List acceptMediaTypes = context.getAcceptableMediaTypes();
        if (acceptMediaTypes.isEmpty()) {
            return;
        }
        MediaType mediaType0 = (MediaType)acceptMediaTypes.get(0);
        if (mediaType0.equals((Object)MediaType.WILDCARD_TYPE)) {
            return;
        }
        if (mediaType0.getType().equalsIgnoreCase(APPLICATION_MEDIA_TYPE) && (mediaType0.getSubtype().equalsIgnoreCase(XML_SUB_MEDIA_TYPE) || mediaType0.getSubtype().equalsIgnoreCase(JSON_SUB_MEDIA_TYPE))) {
            return;
        }
        throw NOT_ACCEPTABLE_EXCEPTION;
    }
}

