/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.rest.service.jaxrs;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Properties;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.ow2.authzforce.rest.api.jaxrs.ProductMetadataResource;
import org.ow2.authzforce.rest.api.xmlns.ProductMetadata;

public final class ProductMetadataResourceImpl
implements ProductMetadataResource {
    private static final DatatypeFactory XML_DATATYPE_FACTORY;
    private static final String PRODUCT_PROPERTIES_CLASSPATH_URL = "/org.ow2.authzforce.server.product.properties";
    private static final String PRODUCT_NAME;
    private static final String PRODUCT_VERSION;
    private static final XMLGregorianCalendar PRODUCT_RELEASE_DATE;
    private static final String PRODUCT_API_DOC_URL;

    public ProductMetadata getProductMetadata() {
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        return new ProductMetadata(PRODUCT_NAME, PRODUCT_VERSION, PRODUCT_RELEASE_DATE, XML_DATATYPE_FACTORY.newDuration(rb.getUptime()), PRODUCT_API_DOC_URL);
    }

    static {
        try {
            XML_DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        Properties prodProps = new Properties();
        try (InputStream propFileIn = ProductMetadataResourceImpl.class.getResourceAsStream(PRODUCT_PROPERTIES_CLASSPATH_URL);){
            if (propFileIn == null) {
                throw new RuntimeException("Missing product properties resource on the classpath: /org.ow2.authzforce.server.product.properties");
            }
            prodProps.load(propFileIn);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading product properties file on the classpath", e);
        }
        PRODUCT_NAME = prodProps.getProperty("name");
        Preconditions.checkNotNull((Object)PRODUCT_NAME, (String)"Property 'name' undefined in file '%s'", (Object)PRODUCT_PROPERTIES_CLASSPATH_URL);
        PRODUCT_VERSION = prodProps.getProperty("version");
        Preconditions.checkNotNull((Object)PRODUCT_VERSION, (String)"Property 'version' undefined in file '%s'", (Object)PRODUCT_PROPERTIES_CLASSPATH_URL);
        String buildDate = prodProps.getProperty("build.date");
        Preconditions.checkNotNull((Object)buildDate, (String)"Property 'build.date' undefined in file '%s'", (Object)PRODUCT_PROPERTIES_CLASSPATH_URL);
        PRODUCT_RELEASE_DATE = XML_DATATYPE_FACTORY.newXMLGregorianCalendar(buildDate);
        PRODUCT_API_DOC_URL = prodProps.getProperty("api.doc.url");
        Preconditions.checkNotNull((Object)PRODUCT_API_DOC_URL, (String)"Property 'api.doc.ur' undefined in file '%s'", (Object)PRODUCT_PROPERTIES_CLASSPATH_URL);
    }
}

