/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.rest.service.jaxrs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableSet;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import org.ow2.authzforce.core.pap.api.dao.DomainDao;
import org.ow2.authzforce.core.pap.api.dao.PolicyDaoClient;
import org.ow2.authzforce.core.pap.api.dao.PolicyVersionDaoClient;
import org.ow2.authzforce.core.pdp.api.policy.PolicyVersion;
import org.ow2.authzforce.rest.api.jaxrs.PolicyResource;
import org.ow2.authzforce.rest.api.jaxrs.PolicyVersionResource;
import org.ow2.authzforce.rest.api.xmlns.Resources;
import org.ow2.authzforce.rest.service.jaxrs.PolicyVersionResourceImpl;
import org.w3._2005.atom.Link;
import org.w3._2005.atom.Relation;

public class PolicyResourceImpl
implements PolicyDaoClient,
PolicyResource {
    private static final String LATEST_VERSION_ID = "latest";
    private static final NotFoundException NOT_FOUND_EXCEPTION = new NotFoundException();
    private static final BadRequestException INVALID_ARG_BAD_REQUEST_EXCEPTION = new BadRequestException("Invalid argument");
    private static final IllegalArgumentException ILLEGAL_POLICY_ID_ARGUMENT_EXCEPTION = new IllegalArgumentException("Policy ID for policy resource undefined");
    private static final IllegalArgumentException ILLEGAL_POLICY_DAO_ARGUMENT_EXCEPTION = new IllegalArgumentException("Policy DAO for policy resource undefined");
    public static final PolicyDaoClient.Factory<PolicyVersionResourceImpl, PolicyResourceImpl> FACTORY = new PolicyDaoClient.Factory<PolicyVersionResourceImpl, PolicyResourceImpl>(){

        public PolicyResourceImpl getInstance(String policyId, DomainDao<PolicyVersionResourceImpl, ?> policyDAO) {
            if (policyId == null) {
                throw ILLEGAL_POLICY_ID_ARGUMENT_EXCEPTION;
            }
            if (policyDAO == null) {
                throw ILLEGAL_POLICY_DAO_ARGUMENT_EXCEPTION;
            }
            return new PolicyResourceImpl(policyId, policyDAO);
        }

        public PolicyVersionDaoClient.Factory<PolicyVersionResourceImpl> getVersionDaoClientFactory() {
            return PolicyVersionResourceImpl.FACTORY;
        }
    };
    private final DomainDao<PolicyVersionResourceImpl, ?> domainDAO;
    private final String policyId;

    private PolicyResourceImpl(String policyId, DomainDao<PolicyVersionResourceImpl, ?> domainDAO) {
        assert (domainDAO != null);
        this.policyId = policyId;
        this.domainDAO = domainDAO;
    }

    private static Resources getVersionResources(NavigableSet<PolicyVersion> versions) {
        ArrayList<Link> policyVersionLinks = new ArrayList<Link>(versions.size());
        for (PolicyVersion v : versions) {
            Link link = new Link();
            policyVersionLinks.add(link);
            link.setHref(v.toString());
            link.setRel(Relation.ITEM);
        }
        return new Resources(policyVersionLinks);
    }

    public Resources deletePolicy() {
        NavigableSet removedPolicyVersions;
        try {
            removedPolicyVersions = this.domainDAO.removePolicy(this.policyId);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error removing policy '" + this.policyId + "' (all versions)", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        if (removedPolicyVersions.isEmpty()) {
            throw NOT_FOUND_EXCEPTION;
        }
        return PolicyResourceImpl.getVersionResources(removedPolicyVersions);
    }

    public Resources getPolicyVersions() {
        NavigableSet policyVersions;
        try {
            policyVersions = this.domainDAO.getPolicyVersions(this.policyId);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error getting all versions of policy '" + this.policyId + "'", (Throwable)e);
        }
        if (policyVersions.isEmpty()) {
            throw NOT_FOUND_EXCEPTION;
        }
        return PolicyResourceImpl.getVersionResources(policyVersions);
    }

    public PolicyVersionResource getPolicyVersionResource(String version) {
        PolicyVersion policyVersion;
        if (version == null) {
            throw INVALID_ARG_BAD_REQUEST_EXCEPTION;
        }
        if (version.equals(LATEST_VERSION_ID)) {
            try {
                policyVersion = this.domainDAO.getLatestPolicyVersionId(this.policyId);
            }
            catch (IOException e) {
                throw new InternalServerErrorException("Error getting latest version of policy '" + this.policyId + "'", (Throwable)e);
            }
        }
        try {
            policyVersion = new PolicyVersion(version);
        }
        catch (IllegalArgumentException e) {
            throw INVALID_ARG_BAD_REQUEST_EXCEPTION;
        }
        PolicyVersionResource versionResource = (PolicyVersionResource)this.domainDAO.getVersionDaoClient(this.policyId, policyVersion);
        if (versionResource == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        return versionResource;
    }
}

