/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.rest.service.jaxrs;

import java.io.IOException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicySet;
import org.ow2.authzforce.core.pap.api.dao.DomainDao;
import org.ow2.authzforce.core.pap.api.dao.PolicyVersionDaoClient;
import org.ow2.authzforce.core.pdp.api.policy.PolicyVersion;
import org.ow2.authzforce.rest.api.jaxrs.PolicyVersionResource;

public class PolicyVersionResourceImpl
implements PolicyVersionDaoClient,
PolicyVersionResource {
    private static final NotFoundException NOT_FOUND_EXCEPTION = new NotFoundException();
    private static final IllegalArgumentException ILLEGAL_VERSION_ARGUMENT_EXCEPTION = new IllegalArgumentException("Version for policy version resource undefined");
    private static final IllegalArgumentException ILLEGAL_VERSION_DAO_ARGUMENT_EXCEPTION = new IllegalArgumentException("Policy version DAO for policy version resource undefined");
    public static final PolicyVersionDaoClient.Factory<PolicyVersionResourceImpl> FACTORY = new PolicyVersionDaoClient.Factory<PolicyVersionResourceImpl>(){

        public PolicyVersionResourceImpl getInstance(String policyId, PolicyVersion versionId, DomainDao<?, ?> domainDAO) {
            if (versionId == null) {
                throw ILLEGAL_VERSION_ARGUMENT_EXCEPTION;
            }
            if (domainDAO == null) {
                throw ILLEGAL_VERSION_DAO_ARGUMENT_EXCEPTION;
            }
            return new PolicyVersionResourceImpl(policyId, versionId, domainDAO);
        }
    };
    private final PolicyVersion versionId;
    private final DomainDao<?, ?> domainDAO;
    private final String policyId;

    private PolicyVersionResourceImpl(String policyId, PolicyVersion versionId, DomainDao<?, ?> domainDAO) {
        assert (versionId != null && domainDAO != null);
        this.policyId = policyId;
        this.versionId = versionId;
        this.domainDAO = domainDAO;
    }

    public PolicySet getPolicyVersion() {
        PolicySet policyVersion;
        try {
            policyVersion = this.domainDAO.getPolicyVersion(this.policyId, this.versionId);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error getting policy version '" + this.versionId + "'", (Throwable)e);
        }
        if (policyVersion == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        return policyVersion;
    }

    public PolicySet deletePolicyVersion() throws IllegalArgumentException {
        PolicySet deletedPolicyVersion;
        try {
            deletedPolicyVersion = this.domainDAO.removePolicyVersion(this.policyId, this.versionId);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error removing policy version '" + this.versionId + "'", (Throwable)e);
        }
        if (deletedPolicyVersion == null) {
            throw NOT_FOUND_EXCEPTION;
        }
        return deletedPolicyVersion;
    }
}

