/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.pap.dao.flatfile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicySet;
import org.ow2.authzforce.core.pdp.api.CombiningAlgRegistry;
import org.ow2.authzforce.core.pdp.api.EnvironmentProperties;
import org.ow2.authzforce.core.pdp.api.EvaluationContext;
import org.ow2.authzforce.core.pdp.api.ExpressionFactory;
import org.ow2.authzforce.core.pdp.api.IndeterminateEvaluationException;
import org.ow2.authzforce.core.pdp.api.JaxbXACMLUtils;
import org.ow2.authzforce.core.pdp.api.PolicyVersion;
import org.ow2.authzforce.core.pdp.api.RefPolicyProvider;
import org.ow2.authzforce.core.pdp.api.RefPolicyProviderModule;
import org.ow2.authzforce.core.pdp.api.StaticRefPolicyProvider;
import org.ow2.authzforce.core.pdp.api.StaticRefPolicyProviderModule;
import org.ow2.authzforce.core.pdp.api.StaticTopLevelPolicyElementEvaluator;
import org.ow2.authzforce.core.pdp.api.TopLevelPolicyElementEvaluator;
import org.ow2.authzforce.core.pdp.api.TopLevelPolicyElementType;
import org.ow2.authzforce.core.pdp.api.VersionPatterns;
import org.ow2.authzforce.core.pdp.api.XMLUtils;
import org.ow2.authzforce.core.pdp.impl.policy.PolicyEvaluators;
import org.ow2.authzforce.core.pdp.impl.policy.PolicyVersions;
import org.ow2.authzforce.pap.dao.flatfile.FlatFileDAOUtils;
import org.ow2.authzforce.pap.dao.flatfile.xmlns.StaticFlatFileDAORefPolicyProvider;
import org.springframework.util.ResourceUtils;

public final class FlatFileDAORefPolicyProviderModule
implements StaticRefPolicyProviderModule {
    private static final IllegalArgumentException NULL_POLICY_LOCATION_PATTERN_ARGUMENT_EXCEPTION = new IllegalArgumentException("policyLocationPattern argument undefined");
    private static final IllegalArgumentException NULL_XML_CONF_ARGUMENT_EXCEPTION = new IllegalArgumentException("XML/JAXB configuration argument undefined");
    private static final IllegalArgumentException UNSUPPORTED_POLICY_REFERENCE_EXCEPTION = new IllegalArgumentException("PolicyIdReferences not supported");
    private final Path policyParentDirectory;
    private final DirectoryStream.Filter<? super Path> dirStreamFilter;
    private final JaxbXACMLUtils.XACMLParserFactory xacmlParserFactory;
    private final ExpressionFactory expressionFactory;
    private final CombiningAlgRegistry combiningAlgRegistry;
    private final int maxPolicyRefDepth;
    private final Map<String, PolicyVersions<PolicyProxy>> policySetMap = new HashMap<String, PolicyVersions<PolicyProxy>>();
    private final int policyFilenameSuffixLength;

    public static Map.Entry<Path, String> validateConf(String policyLocationPattern) throws IllegalArgumentException {
        Path policyParentDirectory;
        if (policyLocationPattern == null) {
            throw NULL_POLICY_LOCATION_PATTERN_ARGUMENT_EXCEPTION;
        }
        int index = policyLocationPattern.indexOf("/*");
        if (index == -1) {
            throw new IllegalArgumentException("Invalid policyLocationPattern in refPolicyProvider configuration: " + policyLocationPattern + ": '/*' not found");
        }
        String prefix = policyLocationPattern.substring(0, index);
        try {
            policyParentDirectory = ResourceUtils.getFile((String)prefix).toPath();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Invalid policy directory path in refPolicyProvider/policyLocationPattern (prefix before '/*'): " + policyLocationPattern, e);
        }
        String suffix = policyLocationPattern.substring(index + 2);
        return new AbstractMap.SimpleImmutableEntry<Path, String>(policyParentDirectory, suffix);
    }

    private FlatFileDAORefPolicyProviderModule(Path policyParentDirectory, String suffix, JaxbXACMLUtils.XACMLParserFactory xacmlParserFactory, ExpressionFactory expressionFactory, CombiningAlgRegistry combiningAlgRegistry, int maxPolicySetRefDepth) {
        assert (policyParentDirectory != null);
        assert (xacmlParserFactory != null);
        assert (expressionFactory != null);
        assert (combiningAlgRegistry != null);
        FlatFileDAOUtils.checkFile("RefPolicyProvider's policy directory", policyParentDirectory, true, false);
        this.policyParentDirectory = policyParentDirectory;
        this.dirStreamFilter = new FlatFileDAOUtils.SuffixMatchingDirectoryStreamFilter(suffix);
        this.policyFilenameSuffixLength = suffix.length();
        this.xacmlParserFactory = xacmlParserFactory;
        this.expressionFactory = expressionFactory;
        this.combiningAlgRegistry = combiningAlgRegistry;
        this.maxPolicyRefDepth = maxPolicySetRefDepth;
    }

    public StaticTopLevelPolicyElementEvaluator get(TopLevelPolicyElementType policyType, String id, VersionPatterns versionPatterns, Deque<String> ancestorPolicyRefChain) throws IndeterminateEvaluationException {
        StaticTopLevelPolicyElementEvaluator policyEvaluator;
        PolicyVersions newPolicyVersions;
        if (policyType == TopLevelPolicyElementType.POLICY) {
            throw UNSUPPORTED_POLICY_REFERENCE_EXCEPTION;
        }
        Deque newPolicyRefChain = RefPolicyProvider.Utils.appendAndCheckPolicyRefChain(ancestorPolicyRefChain, Collections.singletonList(id), (int)this.maxPolicyRefDepth);
        PolicyVersions oldPolicyVersions = this.policySetMap.get(id);
        if (oldPolicyVersions == null) {
            newPolicyVersions = new PolicyVersions();
            String policyDirname = FlatFileDAOUtils.base64UrlEncode(id);
            Path policyFile = this.policyParentDirectory.resolve(policyDirname);
            try (DirectoryStream<Path> policyDirStream = Files.newDirectoryStream(policyFile, this.dirStreamFilter);){
                for (Path file : policyDirStream) {
                    newPolicyVersions.put(new PolicyVersion(this.getVersion(file)), (Object)new PolicyProxy(file));
                }
            }
            catch (IOException e) {
                throw new IndeterminateEvaluationException("Error resolving policy reference: PolicySet '" + id + "' not available", "urn:oasis:names:tc:xacml:1.0:status:processing-error", (Throwable)e);
            }
            this.policySetMap.put(id, (PolicyVersions<PolicyProxy>)newPolicyVersions);
        } else {
            newPolicyVersions = oldPolicyVersions;
        }
        Map.Entry policyEntry = newPolicyVersions.getLatest(versionPatterns);
        if (policyEntry == null) {
            return null;
        }
        int refChainLenBefore = newPolicyRefChain.size();
        try {
            policyEvaluator = ((PolicyProxy)policyEntry.getValue()).getEvaluator(newPolicyRefChain);
        }
        catch (IndeterminateEvaluationException e) {
            PolicyVersion version = (PolicyVersion)policyEntry.getKey();
            throw new IndeterminateEvaluationException("Matched PolicySet '" + id + "' (version " + version + ") is invalid or its content is unavailable", "urn:oasis:names:tc:xacml:1.0:status:processing-error", (Throwable)e);
        }
        List resultPolicyLongestRefChain = policyEvaluator.getExtraPolicyMetadata().getLongestPolicyRefChain();
        if (resultPolicyLongestRefChain != null && !resultPolicyLongestRefChain.isEmpty() && newPolicyRefChain.size() == refChainLenBefore) {
            RefPolicyProvider.Utils.appendAndCheckPolicyRefChain((Deque)newPolicyRefChain, (List)resultPolicyLongestRefChain, (int)this.maxPolicyRefDepth);
        }
        return policyEvaluator;
    }

    public TopLevelPolicyElementEvaluator get(TopLevelPolicyElementType policyType, String policyId, VersionPatterns policyVersionConstraints, Deque<String> policySetRefChain, EvaluationContext evaluationCtx) throws IllegalArgumentException, IndeterminateEvaluationException {
        return this.get(policyType, policyId, policyVersionConstraints, policySetRefChain);
    }

    private String getVersion(Path file) throws IOException {
        assert (file != null);
        Path fileName = file.getFileName();
        if (fileName == null) {
            throw new IOException("Invalid policy version file path: " + file);
        }
        String filename = fileName.toString();
        return filename.substring(0, filename.length() - this.policyFilenameSuffixLength);
    }

    public void close() throws IOException {
        this.policySetMap.clear();
    }

    private class PolicyProxy {
        private final Path policyFile;
        private StaticTopLevelPolicyElementEvaluator policyEvaluator = null;

        private PolicyProxy(Path policyFile) {
            assert (policyFile != null);
            this.policyFile = policyFile;
        }

        private StaticTopLevelPolicyElementEvaluator getEvaluator(Deque<String> policySetRefChain) throws IndeterminateEvaluationException {
            assert (policySetRefChain != null);
            if (this.policyEvaluator == null) {
                Object jaxbPolicyOrPolicySetObj;
                XMLUtils.NamespaceFilteringParser xacmlParser;
                URL policyURL;
                try {
                    policyURL = this.policyFile.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IndeterminateEvaluationException("Failed to get Policy(Set) XML document from policy file: " + this.policyFile, "urn:oasis:names:tc:xacml:1.0:status:processing-error", (Throwable)e);
                }
                try {
                    xacmlParser = FlatFileDAORefPolicyProviderModule.this.xacmlParserFactory.getInstance();
                    jaxbPolicyOrPolicySetObj = xacmlParser.parse(policyURL);
                }
                catch (JAXBException e) {
                    throw new IndeterminateEvaluationException("Failed to unmarshall Policy(Set) XML document from policy location: " + policyURL, "urn:oasis:names:tc:xacml:1.0:status:processing-error", (Throwable)e);
                }
                if (!(jaxbPolicyOrPolicySetObj instanceof PolicySet)) {
                    throw new IndeterminateEvaluationException("Unexpected/unsupported element found as root of the XML document at policy location '" + policyURL + "': " + jaxbPolicyOrPolicySetObj.getClass().getSimpleName(), "urn:oasis:names:tc:xacml:1.0:status:processing-error");
                }
                PolicySet jaxbPolicySet = (PolicySet)jaxbPolicyOrPolicySetObj;
                try {
                    this.policyEvaluator = PolicyEvaluators.getInstanceStatic((PolicySet)jaxbPolicySet, null, (Map)xacmlParser.getNamespacePrefixUriMap(), (ExpressionFactory)FlatFileDAORefPolicyProviderModule.this.expressionFactory, (CombiningAlgRegistry)FlatFileDAORefPolicyProviderModule.this.combiningAlgRegistry, (StaticRefPolicyProvider)FlatFileDAORefPolicyProviderModule.this, policySetRefChain);
                }
                catch (IllegalArgumentException e) {
                    throw new IndeterminateEvaluationException("Invalid PolicySet in file: " + this.policyFile, "urn:oasis:names:tc:xacml:1.0:status:processing-error", (Throwable)e);
                }
            }
            return this.policyEvaluator;
        }
    }

    public static class Factory
    extends RefPolicyProviderModule.Factory<StaticFlatFileDAORefPolicyProvider> {
        private static final IllegalArgumentException ILLEGAL_COMBINING_ALG_REGISTRY_ARGUMENT_EXCEPTION = new IllegalArgumentException("Undefined CombiningAlgorithm registry");
        private static final IllegalArgumentException ILLEGAL_EXPRESSION_FACTORY_ARGUMENT_EXCEPTION = new IllegalArgumentException("Undefined Expression factory");
        private static final IllegalArgumentException ILLEGAL_XACML_PARSER_FACTORY_ARGUMENT_EXCEPTION = new IllegalArgumentException("Undefined XACML parser factory");

        public RefPolicyProviderModule getInstance(StaticFlatFileDAORefPolicyProvider conf, JaxbXACMLUtils.XACMLParserFactory xacmlParserFactory, int maxPolicySetRefDepth, ExpressionFactory expressionFactory, CombiningAlgRegistry combiningAlgRegistry, EnvironmentProperties environmentProperties) throws IllegalArgumentException {
            if (conf == null) {
                throw NULL_XML_CONF_ARGUMENT_EXCEPTION;
            }
            if (xacmlParserFactory == null) {
                throw ILLEGAL_XACML_PARSER_FACTORY_ARGUMENT_EXCEPTION;
            }
            if (expressionFactory == null) {
                throw ILLEGAL_EXPRESSION_FACTORY_ARGUMENT_EXCEPTION;
            }
            if (combiningAlgRegistry == null) {
                throw ILLEGAL_COMBINING_ALG_REGISTRY_ARGUMENT_EXCEPTION;
            }
            String policyLocationPattern = environmentProperties.replacePlaceholders(conf.getPolicyLocationPattern());
            Map.Entry<Path, String> result = FlatFileDAORefPolicyProviderModule.validateConf(policyLocationPattern);
            return new FlatFileDAORefPolicyProviderModule(result.getKey(), result.getValue(), xacmlParserFactory, expressionFactory, combiningAlgRegistry, maxPolicySetRefDepth);
        }

        public Class<StaticFlatFileDAORefPolicyProvider> getJaxbClass() {
            return StaticFlatFileDAORefPolicyProvider.class;
        }
    }
}

