/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.webapp;

import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.ow2.authzforce.jaxrs.util.JaxbErrorMessage;
import org.ow2.authzforce.webapp.JsonRiCxfJaxrsProvider;
import org.ow2.authzforce.xacml.json.model.SpringBasedJsonSchemaClient;
import org.springframework.util.ResourceUtils;

@Provider
public final class JsonRiCxfJaxrsProvider<T>
extends AbstractConfigurableProvider
implements MessageBodyReader<JSONObject>,
MessageBodyWriter<T> {
    private static final BadRequestException EMPTY_JSON_OBJECT_BAD_REQUEST_EXCEPTION = new BadRequestException("object cannot be empty");
    private static final JsonObjectFactory DEFAULT_JSON_TOKENER_FACTORY = entityStream -> new JSONObject(new JSONTokener(entityStream));
    private final JsonObjectFactory jsonObjectFactory;

    public static Schema loadSchema(String schemaLocation) throws IOException {
        File schemaFile = ResourceUtils.getFile((String)schemaLocation);
        try (BufferedReader reader = Files.newBufferedReader(schemaFile.toPath(), StandardCharsets.UTF_8);){
            JSONObject rawSchema = new JSONObject(new JSONTokener((Reader)reader));
            Schema schema = SchemaLoader.builder().schemaJson(rawSchema).resolutionScope("file://" + schemaFile.getParent() + File.separator).schemaClient((SchemaClient)new SpringBasedJsonSchemaClient()).build().load().build();
            return schema;
        }
    }

    public JsonRiCxfJaxrsProvider() {
        this.jsonObjectFactory = DEFAULT_JSON_TOKENER_FACTORY;
    }

    public JsonRiCxfJaxrsProvider(Schema schema) {
        this.jsonObjectFactory = schema == null ? DEFAULT_JSON_TOKENER_FACTORY : new /* Unavailable Anonymous Inner Class!! */;
    }

    public JsonRiCxfJaxrsProvider(Map<String, Schema> schemasByPropertyName) {
        this.jsonObjectFactory = schemasByPropertyName == null || schemasByPropertyName.isEmpty() ? DEFAULT_JSON_TOKENER_FACTORY : new /* Unavailable Anonymous Inner Class!! */;
    }

    @ConstructorProperties(value={"schema", "maxJsonStringSize", "maxNumOfImmediateChildren", "maxDepth"})
    public JsonRiCxfJaxrsProvider(Schema schema, int maxJsonStringSize, int maxNumOfImmediateChildren, int maxDepth) {
        this.jsonObjectFactory = maxJsonStringSize <= 0 || maxNumOfImmediateChildren <= 0 || maxDepth <= 0 ? new /* Unavailable Anonymous Inner Class!! */ : (schema == null ? new LimitsCheckingJsonObjectFactory(maxJsonStringSize, maxNumOfImmediateChildren, maxDepth) : new /* Unavailable Anonymous Inner Class!! */);
    }

    @ConstructorProperties(value={"schemasByRootKey", "maxJsonStringSize", "maxNumOfImmediateChildren", "maxDepth"})
    public JsonRiCxfJaxrsProvider(Map<String, Schema> schemasByRootKey, int maxJsonStringSize, int maxNumOfImmediateChildren, int maxDepth) {
        this.jsonObjectFactory = maxJsonStringSize <= 0 || maxNumOfImmediateChildren <= 0 || maxDepth <= 0 ? (schemasByRootKey == null || schemasByRootKey.isEmpty() ? DEFAULT_JSON_TOKENER_FACTORY : new /* Unavailable Anonymous Inner Class!! */) : (schemasByRootKey == null || schemasByRootKey.isEmpty() ? new LimitsCheckingJsonObjectFactory(maxJsonStringSize, maxNumOfImmediateChildren, maxDepth) : new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JSONObject.class.isAssignableFrom(type) || type == JaxbErrorMessage.class;
    }

    public long getSize(T o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(T o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JSONObject json;
        if (o instanceof JSONObject) {
            json = (JSONObject)o;
        } else if (o instanceof JaxbErrorMessage) {
            JaxbErrorMessage errMsg = (JaxbErrorMessage)o;
            json = new JSONObject(Collections.singletonMap("error", errMsg.getMessage()));
        } else {
            throw new RuntimeException("Unexpected input object class to MessageBodyWriter '" + this.getClass() + "': " + o.getClass());
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(entityStream, StandardCharsets.UTF_8);){
            json.write((Writer)writer);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JSONObject.class.isAssignableFrom(type);
    }

    public JSONObject readFrom(Class<JSONObject> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        try {
            return this.jsonObjectFactory.getInstance(entityStream);
        }
        catch (JSONException e) {
            throw new BadRequestException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ClientErrorException(Response.Status.REQUEST_ENTITY_TOO_LARGE, (Throwable)e);
        }
    }
}

