/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.webapp;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.everit.json.schema.ValidationException;
import org.ow2.authzforce.jaxrs.util.JaxbErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandlerInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandlerInterceptor.class);
    private static final String INTERNAL_SERVER_ERROR_MSG = "Internal Server error. Retry later or contact the administrator.";
    private static final RuntimeException INTERNAL_SERVER_ERROR = new RuntimeException("Internal Server error. Retry later or contact the administrator.");
    private static final JAXBContext AUTHZ_API_JAXB_CONTEXT;

    public ErrorHandlerInterceptor() {
        super("post-logical");
    }

    public void handleMessage(Message message) throws Fault {
        Exception ex = (Exception)message.getContent(Exception.class);
        if (ex != null) {
            Object errMsg;
            int respStatus;
            LOGGER.error("Fatal CXF service error", (Throwable)ex);
            HttpServletResponse response = (HttpServletResponse)message.getExchange().getInMessage().get((Object)"HTTP.RESPONSE");
            Throwable cause = ex.getCause();
            if (cause instanceof IllegalArgumentException || cause instanceof ValidationException) {
                respStatus = 400;
                Throwable causeBehind = cause.getCause();
                errMsg = cause.getMessage() + (String)(causeBehind == null ? "" : ": " + causeBehind.getMessage());
            } else {
                respStatus = 500;
                errMsg = INTERNAL_SERVER_ERROR_MSG;
            }
            JaxbErrorMessage errorEntity = new JaxbErrorMessage((String)errMsg, null);
            response.setStatus(respStatus);
            try (ServletOutputStream out = response.getOutputStream();){
                Marshaller marshaller = AUTHZ_API_JAXB_CONTEXT.createMarshaller();
                marshaller.marshal((Object)errorEntity, (OutputStream)out);
                out.flush();
            }
            catch (IOException | IllegalStateException | JAXBException e) {
                LOGGER.error("Failed to override service response", e);
                throw INTERNAL_SERVER_ERROR;
            }
            message.getInterceptorChain().abort();
        }
    }

    static {
        try {
            AUTHZ_API_JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{JaxbErrorMessage.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to initialize Authorization API schema's JAXB context for marshalling Error elements", e);
        }
    }
}

