/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.webapp;

import ch.qos.logback.core.joran.spi.JoranException;
import jakarta.servlet.ServletContext;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import org.ow2.authzforce.webapp.LogbackConfigurer;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.ServletContextPropertyUtils;
import org.springframework.web.util.WebUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebLogbackConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "logbackConfigLocation";
    public static final String EXPOSE_WEB_APP_ROOT_PARAM = "logbackExposeWebAppRoot";

    private WebLogbackConfigurer() {
    }

    public static void initLogging(ServletContext servletContext) {
        String locationParam;
        if (WebLogbackConfigurer.exposeWebAppRoot((ServletContext)servletContext)) {
            WebUtils.setWebAppRootSystemProperty((ServletContext)servletContext);
        }
        if ((locationParam = servletContext.getInitParameter("logbackConfigLocation")) != null) {
            for (String location : StringUtils.tokenizeToStringArray((String)locationParam, (String)",; \t\n")) {
                try {
                    location = ServletContextPropertyUtils.resolvePlaceholders((String)location, (ServletContext)servletContext);
                    if (!ResourceUtils.isUrl((String)location)) {
                        location = WebUtils.getRealPath((ServletContext)servletContext, (String)location);
                    }
                    servletContext.log("Initializing Logback from [" + location + "]");
                    LogbackConfigurer.initLogging((String)location);
                    break;
                }
                catch (FileNotFoundException ex) {
                    servletContext.log("No logback configuration file found at [" + location + "]");
                }
                catch (JoranException e) {
                    throw new RuntimeException("Unexpected error while configuring logback", e);
                }
            }
        }
        try {
            Method install;
            Class julBridge = ClassUtils.forName((String)"org.slf4j.bridge.SLF4JBridgeHandler", (ClassLoader)ClassUtils.getDefaultClassLoader());
            Method removeHandlers = ReflectionUtils.findMethod((Class)julBridge, (String)"removeHandlersForRootLogger");
            if (removeHandlers != null) {
                servletContext.log("Removing all previous handlers for JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)removeHandlers, null);
            }
            if ((install = ReflectionUtils.findMethod((Class)julBridge, (String)"install")) != null) {
                servletContext.log("Installing JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)install, null);
            }
        }
        catch (ClassNotFoundException ignored) {
            servletContext.log("JUL to SLF4J bridge is not available on the classpath");
        }
    }

    public static void shutdownLogging(ServletContext servletContext) {
        try {
            Class julBridge = ClassUtils.forName((String)"org.slf4j.bridge.SLF4JBridgeHandler", (ClassLoader)ClassUtils.getDefaultClassLoader());
            Method uninstall = ReflectionUtils.findMethod((Class)julBridge, (String)"uninstall");
            if (uninstall != null) {
                servletContext.log("Uninstalling JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)uninstall, null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            servletContext.log("Shutting down Logback");
            LogbackConfigurer.shutdownLogging();
        }
        finally {
            if (WebLogbackConfigurer.exposeWebAppRoot((ServletContext)servletContext)) {
                WebUtils.removeWebAppRootSystemProperty((ServletContext)servletContext);
            }
        }
    }

    private static boolean exposeWebAppRoot(ServletContext servletContext) {
        String exposeWebAppRootParam = servletContext.getInitParameter("logbackExposeWebAppRoot");
        return exposeWebAppRootParam == null || Boolean.valueOf(exposeWebAppRootParam) != false;
    }
}

