/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.webapp.org.codehaus.jettison.mapped;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.codehaus.jettison.Convention;
import org.codehaus.jettison.Node;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.mapped.TypeConverter;
import org.ow2.authzforce.webapp.org.apache.cxf.jaxrs.provider.json.utils.JSONUtils;
import org.ow2.authzforce.webapp.org.codehaus.jettison.mapped.Configuration;
import org.ow2.authzforce.webapp.org.codehaus.jettison.mapped.MappedNamespaceConvention;

public class MappedNamespaceConvention
implements Convention,
NamespaceContext {
    private static final String DOT_NAMESPACE_SEP = ".";
    private Map<String, String> xnsToJns = new HashMap();
    private final Map<String, String> jnsToXns = new HashMap();
    private List<?> attributesAsElements;
    private List<?> ignoredElements;
    private List<String> jsonAttributesAsElements;
    private boolean supressAtAttributes;
    private boolean ignoreNamespaces;
    private String attributeKey = "@";
    private TypeConverter typeConverter;
    private Set<?> primitiveArrayKeys;
    private boolean dropRootElement;
    private boolean writeNullAsString = true;
    private boolean ignoreEmptyArrayValues;
    private boolean readNullAsString;
    private boolean escapeForwardSlashAlways;
    private String jsonNamespaceSeparator;
    private Set<String> elementsAsAttributes;

    public MappedNamespaceConvention() {
        this.typeConverter = Configuration.newDefaultConverterInstance();
    }

    public MappedNamespaceConvention(Configuration config) {
        this.xnsToJns = config.getXmlToJsonNamespaces();
        this.attributesAsElements = config.getAttributesAsElements();
        this.elementsAsAttributes = config.getElementsAsAttributes();
        this.supressAtAttributes = config.isSupressAtAttributes();
        this.ignoreNamespaces = config.isIgnoreNamespaces();
        this.dropRootElement = config.isDropRootElement();
        this.attributeKey = config.getAttributeKey();
        this.primitiveArrayKeys = config.getPrimitiveArrayKeys();
        this.ignoredElements = config.getIgnoredElements();
        this.ignoreEmptyArrayValues = config.isIgnoreEmptyArrayValues();
        this.escapeForwardSlashAlways = config.isEscapeForwardSlashAlways();
        this.jsonNamespaceSeparator = config.getJsonNamespaceSeparator();
        for (Map.Entry entry : this.xnsToJns.entrySet()) {
            this.jnsToXns.put((String)entry.getValue(), (String)entry.getKey());
        }
        this.jsonAttributesAsElements = new ArrayList();
        if (this.attributesAsElements != null) {
            for (Map.Entry name : this.attributesAsElements) {
                QName q = (QName)((Object)name);
                this.jsonAttributesAsElements.add(this.createAttributeKey(q.getPrefix(), q.getNamespaceURI(), q.getLocalPart()));
            }
        }
        this.readNullAsString = config.isReadNullAsString();
        this.writeNullAsString = config.isWriteNullAsString();
        this.typeConverter = config.getTypeConverter();
        if (!this.writeNullAsString && this.typeConverter != null) {
            this.typeConverter = new NullStringConverter(this.typeConverter);
        }
    }

    public void processAttributesAndNamespaces(Node n, JSONObject object) throws JSONException {
        Iterator itr = object.keys();
        while (itr.hasNext()) {
            Object o;
            String k = (String)itr.next();
            if (this.supressAtAttributes) {
                if (k.startsWith(this.attributeKey)) {
                    k = k.substring(1);
                }
                if (null == this.jsonAttributesAsElements) {
                    this.jsonAttributesAsElements = new ArrayList();
                }
                if (!this.jsonAttributesAsElements.contains(k)) {
                    this.jsonAttributesAsElements.add(k);
                }
            }
            if (k.startsWith(this.attributeKey)) {
                o = object.opt(k);
                k = k.substring(1);
            } else {
                o = this.elementsAsAttributes.contains(k) ? object.opt(k) : null;
            }
            if (o != null) {
                if (k.equals("xmlns")) {
                    if (o instanceof JSONObject) {
                        JSONObject jo = (JSONObject)o;
                        Iterator pitr = jo.keys();
                        while (pitr.hasNext()) {
                            String prefix = (String)pitr.next();
                            String uri = jo.getString(prefix);
                            n.setNamespace(prefix, uri);
                        }
                    }
                } else {
                    QName name;
                    String strValue = o.toString();
                    if (k.contains(this.getNamespaceSeparator())) {
                        name = this.createQName(k, n);
                        if (strValue != null && name.equals(JSONUtils.XSI_TYPE_QNAME)) {
                            int nsSepPosition = strValue.lastIndexOf(this.getNamespaceSeparator());
                            String jns = nsSepPosition == -1 ? "" : strValue.substring(0, nsSepPosition);
                            String xns = this.getNamespaceURI(jns);
                            if (xns == null) {
                                throw new JSONException("Unknown XML namespace for prefix used in @xsi:type value: '" + jns + "'");
                            }
                            n.setNamespace(jns, xns);
                        }
                    } else {
                        name = new QName("", k);
                    }
                    n.setAttribute(name, strValue);
                }
                itr.remove();
                continue;
            }
            int dot = k.lastIndexOf(this.getNamespaceSeparator());
            if (dot == -1) continue;
            String jns = k.substring(0, dot);
            String xns = this.getNamespaceURI(jns);
            n.setNamespace("", xns);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.ignoreNamespaces) {
            return "";
        }
        return (String)this.jnsToXns.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (this.ignoreNamespaces) {
            return "";
        }
        return (String)this.xnsToJns.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String arg0) {
        if (this.ignoreNamespaces) {
            return Collections.emptyIterator();
        }
        return this.jnsToXns.keySet().iterator();
    }

    public QName createQName(String rootName, Node node) {
        return this.createQName(rootName);
    }

    private void readAttribute(Node n, String k, JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            this.readAttribute(n, k, array.getString(i));
        }
    }

    private void readAttribute(Node n, String name, String value) {
        QName qname = this.createQName(name);
        n.getAttributes().put(qname, value);
    }

    private QName createQName(String name) {
        String nsSeparator = this.getNamespaceSeparator();
        int dot = name.lastIndexOf(nsSeparator);
        String local = name;
        if (dot == -1) {
            dot = 0;
        } else {
            local = local.substring(dot + nsSeparator.length());
        }
        String jns = name.substring(0, dot);
        String xns = this.getNamespaceURI(jns);
        QName qname = xns == null ? new QName(name) : new QName(xns, local);
        return qname;
    }

    public String createAttributeKey(String p, String ns, String local) {
        String jns;
        StringBuilder builder = new StringBuilder();
        if (!this.supressAtAttributes) {
            builder.append(this.attributeKey);
        }
        if ((jns = this.getJSONNamespace(p, ns)).length() != 0) {
            builder.append(jns).append(this.getNamespaceSeparator());
        }
        return builder.append(local).toString();
    }

    private String getJSONNamespace(String providedPrefix, String ns) {
        if (ns == null || ns.length() == 0 || this.ignoreNamespaces) {
            return "";
        }
        String jns = (String)this.xnsToJns.get(ns);
        if (jns == null && providedPrefix != null && providedPrefix.length() > 0) {
            jns = providedPrefix;
        }
        if (jns == null) {
            throw new IllegalStateException("Invalid JSON namespace: " + ns);
        }
        return jns;
    }

    public String createKey(String p, String ns, String local) {
        StringBuilder builder = new StringBuilder();
        String jns = this.getJSONNamespace(p, ns);
        if (jns.length() != 0) {
            builder.append(jns).append(this.getNamespaceSeparator());
        }
        return builder.append(local).toString();
    }

    public boolean isElement(String p, String ns, String local) {
        if (this.attributesAsElements == null) {
            return false;
        }
        for (Object name : this.attributesAsElements) {
            QName q = (QName)name;
            if (!q.getNamespaceURI().equals(ns) || !q.getLocalPart().equals(local)) continue;
            return true;
        }
        return false;
    }

    public Object convertToJSONPrimitive(String text) {
        return this.typeConverter.convertToJSONPrimitive(text);
    }

    public Set<?> getPrimitiveArrayKeys() {
        return this.primitiveArrayKeys;
    }

    public boolean isDropRootElement() {
        return this.dropRootElement;
    }

    public List<?> getIgnoredElements() {
        return this.ignoredElements;
    }

    public boolean isWriteNullAsString() {
        return this.writeNullAsString;
    }

    public boolean isReadNullAsString() {
        return this.readNullAsString;
    }

    public boolean isIgnoreEmptyArrayValues() {
        return this.ignoreEmptyArrayValues;
    }

    public boolean isEscapeForwardSlashAlways() {
        return this.escapeForwardSlashAlways;
    }

    public void setEscapeForwardSlashAlways(boolean escapeForwardSlash) {
        this.escapeForwardSlashAlways = escapeForwardSlash;
    }

    public String getNamespaceSeparator() {
        return this.jsonNamespaceSeparator == null ? DOT_NAMESPACE_SEP : this.jsonNamespaceSeparator;
    }
}

