/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.webapp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (Error ex) {
            int finalStatusCode = ex instanceof NoSuchMethodError ? 400 : 500;
            HttpServletResponse httpResp = (HttpServletResponse)response;
            LOGGER.error("Serious error content hidden from client", (Throwable)ex);
            httpResp.sendError(finalStatusCode);
        }
    }

    public void destroy() {
    }
}

