/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.webapp;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.NameChecker;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;
import org.apache.cxf.jaxrs.provider.json.utils.JSONUtils;
import org.apache.cxf.staxutils.DepthRestrictingStreamReader;
import org.apache.cxf.staxutils.DocumentDepthProperties;
import org.apache.cxf.staxutils.transform.TransformUtils;
import org.codehaus.jettison.mapped.Configuration;
import org.ow2.authzforce.webapp.JsonJaxrsProvider;
import org.ow2.authzforce.webapp.org.apache.cxf.jaxrs.provider.json.utils.JettisonReader;

public final class JsonJaxrsProvider<T>
extends JSONProvider<T> {
    private static final UnsupportedOperationException UNSUPPORTED_DEPTH_PROPERTIES_WITH_BADGERFISH_EXCEPTION = new UnsupportedOperationException("'depthProperties' property not supported if convention = 'badgerfish'");
    private int maxStringLength = -1;
    private static final String MAPPED_CONVENTION = "mapped";
    private static final String BADGER_FISH_CONVENTION = "badgerfish";
    private String convention = "mapped";
    private Map<String, String> namespaceMap = null;
    private String namespaceSeparator;
    private List<String> primitiveArrayKeys;

    public void setMaxStringLength(int value) {
        this.maxStringLength = value;
    }

    public void setConvention(String value) {
        super.setConvention(value);
        this.convention = value;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        super.setNamespaceMap(namespaceMap);
        if (namespaceMap != null) {
            for (Map.Entry<String, String> nsToPrefix : namespaceMap.entrySet()) {
                String nsURI = nsToPrefix.getKey();
                if (!StandardURIChecker.getInstance().isValidURI((CharSequence)nsURI)) {
                    throw new IllegalArgumentException("Invalid namespace URI in one of namespaceMap keys: " + nsURI);
                }
                String nsPrefix = nsToPrefix.getValue();
                if (NameChecker.isValidNCName((CharSequence)nsPrefix)) continue;
                throw new IllegalArgumentException("Invalid namespace prefix in one of namespaceMap values: " + nsPrefix);
            }
            HashMap<String, String> mutableMap = new HashMap<String, String>(namespaceMap);
            mutableMap.putIfAbsent("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            this.namespaceMap = Collections.unmodifiableMap(mutableMap);
        }
    }

    public void setPrimitiveArrayKeys(List<String> primitiveArrayKeys) {
        super.setPrimitiveArrayKeys(primitiveArrayKeys);
        this.primitiveArrayKeys = primitiveArrayKeys;
    }

    public void setNamespaceSeparator(String namespaceSeparator) {
        super.setNamespaceSeparator(namespaceSeparator);
        this.namespaceSeparator = namespaceSeparator;
    }

    protected XMLStreamReader createDepthReaderIfNeeded(XMLStreamReader reader, InputStream is) {
        DocumentDepthProperties props = this.getDepthProperties();
        if (props != null && props.isEffective()) {
            reader = TransformUtils.createNewReaderIfNeeded((XMLStreamReader)reader, (InputStream)is);
            reader = new DepthRestrictingStreamReader(reader, props);
        }
        return reader;
    }

    private XMLStreamReader createStreamReader(InputStream is, String enc) throws Exception {
        Configuration conf = new Configuration(this.namespaceMap);
        if (this.namespaceSeparator != null) {
            conf.setJsonNamespaceSeparator(this.namespaceSeparator);
        }
        if (this.primitiveArrayKeys != null) {
            conf.setPrimitiveArrayKeys(new HashSet(this.primitiveArrayKeys));
        }
        HardenedJettisonMappedReaderFactory factory = this.maxStringLength > 0 ? new HardenedJettisonMappedReaderFactory(conf, this.maxStringLength, null) : new MappedXMLInputFactoryOverride(conf, null);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        return new JettisonReader(this.namespaceMap, factory.createXMLStreamReader(is, enc));
    }

    protected XMLStreamReader createReader(Class<?> type, InputStream is, String enc) throws Exception {
        XMLStreamReader reader = null;
        DocumentDepthProperties depthProps = this.getDepthProperties();
        if (BADGER_FISH_CONVENTION.equals(this.convention)) {
            if (depthProps != null) {
                throw UNSUPPORTED_DEPTH_PROPERTIES_WITH_BADGERFISH_EXCEPTION;
            }
            reader = JSONUtils.createBadgerFishReader((InputStream)is, (String)enc);
        } else {
            reader = this.createStreamReader(is, enc);
        }
        reader = this.createTransformReaderIfNeeded(reader, is);
        reader = this.createDepthReaderIfNeeded(reader, is);
        return reader;
    }
}

