/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.authzforce.webapp;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.json.JSONException;
import org.json.JSONObject;
import org.ow2.authzforce.jaxrs.util.JaxbErrorMessage;
import org.ow2.authzforce.webapp.JsonRiCxfJaxrsProvider;

@Provider
public final class JsonRiCxfJaxrsProvider<T>
extends AbstractConfigurableProvider
implements MessageBodyReader<JSONObject>,
MessageBodyWriter<T> {
    private static final JSONObjectFactory DEFAULT_JSON_TOKENER_FACTORY = new /* Unavailable Anonymous Inner Class!! */;
    private final JSONObjectFactory jsonObjectFactory;

    public JsonRiCxfJaxrsProvider() {
        this.jsonObjectFactory = DEFAULT_JSON_TOKENER_FACTORY;
    }

    @ConstructorProperties(value={"maxJsonStringSize", "maxNumOfImmediateChildren", "maxDepth"})
    public JsonRiCxfJaxrsProvider(int maxJsonStringSize, int maxNumOfImmediateChildren, int maxDepth) {
        this.jsonObjectFactory = maxJsonStringSize <= 0 || maxNumOfImmediateChildren <= 0 || maxDepth <= 0 ? DEFAULT_JSON_TOKENER_FACTORY : new /* Unavailable Anonymous Inner Class!! */;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JSONObject.class.isAssignableFrom(type) || type == JaxbErrorMessage.class;
    }

    public long getSize(T o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(T o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JSONObject json;
        if (o instanceof JSONObject) {
            json = (JSONObject)o;
        } else if (o instanceof JaxbErrorMessage) {
            JaxbErrorMessage errMsg = (JaxbErrorMessage)o;
            json = new JSONObject(Collections.singletonMap("error", errMsg.getMessage()));
        } else {
            throw new RuntimeException("Unexpected input object class to MessageBodyWriter '" + this.getClass() + "': " + o.getClass());
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(entityStream, StandardCharsets.UTF_8);){
            json.write((Writer)writer);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JSONObject.class.isAssignableFrom(type);
    }

    public JSONObject readFrom(Class<JSONObject> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return this.jsonObjectFactory.getInstance(entityStream);
        }
        catch (JSONException e) {
            throw new BadRequestException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ClientErrorException(Response.Status.REQUEST_ENTITY_TOO_LARGE, (Throwable)e);
        }
    }
}

