/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.message.Attachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyAttachmentCollection
implements Collection<Attachment> {
    private AttachmentDeserializer deserializer;
    private final List<Attachment> attachments = new ArrayList<Attachment>();

    public LazyAttachmentCollection(AttachmentDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    public List<Attachment> getLoadedAttachments() {
        return this.attachments;
    }

    private void loadAll() {
        try {
            AttachmentImpl a = this.deserializer.readNext();
            while (a != null) {
                this.attachments.add(a);
                a = this.deserializer.readNext();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<Attachment> iterator() {
        return new Iterator<Attachment>(){
            int current;

            @Override
            public boolean hasNext() {
                if (LazyAttachmentCollection.this.attachments.size() > this.current) {
                    return true;
                }
                try {
                    AttachmentImpl a = LazyAttachmentCollection.this.deserializer.readNext();
                    if (a == null) {
                        return false;
                    }
                    LazyAttachmentCollection.this.attachments.add(a);
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Attachment next() {
                Attachment a = (Attachment)LazyAttachmentCollection.this.attachments.get(this.current);
                ++this.current;
                return a;
            }

            @Override
            public void remove() {
                LazyAttachmentCollection.this.attachments.remove(this.current);
            }
        };
    }

    @Override
    public int size() {
        this.loadAll();
        return this.attachments.size();
    }

    @Override
    public boolean add(Attachment arg0) {
        return this.attachments.add(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends Attachment> arg0) {
        return this.attachments.addAll(arg0);
    }

    @Override
    public void clear() {
        this.attachments.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.attachments.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.attachments.containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.attachments.isEmpty();
    }

    @Override
    public boolean remove(Object arg0) {
        return this.attachments.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.attachments.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.attachments.retainAll(arg0);
    }

    @Override
    public Object[] toArray() {
        this.loadAll();
        return this.attachments.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        this.loadAll();
        return this.attachments.toArray(arg0);
    }
}

