/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.xml;

import javax.xml.namespace.QName;
import org.apache.cxf.aegis.xml.MessageWriter;

public abstract class AbstractMessageWriter
implements MessageWriter {
    public void writeXsiType(QName type) {
        String value;
        String prefix = this.getPrefixForNamespace(type.getNamespaceURI(), type.getPrefix());
        if (prefix != null && prefix.length() > 0) {
            StringBuffer sb = new StringBuffer(prefix.length() + 1 + type.getLocalPart().length());
            sb.append(prefix);
            sb.append(':');
            sb.append(type.getLocalPart());
            value = sb.toString();
        } else {
            value = type.getLocalPart();
        }
        this.getAttributeWriter("type", "http://www.w3.org/2001/XMLSchema-instance").writeValue(value);
    }

    public void writeXsiNil() {
        MessageWriter attWriter = this.getAttributeWriter("nil", "http://www.w3.org/2001/XMLSchema-instance");
        attWriter.writeValue("true");
        attWriter.close();
    }

    public void writeValueAsInt(Integer i) {
        this.writeValue(i.toString());
    }

    public void writeValueAsByte(Byte b) {
        this.writeValue(b.toString());
    }

    public void writeValueAsDouble(Double d) {
        this.writeValue(d.toString());
    }

    public void writeValueAsCharacter(Character char1) {
        this.writeValue(char1.toString());
    }

    public void writeValueAsLong(Long l) {
        this.writeValue(l.toString());
    }

    public void writeValueAsFloat(Float f) {
        this.writeValue(f.toString());
    }

    public void writeValueAsBoolean(boolean b) {
        this.writeValue(b ? "true" : "false");
    }

    public void writeValueAsShort(Short s) {
        this.writeValue(s.toString());
    }
}

