/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.invoker;

import java.util.ResourceBundle;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.factory.Factory;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.invoker.AbstractInvoker;
import org.apache.cxf.service.invoker.ApplicationScopePolicy;
import org.apache.cxf.service.invoker.ScopePolicy;

public class FactoryInvoker
extends AbstractInvoker {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(FactoryInvoker.class);
    private final Factory factory;
    private final ScopePolicy scope;

    public FactoryInvoker(Factory factory, ScopePolicy scope) {
        this.factory = factory;
        this.scope = scope == null ? new ApplicationScopePolicy() : scope;
    }

    public Object getServiceObject(Exchange ex) {
        try {
            return this.getScopedFactory(ex).create();
        }
        catch (Throwable e) {
            throw new Fault(new Message("CREATE_SERVICE_OBJECT_EXC", BUNDLE, new Object[0]), e);
        }
    }

    private Factory getScopedFactory(Exchange ex) {
        return this.scope.applyScope(this.factory, ex);
    }
}

