/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class RpcDispatcherTest
extends ChannelTestBase {
    RpcDispatcher disp1;
    RpcDispatcher disp2;
    RpcDispatcher disp3;
    JChannel c1;
    JChannel c2;
    JChannel c3;
    static final int[] SIZES = new int[]{10000, 20000, 40000, 80000, 100000, 200000, 400000, 800000, 1000000, 2000000, 5000000, 10000000, 20000000};

    protected void setUp() throws Exception {
        super.setUp();
        this.c1 = this.createChannel("A");
        this.disp1 = new RpcDispatcher((Channel)this.c1, null, null, new ServerObject(1));
        this.c1.connect("demo");
        this.c2 = this.createChannel("A");
        this.disp2 = new RpcDispatcher((Channel)this.c2, null, null, new ServerObject(2));
        this.c2.connect("demo");
        this.c3 = this.createChannel("A");
        this.disp3 = new RpcDispatcher((Channel)this.c3, null, null, new ServerObject(3));
        this.c3.connect("demo");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.disp3.stop();
        this.c3.close();
        this.disp2.stop();
        this.c2.close();
        this.disp1.stop();
        this.c1.close();
    }

    public void foo() {
    }

    public void testResponseFilter() {
        RspList rsps = this.disp1.callRemoteMethods(null, "foo", null, null, 2, 10000L, false, new RspFilter(){
            int num = 0;

            public boolean isAcceptable(Object response, Address sender) {
                boolean retval = (Integer)response > 1;
                System.out.println("-- received " + response + " from " + sender + ": " + (retval ? "OK" : "NOTOK"));
                if (retval) {
                    ++this.num;
                }
                return retval;
            }

            public boolean needMoreResponses() {
                return this.num < 2;
            }
        });
        System.out.println("responses are:\n" + rsps);
        RpcDispatcherTest.assertEquals((int)3, (int)rsps.size());
        RpcDispatcherTest.assertEquals((int)2, (int)rsps.numReceived());
    }

    public void testLargeReturnValue() {
        RpcDispatcherTest.setProps(this.c1);
        RpcDispatcherTest.setProps(this.c2);
        RpcDispatcherTest.setProps(this.c3);
        for (int i = 0; i < SIZES.length; ++i) {
            this._testLargeValue(SIZES[i]);
        }
    }

    public void testLargeReturnValueUnicastCall() throws Throwable {
        RpcDispatcherTest.setProps(this.c1);
        RpcDispatcherTest.setProps(this.c2);
        RpcDispatcherTest.setProps(this.c3);
        for (int i = 0; i < SIZES.length; ++i) {
            this._testLargeValueUnicastCall(this.c1.getLocalAddress(), SIZES[i]);
        }
    }

    private static void setProps(JChannel ch) {
        Properties props1 = new Properties();
        Properties props2 = new Properties();
        props1.setProperty("frag_size", "12000");
        props2.setProperty("max_bundle_size", "14000");
        Protocol prot = ch.getProtocolStack().findProtocol("FRAG2");
        if (prot == null) {
            prot = ch.getProtocolStack().findProtocol("FRAG");
        }
        if (prot != null) {
            prot.setProperties(props1);
        }
        if ((prot = ch.getProtocolStack().getTransport()) != null) {
            prot.setProperties(props2);
        }
    }

    void _testLargeValue(int size) {
        System.out.println("\ntesting with " + size + " bytes");
        RspList rsps = this.disp1.callRemoteMethods(null, "largeReturnValue", new Object[]{size}, new Class[]{Integer.TYPE}, 2, 20000L);
        System.out.println("rsps:");
        RpcDispatcherTest.assertEquals((int)3, (int)rsps.size());
        for (Map.Entry<Address, Rsp> entry : rsps.entrySet()) {
            byte[] val = (byte[])entry.getValue().getValue();
            System.out.println(val.length + " bytes from " + entry.getValue().getSender());
            RpcDispatcherTest.assertNotNull((Object)val);
            RpcDispatcherTest.assertEquals((int)size, (int)val.length);
        }
    }

    void _testLargeValueUnicastCall(Address dst, int size) throws Throwable {
        System.out.println("\ntesting unicast call with " + size + " bytes");
        RpcDispatcherTest.assertNotNull((Object)dst);
        Object retval = this.disp1.callRemoteMethod(dst, "largeReturnValue", new Object[]{size}, new Class[]{Integer.TYPE}, 2, 20000L);
        byte[] val = (byte[])retval;
        System.out.println("rsp: " + val.length + " bytes");
        RpcDispatcherTest.assertNotNull((Object)val);
        RpcDispatcherTest.assertEquals((int)size, (int)val.length);
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherTest.suite());
    }

    private static class ServerObject {
        int i;

        public ServerObject(int i) {
            this.i = i;
        }

        public int foo() {
            return this.i;
        }

        public static byte[] largeReturnValue(int size) {
            return new byte[size];
        }
    }
}

