/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.FD;
import org.jgroups.protocols.MERGE2;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class DiscardTest2
extends ChannelTestBase {
    JChannel ch1;
    JChannel ch2;
    JChannel ch3;

    protected void tearDown() throws Exception {
        DiscardTest2.closeChannel(this.ch3, this.ch2, this.ch1);
        super.tearDown();
    }

    public void testHangOfParticipant() throws Exception {
        this.ch1 = this.createChannel();
        this.ch2 = this.createChannel();
        DiscardTest2.addDiscardProtocol(this.ch1);
        DiscardTest2.modiftFDAndMergeSettings(this.ch1);
        DiscardTest2.modiftFDAndMergeSettings(this.ch2);
        this.ch1.connect("x");
        this.ch2.connect("x");
        View view = this.ch2.getView();
        DiscardTest2.assertEquals((int)2, (int)view.size());
        System.out.println("view is " + view + "\nSuspending ch1");
        DISCARD discard = (DISCARD)this.ch1.getProtocolStack().findProtocol("DISCARD");
        discard.setDiscardAll(true);
        Util.sleep(8000L);
        view = this.ch2.getView();
        System.out.println("view is " + view);
        DiscardTest2.assertEquals((int)1, (int)view.size());
        view = this.ch1.getView();
        DiscardTest2.assertEquals((int)1, (int)view.size());
        System.out.println("Resuming ch1");
        discard.setDiscardAll(false);
        Util.sleep(3000L);
        for (int i = 0; i < 10; ++i) {
            view = this.ch2.getView();
            System.out.println("view after resuming: " + view);
            if (view.size() == 2) break;
            Util.sleep(1000L);
        }
        DiscardTest2.assertEquals((int)2, (int)view.size());
    }

    private static void closeChannel(Channel ... channel) {
        for (Channel ch : channel) {
            if (ch == null || ch.isConnected()) continue;
            ch.close();
        }
    }

    private static void addDiscardProtocol(JChannel ch) throws Exception {
        ProtocolStack stack = ch.getProtocolStack();
        Protocol transport = stack.getTransport();
        DISCARD discard = new DISCARD();
        discard.setProtocolStack(ch.getProtocolStack());
        discard.start();
        stack.insertProtocol(discard, 1, transport.getName());
    }

    private static void modiftFDAndMergeSettings(JChannel ch) {
        MERGE2 merge;
        ProtocolStack stack = ch.getProtocolStack();
        FD fd = (FD)stack.findProtocol("FD");
        if (fd != null) {
            fd.setMaxTries(3);
            fd.setTimeout(1000L);
        }
        if ((merge = (MERGE2)stack.findProtocol("MERGE2")) != null) {
            merge.setMinInterval(5000L);
            merge.setMaxInterval(10000L);
        }
        ch.setReceiver(new ReceiverAdapter(){

            public void viewAccepted(View new_view) {
                System.out.println("** view: " + new_view);
            }
        });
    }
}

