/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.Interval;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.TimeScheduler;

public class AckMcastSenderWindow {
    private static final long SEC = 1000L;
    private static final Interval RETRANSMIT_TIMEOUTS = new StaticInterval(2000L, 3000L, 5000L, 8000L);
    protected static final Log log = LogFactory.getLog(AckMcastSenderWindow.class);
    private final Map<Long, Entry> msgs = new HashMap<Long, Entry>();
    private final LinkedList suspects = new LinkedList();
    private static final int max_suspects = 20;
    private final List stable_msgs = new LinkedList();
    private boolean waiting = false;
    private boolean retransmitter_owned;
    private TimeScheduler timer = null;
    private Interval retransmit_intervals;
    private RetransmitCommand cmd = null;

    private static String _toString(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _retransmit(Entry entry) {
        Entry entry2 = entry;
        synchronized (entry2) {
            Enumeration e = entry.senders.keys();
            while (e.hasMoreElements()) {
                Address sender = (Address)e.nextElement();
                boolean received = (Boolean)entry.senders.get(sender);
                if (received) continue;
                if (this.suspects.contains(sender)) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("removing " + sender + " from retransmit list as it is in the suspect list"));
                    }
                    this.remove(sender);
                    continue;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("--> retransmitting msg #" + entry.seqno + " to " + sender));
                }
                this.cmd.retransmit(entry.seqno, entry.msg.copy(), sender);
            }
        }
    }

    private void init(RetransmitCommand cmd, Interval retransmit_intervals, TimeScheduler timer, boolean sched_owned) {
        if (cmd == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"command is null. Cannot retransmit messages !");
            }
            throw new IllegalArgumentException("cmd");
        }
        this.retransmitter_owned = sched_owned;
        this.timer = timer;
        this.retransmit_intervals = retransmit_intervals;
        this.cmd = cmd;
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, Interval retransmit_intervals, TimeScheduler sched) {
        this.init(cmd, retransmit_intervals, sched, false);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, TimeScheduler sched) {
        this.init(cmd, RETRANSMIT_TIMEOUTS, sched, false);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, Interval retransmit_intervals) {
        this.init(cmd, retransmit_intervals, new TimeScheduler(), true);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd) {
        this(cmd, RETRANSMIT_TIMEOUTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long seqno, Message msg, Vector receivers) {
        if (this.waiting) {
            return;
        }
        if (receivers.isEmpty()) {
            return;
        }
        Map<Long, Entry> map = this.msgs;
        synchronized (map) {
            if (this.msgs.get(new Long(seqno)) != null) {
                return;
            }
            Entry e = new Entry(seqno, msg, receivers, this.retransmit_intervals.copy());
            ScheduledFuture<?> future = this.timer.scheduleWithDynamicInterval(e);
            e.setFuture(future);
            this.msgs.put(new Long(seqno), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(long seqno, Address sender) {
        Map<Long, Entry> map = this.msgs;
        synchronized (map) {
            Entry entry = this.msgs.get(new Long(seqno));
            if (entry == null) {
                return;
            }
            Object object = entry;
            synchronized (object) {
                Boolean received = (Boolean)entry.senders.get(sender);
                if (received == null || received.booleanValue()) {
                    return;
                }
                entry.senders.put(sender, Boolean.TRUE);
                ++entry.num_received;
                if (!entry.allReceived()) {
                    return;
                }
            }
            object = this.stable_msgs;
            synchronized (object) {
                entry.cancel();
                this.msgs.remove(new Long(seqno));
                this.stable_msgs.add(new Long(seqno));
            }
            this.msgs.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Address obj) {
        Map<Long, Entry> map = this.msgs;
        synchronized (map) {
            for (Long key : this.msgs.keySet()) {
                Entry entry = this.msgs.get(key);
                Object object = entry;
                synchronized (object) {
                    Boolean received = (Boolean)entry.senders.remove(obj);
                    if (received == null) {
                        continue;
                    }
                    if (received.booleanValue()) {
                        --entry.num_received;
                    }
                    if (!entry.allReceived()) {
                        continue;
                    }
                }
                object = this.stable_msgs;
                synchronized (object) {
                    entry.cancel();
                    this.msgs.remove(key);
                    this.stable_msgs.add(key);
                }
                this.msgs.notifyAll();
            }
        }
    }

    public void suspect(Address suspected) {
        if (log.isInfoEnabled()) {
            log.info((Object)("suspect is " + suspected));
        }
        this.remove(suspected);
        this.suspects.add(suspected);
        if (this.suspects.size() >= 20) {
            this.suspects.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getStableMessages() {
        LinkedList retval;
        List list = this.stable_msgs;
        synchronized (list) {
            LinkedList linkedList = retval = !this.stable_msgs.isEmpty() ? new LinkedList(this.stable_msgs) : null;
            if (!this.stable_msgs.isEmpty()) {
                this.stable_msgs.clear();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStableMessages() {
        List list = this.stable_msgs;
        synchronized (list) {
            this.stable_msgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        Map<Long, Entry> map = this.msgs;
        synchronized (map) {
            return this.msgs.size();
        }
    }

    public long getNumberOfResponsesExpected(long seqno) {
        Entry entry = this.msgs.get(new Long(seqno));
        if (entry != null) {
            return entry.senders.size();
        }
        return -1L;
    }

    public long getNumberOfResponsesReceived(long seqno) {
        Entry entry = this.msgs.get(new Long(seqno));
        if (entry != null) {
            return entry.num_received;
        }
        return -1L;
    }

    public String printDetails(long seqno) {
        Entry entry = this.msgs.get(new Long(seqno));
        if (entry != null) {
            return entry.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilAllAcksReceived(long timeout) {
        Map<Long, Entry> map;
        for (Address suspect : this.suspects) {
            this.remove(suspect);
        }
        long time_to_wait = timeout;
        this.waiting = true;
        if (timeout <= 0L) {
            map = this.msgs;
            synchronized (map) {
                while (!this.msgs.isEmpty()) {
                    try {
                        this.msgs.wait();
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        long start_time = System.currentTimeMillis();
        map = this.msgs;
        synchronized (map) {
            long current_time;
            while (!this.msgs.isEmpty() && (time_to_wait = timeout - ((current_time = System.currentTimeMillis()) - start_time)) > 0L) {
                try {
                    this.msgs.wait(time_to_wait);
                }
                catch (InterruptedException ex) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)ex.toString());
                }
            }
        }
        this.waiting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Map<Long, Entry> map = this.msgs;
        synchronized (map) {
            block8: {
                if (this.retransmitter_owned) {
                    try {
                        this.timer.stop();
                    }
                    catch (InterruptedException ex) {
                        if (!log.isErrorEnabled()) break block8;
                        log.error((Object)AckMcastSenderWindow._toString(ex));
                    }
                } else {
                    for (Entry entry : this.msgs.values()) {
                        entry.cancel();
                    }
                }
            }
            this.msgs.clear();
            this.msgs.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.waiting) {
            return;
        }
        Map<Long, Entry> map = this.msgs;
        synchronized (map) {
            for (Entry entry : this.msgs.values()) {
                entry.cancel();
            }
            this.msgs.clear();
            this.msgs.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer ret = new StringBuffer();
        Map<Long, Entry> map = this.msgs;
        synchronized (map) {
            ret.append("msgs: (").append(this.msgs.size()).append(')');
            for (Long key : this.msgs.keySet()) {
                Entry entry = this.msgs.get(key);
                ret.append("key = ").append(key).append(", value = ").append(entry).append('\n');
            }
            List list = this.stable_msgs;
            synchronized (list) {
                ret.append("\nstable_msgs: ").append(this.stable_msgs);
            }
        }
        return ret.toString();
    }

    private class Entry
    extends Task {
        public final long seqno;
        public Message msg;
        public final Hashtable senders;
        public int num_received;

        public Entry(long seqno, Message msg, Vector dests, Interval intervals) {
            super(intervals);
            this.msg = null;
            this.senders = new Hashtable();
            this.num_received = 0;
            this.seqno = seqno;
            this.msg = msg;
            for (int i = 0; i < dests.size(); ++i) {
                this.senders.put(dests.elementAt(i), Boolean.FALSE);
            }
        }

        boolean allReceived() {
            return this.num_received >= this.senders.size();
        }

        public void run() {
            AckMcastSenderWindow.this._retransmit(this);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("num_received = ").append(this.num_received).append(", received msgs = ").append(this.senders);
            return buf.toString();
        }
    }

    private static abstract class Task
    implements TimeScheduler.Task {
        private final Interval intervals;
        private Future future;

        protected Task(Interval intervals) {
            this.intervals = intervals;
        }

        public void setFuture(Future future) {
            this.future = future;
        }

        public long nextInterval() {
            return this.intervals.next();
        }

        public void cancel() {
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3, Address var4);
    }
}

